/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class LongSliderEntry
extends TooltipListEntry<Long> {
    protected Slider sliderWidget;
    protected Button resetButton;
    protected AtomicLong value;
    protected final long orginial;
    private long minimum;
    private long maximum;
    private final Supplier<Long> defaultValue;
    private Function<Long, Component> textGetter = value -> Component.m_237113_((String)String.format("Value: %d", value));
    private final List<AbstractWidget> widgets;

    @Deprecated
    @ApiStatus.Internal
    public LongSliderEntry(Component fieldName, long minimum, long maximum, long value, Consumer<Long> saveConsumer, Component resetButtonKey, Supplier<Long> defaultValue) {
        this(fieldName, minimum, maximum, value, saveConsumer, resetButtonKey, defaultValue, null);
    }

    @Deprecated
    @ApiStatus.Internal
    public LongSliderEntry(Component fieldName, long minimum, long maximum, long value, Consumer<Long> saveConsumer, Component resetButtonKey, Supplier<Long> defaultValue, Supplier<Optional<Component[]>> tooltipSupplier) {
        this(fieldName, minimum, maximum, value, saveConsumer, resetButtonKey, defaultValue, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public LongSliderEntry(Component fieldName, long minimum, long maximum, long value2, Consumer<Long> saveConsumer, Component resetButtonKey, Supplier<Long> defaultValue, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.orginial = value2;
        this.defaultValue = defaultValue;
        this.value = new AtomicLong(value2);
        this.saveCallback = saveConsumer;
        this.maximum = maximum;
        this.minimum = minimum;
        this.sliderWidget = new Slider(0, 0, 152, 20, ((double)this.value.get() - (double)minimum) / (double)Math.abs(maximum - minimum));
        this.resetButton = Button.m_253074_((Component)resetButtonKey, widget -> this.setValue((Long)defaultValue.get())).m_252987_(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)resetButtonKey) + 6, 20).m_253136_();
        this.sliderWidget.m_93666_(this.textGetter.apply(this.value.get()));
        this.widgets = Lists.newArrayList((Object[])new AbstractWidget[]{this.sliderWidget, this.resetButton});
    }

    public Function<Long, Component> getTextGetter() {
        return this.textGetter;
    }

    public LongSliderEntry setTextGetter(Function<Long, Component> textGetter) {
        this.textGetter = textGetter;
        this.sliderWidget.m_93666_(textGetter.apply(this.value.get()));
        return this;
    }

    @Override
    public Long getValue() {
        return this.value.get();
    }

    @Deprecated
    public void setValue(long value) {
        this.sliderWidget.setValue((double)(Mth.m_14036_((float)value, (float)this.minimum, (float)this.maximum) - (float)this.minimum) / (double)Math.abs(this.maximum - this.minimum));
        this.value.set(Math.min(Math.max(value, this.minimum), this.maximum));
        this.sliderWidget.m_5695_();
    }

    @Override
    public Optional<Long> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return this.widgets;
    }

    @Override
    public boolean isEdited() {
        return super.isEdited() || this.getValue() != this.orginial;
    }

    public LongSliderEntry setMaximum(long maximum) {
        this.maximum = maximum;
        return this;
    }

    public LongSliderEntry setMinimum(long minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        Window window = Minecraft.m_91087_().m_91268_();
        this.resetButton.f_93623_ = this.isEditable() && this.getDefaultValue().isPresent() && this.defaultValue.get().longValue() != this.value.get();
        this.resetButton.m_253211_(y);
        this.sliderWidget.f_93623_ = this.isEditable();
        this.sliderWidget.m_253211_(y);
        Component displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.m_91087_().f_91062_.m_92718_()) {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, displayedFieldName.m_7532_(), (float)(window.m_85445_() - x - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)displayedFieldName)), (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.m_252865_(x);
            this.sliderWidget.m_252865_(x + this.resetButton.m_5711_() + 1);
        } else {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, displayedFieldName.m_7532_(), (float)x, (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.m_252865_(x + entryWidth - this.resetButton.m_5711_());
            this.sliderWidget.m_252865_(x + entryWidth - 150);
        }
        this.sliderWidget.m_93674_(150 - this.resetButton.m_5711_() - 2);
        this.resetButton.m_86412_(matrices, mouseX, mouseY, delta);
        this.sliderWidget.m_86412_(matrices, mouseX, mouseY, delta);
    }

    private class Slider
    extends AbstractSliderButton {
        protected Slider(int int_1, int int_2, int int_3, int int_4, double double_1) {
            super(int_1, int_2, int_3, int_4, (Component)Component.m_237119_(), double_1);
        }

        public void m_5695_() {
            this.m_93666_(LongSliderEntry.this.textGetter.apply(LongSliderEntry.this.value.get()));
        }

        protected void m_5697_() {
            LongSliderEntry.this.value.set((long)((double)LongSliderEntry.this.minimum + (double)Math.abs(LongSliderEntry.this.maximum - LongSliderEntry.this.minimum) * this.f_93577_));
        }

        public boolean m_7933_(int int_1, int int_2, int int_3) {
            if (!LongSliderEntry.this.isEditable()) {
                return false;
            }
            return super.m_7933_(int_1, int_2, int_3);
        }

        public boolean m_7979_(double double_1, double double_2, int int_1, double double_3, double double_4) {
            if (!LongSliderEntry.this.isEditable()) {
                return false;
            }
            return super.m_7979_(double_1, double_2, int_1, double_3, double_4);
        }

        public double getValue() {
            return this.f_93577_;
        }

        public void setValue(double integer) {
            this.f_93577_ = integer;
        }
    }
}

