/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import info.u_team.u_team_core.util.SiUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageWidget
extends AbstractWidget
implements PerspectiveRenderable,
TooltipRenderable {
    public static final ResourceLocation ENERGY_TEXTURE = new ResourceLocation("uteamcore", "textures/gui/energy.png");
    private final LongSupplier capacity;
    private final LongSupplier storage;
    protected ResourceLocation texture;
    protected RGBA color;

    public EnergyStorageWidget(int x, int y, int height, Supplier<IEnergyStorage> energyStorage) {
        this(x, y, height, () -> ((IEnergyStorage)energyStorage.get()).getMaxEnergyStored(), () -> ((IEnergyStorage)energyStorage.get()).getEnergyStored());
    }

    public EnergyStorageWidget(int x, int y, int height, LongSupplier capacity, LongSupplier storage) {
        super(x, y, 14, height < 3 ? 3 : height, (Component)Component.m_237119_());
        this.capacity = capacity;
        this.storage = storage;
        this.texture = ENERGY_TEXTURE;
        this.color = RGBA.WHITE;
    }

    public void m_87963_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(poseStack, mouseX, mouseY, partialTick);
        this.renderForeground(poseStack, mouseX, mouseY, partialTick);
        WidgetUtil.renderCustomTooltipForWidget(this, poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int yComponent;
        double ratio = (double)this.storage.getAsLong() / (double)this.capacity.getAsLong();
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        int storageOffset = (int)((1.0 - ratio) * (double)(this.f_93619_ - 2));
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderUtil.setShaderColor(this.color);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (yComponent = 1; yComponent < this.f_93619_ - 1; yComponent += 2) {
            RenderUtil.addTexturedQuad(bufferBuilder, poseStack, this.f_93620_ + 1, this.f_93620_ + 1 + 12, this.f_93621_ + yComponent, this.f_93621_ + yComponent + 2, 0.0f, 0.75f, 0.0f, 0.125f, 0.0f);
        }
        for (yComponent = 1 + storageOffset; yComponent < this.f_93619_ - 1; ++yComponent) {
            if (yComponent % 2 == 0) {
                RenderUtil.addTexturedQuad(bufferBuilder, poseStack, this.f_93620_ + 1, this.f_93620_ + 1 + 12, this.f_93621_ + yComponent, this.f_93621_ + yComponent + 1, 0.0f, 0.75f, 0.1875f, 0.25f, 0.0f);
                continue;
            }
            RenderUtil.addTexturedQuad(bufferBuilder, poseStack, this.f_93620_ + 1, this.f_93620_ + 1 + 12, this.f_93621_ + yComponent, this.f_93621_ + yComponent + 1, 0.0f, 0.75f, 0.125f, 0.1875f, 0.0f);
        }
        tessellator.m_85914_();
        RenderSystem.m_69461_();
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RenderUtil.drawContainerBorder(poseStack, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_, 0.0f, RGBA.WHITE);
    }

    @Override
    public void renderTooltip(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_93622_) {
            Object capacityString;
            Object storageString;
            Minecraft minecraft = Minecraft.m_91087_();
            if (!Screen.m_96638_()) {
                storageString = SiUtil.readableSi(this.storage.getAsLong());
                capacityString = SiUtil.readableSi(this.capacity.getAsLong());
            } else {
                storageString = Long.toString(this.storage.getAsLong()) + " ";
                capacityString = Long.toString(this.capacity.getAsLong()) + " ";
            }
            List<MutableComponent> list = List.of(Component.m_237110_((String)"gui.widget.uteamcore.energy.fe_tooltip", (Object[])new Object[]{storageString, capacityString}));
            minecraft.f_91080_.renderTooltip(poseStack, list, Optional.empty(), mouseX, mouseY, minecraft.f_91062_);
        }
    }

    public void m_7435_(SoundManager handler) {
    }

    protected void m_168797_(NarrationElementOutput output) {
    }
}

