/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.annotation;

import com.mojang.logging.LogUtils;
import info.u_team.u_team_core.api.construct.Construct;
import info.u_team.u_team_core.api.construct.ModConstruct;
import info.u_team.u_team_core.api.integration.Integration;
import info.u_team.u_team_core.api.integration.ModIntegration;
import info.u_team.u_team_core.util.annotation.AnnotationUtil;
import java.lang.reflect.InvocationTargetException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AnnotationManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Marker CONSTRUCT_MARKER = MarkerFactory.getMarker((String)"Construct");
    private static final Marker INTEGRATION_MARKER = MarkerFactory.getMarker((String)"Integration");

    public static void callAnnotations(String modid) {
        AnnotationManager.callConstructs(modid);
        AnnotationManager.callIntegrations(modid);
    }

    public static void callConstructs(String modid) {
        for (ModFileScanData.AnnotationData data : AnnotationUtil.getAnnotations(modid, Type.getType(Construct.class))) {
            if (!AnnotationManager.canBeCalled(modid, data)) continue;
            LOGGER.debug(CONSTRUCT_MARKER, "Load construct (" + data.memberName() + ") for mod " + modid);
            try {
                Class.forName(data.memberName()).asSubclass(ModConstruct.class).getConstructor(new Class[0]).newInstance(new Object[0]).construct();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | LinkageError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                LOGGER.error(CONSTRUCT_MARKER, "Failed to load and call mod construct : {}", (Object)data.memberName(), (Object)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public static void callIntegrations(String modid) {
        for (ModFileScanData.AnnotationData data : AnnotationUtil.getAnnotations(modid, Type.getType(Integration.class))) {
            String integrationModid = (String)data.annotationData().get("integration");
            if (!AnnotationManager.canBeCalled(modid, data) || !ModList.get().isLoaded(integrationModid)) continue;
            LOGGER.debug(INTEGRATION_MARKER, "Load " + integrationModid + " integration (" + data.memberName() + ") for mod " + modid);
            try {
                Class.forName(data.memberName()).asSubclass(ModIntegration.class).getConstructor(new Class[0]).newInstance(new Object[0]).construct();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | LinkageError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                LOGGER.error(INTEGRATION_MARKER, "Failed to load and call integration : {}", (Object)data.memberName(), (Object)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    private static boolean canBeCalled(String modid, ModFileScanData.AnnotationData data) {
        String annotationModid = (String)data.annotationData().get("modid");
        Boolean client = (Boolean)data.annotationData().get("client");
        return modid.equals(annotationModid) && (client == null || client == false || client != false && FMLEnvironment.dist == Dist.CLIENT);
    }
}

