/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.registry;

import info.u_team.u_team_core.api.block.BlockItemProvider;
import info.u_team.u_team_core.util.registry.BlockRegistryObject;
import info.u_team.u_team_core.util.registry.CommonDeferredRegister;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class BlockDeferredRegister
implements Iterable<RegistryObject<Block>> {
    private final CommonDeferredRegister<Block> blocks;
    private final CommonDeferredRegister<Item> items;
    private final Map<RegistryObject<? extends Block>, RegistryObject<? extends Item>> blockToItemsMap;

    public static BlockDeferredRegister create(String modid) {
        return new BlockDeferredRegister(modid);
    }

    protected BlockDeferredRegister(String modid) {
        this.blocks = CommonDeferredRegister.create(ForgeRegistries.BLOCKS, modid);
        this.items = CommonDeferredRegister.create(ForgeRegistries.ITEMS, modid);
        this.blockToItemsMap = new LinkedHashMap<RegistryObject<? extends Block>, RegistryObject<? extends Item>>();
    }

    public <B extends Block, I extends BlockItem> BlockRegistryObject<B, I> register(String name, Supplier<? extends B> supplier) {
        RegistryObject<? extends B> block = this.blocks.register(name, supplier);
        RegistryObject item = RegistryObject.create((ResourceLocation)new ResourceLocation(this.blocks.getModid(), name), (IForgeRegistry)ForgeRegistries.ITEMS);
        this.blockToItemsMap.put(block, (RegistryObject<? extends Item>)item);
        return new BlockRegistryObject(block, item);
    }

    public <B extends Block, I extends BlockItem> BlockRegistryObject<B, I> register(String name, Supplier<? extends B> blockSupplier, Supplier<? extends I> itemSupplier) {
        RegistryObject<? extends B> block = this.blocks.register(name, blockSupplier);
        RegistryObject<? extends I> item = this.items.register(name, itemSupplier);
        return new BlockRegistryObject<B, I>(block, item);
    }

    public <B extends Block> RegistryObject<B> registerBlock(String name, Supplier<? extends B> supplier) {
        return this.blocks.register(name, supplier);
    }

    public void register(IEventBus bus) {
        this.blocks.register(bus);
        this.items.register(bus);
        bus.addListener(this::registerItems);
    }

    private void registerItems(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
            this.blockToItemsMap.forEach((? super K blockObject, ? super V itemObject) -> {
                BlockItemProvider blockItemProvider;
                Item blockItem;
                Block block = (Block)blockObject.get();
                if (block instanceof BlockItemProvider && (blockItem = (blockItemProvider = (BlockItemProvider)block).blockItem()) != null) {
                    event.register(ForgeRegistries.Keys.ITEMS, itemObject.getId(), () -> blockItem);
                }
            });
        }
    }

    @Override
    public Iterator<RegistryObject<Block>> iterator() {
        return this.blocks.iterator();
    }

    public Iterable<Block> blockIterable() {
        return this.blocks.entryIterable();
    }

    public Iterable<Item> itemIterable() {
        return () -> this.blocks.getEntries().stream().map(block -> {
            Item item = ((Block)block.get()).m_5456_();
            if (item != null && item != Items.f_41852_) {
                return Optional.of(item);
            }
            return Optional.empty();
        }).flatMap(Optional::stream).iterator();
    }

    public CommonDeferredRegister<Block> getBlockRegister() {
        return this.blocks;
    }

    public CommonDeferredRegister<Item> getItemRegister() {
        return this.items;
    }
}

