/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.api;

import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.ChestType;

public enum EsChestType implements StringRepresentable
{
    TOP(-1),
    BOTTOM(-1),
    FRONT(0),
    BACK(2),
    LEFT(1),
    RIGHT(3),
    SINGLE(-1);

    private final String name = this.name().toLowerCase(Locale.ROOT);
    private final int offset;

    private EsChestType(int offset) {
        this.offset = offset;
    }

    public static EsChestType from(ChestType value) {
        return switch (value) {
            default -> throw new IncompatibleClassChangeError();
            case ChestType.SINGLE -> SINGLE;
            case ChestType.LEFT -> RIGHT;
            case ChestType.RIGHT -> LEFT;
        };
    }

    public String m_7912_() {
        return this.name;
    }

    public EsChestType getOpposite() {
        if (this == TOP) {
            return BOTTOM;
        }
        if (this == BOTTOM) {
            return TOP;
        }
        if (this == FRONT) {
            return BACK;
        }
        if (this == BACK) {
            return FRONT;
        }
        if (this == LEFT) {
            return RIGHT;
        }
        if (this == RIGHT) {
            return LEFT;
        }
        throw new IllegalStateException("EsChestType.SINGLE has no opposite type.");
    }

    public int getOffset() {
        return this.offset;
    }
}

