/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.api.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import ellemes.expandedstorage.api.client.ScreenConstructor;
import ellemes.expandedstorage.api.client.function.ScreenSize;
import ellemes.expandedstorage.api.client.function.ScreenSizeRetriever;
import ellemes.expandedstorage.api.client.gui.CopyFunction;
import ellemes.expandedstorage.api.inventory.AbstractHandler;
import ellemes.expandedstorage.common.CommonClient;
import ellemes.expandedstorage.common.client.MiniStorageScreen;
import ellemes.expandedstorage.common.client.SizedSimpleTexture;
import ellemes.expandedstorage.common.client.gui.FakePickScreen;
import ellemes.expandedstorage.common.client.gui.PickScreen;
import ellemes.expandedstorage.common.misc.ErrorlessTextureGetter;
import ellemes.expandedstorage.common.misc.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreen
extends AbstractContainerScreen<AbstractHandler> {
    private static final Map<ResourceLocation, ScreenConstructor<?>> SCREEN_CONSTRUCTORS = new HashMap();
    private static final Map<ResourceLocation, ScreenSizeRetriever> SIZE_RETRIEVERS = new HashMap<ResourceLocation, ScreenSizeRetriever>();
    private static final Set<ResourceLocation> PREFERS_SINGLE_SCREEN = new HashSet<ResourceLocation>();
    protected final int inventoryWidth;
    protected final int inventoryHeight;
    protected final int totalSlots;
    protected final ResourceLocation textureLocation;
    protected final int textureWidth;
    protected final int textureHeight;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractScreen(AbstractHandler handler, Inventory playerInventory, Component title, ScreenSize screenSize) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.totalSlots = handler.getInventory().m_6643_();
        this.inventoryWidth = screenSize.getWidth();
        this.inventoryHeight = screenSize.getHeight();
        ResourceLocation resourceLocation = this.textureLocation = this instanceof MiniStorageScreen ? Utils.id("textures/gui/container/mini_chest_screen.png") : Utils.id("textures/gui/container/shared_" + this.inventoryWidth + "_" + this.inventoryHeight + ".png");
        if (!(this instanceof FakePickScreen)) {
            AbstractTexture texture;
            boolean isTexturePresent = ((ErrorlessTextureGetter)Minecraft.m_91087_().m_91097_()).expandedstorage$isTexturePresent(this.textureLocation);
            if (!isTexturePresent && !(this instanceof MiniStorageScreen)) {
                int guiWidth = 36 + 18 * this.inventoryWidth;
                int guiHeight = 132 + 18 * this.inventoryHeight;
                int textureWidth = (int)(Math.ceil((float)guiWidth / 16.0f) * 16.0);
                int textureHeight = (int)(Math.ceil((float)guiHeight / 16.0f) * 16.0);
                RenderSystem.m_157456_((int)0, (ResourceLocation)Utils.id("textures/gui/container/atlas_gen.png"));
                RenderSystem.m_69396_((int)RenderSystem.m_157203_((int)0));
                try (NativeImage atlas = new NativeImage(96, 96, false);){
                    atlas.m_85045_(0, false);
                    try (NativeImage image = new NativeImage(textureWidth, textureHeight, false);){
                        image.m_84997_(0, 0, textureWidth, textureHeight, 0xFFFFFF);
                        AbstractScreen.renderGui(this.inventoryWidth, this.inventoryHeight, (destX, destY, w, h, srcX, srcY) -> atlas.m_260930_(image, srcX, srcY, destX, destY, w, h, false, false));
                        if (Utils.textureSaveRoot != null) {
                            try {
                                image.m_85066_(Utils.textureSaveRoot.resolve("shared_" + this.inventoryWidth + "_" + this.inventoryHeight + ".png"));
                            }
                            catch (IOException e) {
                                System.out.println("Failed to save genned image.");
                            }
                        }
                        DynamicTexture texture2 = new DynamicTexture(image);
                        Minecraft.m_91087_().m_91097_().m_118495_(this.textureLocation, (AbstractTexture)texture2);
                    }
                }
            }
            if ((texture = Minecraft.m_91087_().m_91097_().m_118506_(this.textureLocation)) instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)texture;
                this.textureWidth = dynamicTexture.m_117991_().m_84982_();
                this.textureHeight = dynamicTexture.m_117991_().m_85084_();
                return;
            } else {
                if (!(texture instanceof SizedSimpleTexture)) throw new IllegalStateException();
                SizedSimpleTexture simpleTexture = (SizedSimpleTexture)texture;
                this.textureWidth = simpleTexture.getWidth();
                this.textureHeight = simpleTexture.getHeight();
            }
            return;
        }
        this.textureWidth = 0;
        this.textureHeight = 0;
    }

    public static void renderGui(int inventoryWidth, int inventoryHeight, CopyFunction function) {
        int x;
        int x2;
        int x3;
        function.apply(0, 0, 7, 17, 1, 1);
        for (x3 = 0; x3 < inventoryWidth; ++x3) {
            function.apply(7 + x3 * 18, 0, 18, 17, 9, 1);
        }
        function.apply(7 + inventoryWidth * 18, 0, 7, 17, 28, 1);
        function.apply(7 + inventoryWidth * 18 + 7, 0, 22, 17, 36, 1);
        for (int y = 0; y < inventoryHeight; ++y) {
            int scollbarYOffset = y == 0 ? 19 : (y == inventoryHeight - 1 ? 57 : 38);
            function.apply(0, 17 + 18 * y, 7, 18, 1, 19);
            for (x2 = 0; x2 < inventoryWidth; ++x2) {
                function.apply(7 + 18 * x2, 17 + 18 * y, 18, 18, 9, 19);
            }
            function.apply(7 + 18 * inventoryWidth, 17 + 18 * y, 7, 18, 28, 19);
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * y, 22, 18, 36, scollbarYOffset);
        }
        function.apply(0, 17 + 18 * inventoryHeight, 7, 14, 1, 38);
        for (x3 = 0; x3 < inventoryWidth; ++x3) {
            function.apply(7 + 18 * x3, 17 + 18 * inventoryHeight, 18, 14, 9, 38);
        }
        function.apply(7 + 18 * inventoryWidth, 17 + 18 * inventoryHeight, 7, 14, 28, 38);
        if (inventoryWidth > 9) {
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight, 22, 17, 59, 76);
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight + 17, 12, 15, 59, 1);
        } else {
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight, 22, 7, 36, 76);
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight + 7, 12, 15, 59, 1);
        }
        if (inventoryWidth > 9) {
            function.apply(0, 17 + 18 * inventoryHeight + 7 + 3, 7, 7, 1, 58);
            int sideParts = (int)Math.ceil((float)(inventoryWidth - 9) / 2.0f);
            for (int i = 0; i < sideParts; ++i) {
                function.apply(7 + 18 * i, 17 + 18 * inventoryHeight + 7 + 3, 18, 7, 9, 58);
                function.apply(7 + 18 * (inventoryWidth - i - 1), 17 + 18 * inventoryHeight + 7 + 3, 18, 7, 9, 58);
            }
            function.apply(7 + 18 * inventoryWidth, 17 + 18 * inventoryHeight + 7 + 3, 7, 7, 28, 58);
        }
        int startX = (int)((float)(inventoryWidth - 9) / 2.0f * 18.0f);
        for (int y = 0; y < 3; ++y) {
            function.apply(startX, 17 + 18 * (inventoryHeight + y) + 14, 7, 18, 1, 19);
            for (x2 = 0; x2 < 9; ++x2) {
                function.apply(startX + 7 + 18 * x2, 17 + 18 * (inventoryHeight + y) + 14, 18, 18, 9, 19);
            }
            function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + y) + 14, 7, 18, 28, 19);
        }
        function.apply(startX, 17 + 18 * (inventoryHeight + 3) + 14, 7, 4, 1, 53);
        function.apply(startX, 17 + 18 * (inventoryHeight + 3) + 14 + 4, 7, 18, 1, 19);
        function.apply(startX, 17 + 18 * (inventoryHeight + 4) + 14 + 4, 7, 7, 1, 58);
        for (x = 0; x < 9; ++x) {
            function.apply(startX + 7 + 18 * x, 17 + 18 * (inventoryHeight + 3) + 14, 18, 4, 9, 53);
            function.apply(startX + 7 + 18 * x, 17 + 18 * (inventoryHeight + 3) + 14 + 4, 18, 18, 9, 19);
            function.apply(startX + 7 + 18 * x, 17 + 18 * (inventoryHeight + 4) + 14 + 4, 18, 7, 9, 58);
        }
        function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + 3) + 14, 7, 4, 28, 53);
        function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + 3) + 14 + 4, 7, 18, 28, 19);
        function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + 4) + 14 + 4, 7, 7, 28, 58);
        if (inventoryWidth > 9) {
            function.apply(startX, 17 + 18 * inventoryHeight + 14, 3, 3, 20, 66);
            function.apply(startX + 162 + 11, 17 + 18 * inventoryHeight + 14, 3, 3, 24, 66);
        }
        for (x = 0; x < inventoryWidth; ++x) {
            function.apply(7 + 18 * x, 17 + 18 * (inventoryHeight + 4) + 14 + 4 + 7, 18, 18, 1, 66);
        }
    }

    public static AbstractScreen createScreen(AbstractHandler handler, Inventory playerInventory, Component title) {
        ScreenSize screenSize;
        ResourceLocation forcedScreenType = handler.getForcedScreenType();
        ResourceLocation preference = forcedScreenType != null ? forcedScreenType : CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int scaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        int slots = handler.getInventory().m_6643_();
        if (forcedScreenType == null && AbstractScreen.canSingleScreenDisplay(slots, scaledWidth, scaledHeight) && AbstractScreen.shouldPreferSingleScreen(preference)) {
            preference = Utils.SINGLE_SCREEN_TYPE;
        }
        if ((screenSize = SIZE_RETRIEVERS.get(preference).get(slots, scaledWidth, scaledHeight)) == null) {
            throw new IllegalStateException("screenSize should never be null...");
        }
        return SCREEN_CONSTRUCTORS.get(preference).createScreen(handler, playerInventory, title, screenSize);
    }

    private static boolean shouldPreferSingleScreen(ResourceLocation type) {
        return PREFERS_SINGLE_SCREEN.contains(type);
    }

    private static boolean canSingleScreenDisplay(int slots, int scaledWidth, int scaledHeight) {
        if (slots <= 54) {
            return true;
        }
        if (scaledHeight >= 276) {
            if (slots <= 81) {
                return true;
            }
            if (scaledWidth >= 230 && slots <= 108) {
                return true;
            }
            if (scaledWidth >= 284 && slots <= 135) {
                return true;
            }
            if (scaledWidth >= 338 && slots <= 162) {
                return true;
            }
        }
        if (scaledWidth >= 338) {
            if (scaledHeight >= 330 && slots <= 216) {
                return true;
            }
            return scaledHeight >= 384 && slots <= 270;
        }
        return false;
    }

    public static void declareScreenType(ResourceLocation type, ScreenConstructor<?> screenConstructor) {
        SCREEN_CONSTRUCTORS.putIfAbsent(type, screenConstructor);
    }

    public static void declareScreenSizeRetriever(ResourceLocation type, ScreenSizeRetriever retriever) {
        SIZE_RETRIEVERS.putIfAbsent(type, retriever);
    }

    public static boolean isScreenTypeDeclared(ResourceLocation type) {
        return SCREEN_CONSTRUCTORS.containsKey(type);
    }

    public static void setPrefersSingleScreen(ResourceLocation type) {
        PREFERS_SINGLE_SCREEN.add(type);
    }

    @Nullable
    public static ScreenSize getScreenSize(ResourceLocation type, int slots, int scaledWidth, int scaledHeight) {
        return SIZE_RETRIEVERS.get(type).get(slots, scaledWidth, scaledHeight);
    }

    public void m_86412_(PoseStack stack, int mouseX, int mouseY, float delta) {
        this.m_7333_(stack);
        super.m_86412_(stack, mouseX, mouseY, delta);
        this.m_7025_(stack, mouseX, mouseY);
    }

    public final boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (CommonClient.platformHelper().isConfigKeyPressed(keyCode, scanCode, modifiers) && ((AbstractHandler)this.f_97732_).getForcedScreenType() == null && !CommonClient.platformHelper().configWrapper().getPreferredScreenType().equals((Object)Utils.UNSET_SCREEN_TYPE)) {
            this.f_96541_.m_91152_((Screen)new PickScreen(this));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @NotNull
    @ApiStatus.OverrideOnly
    public List<Rect2i> getExclusionZones() {
        return List.of();
    }

    public int getInventoryWidth() {
        return this.inventoryWidth;
    }
}

