/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.api.v3.client;

import ellemes.expandedstorage.api.client.ScreenConstructor;
import ellemes.expandedstorage.api.client.function.ScreenSizePredicate;
import ellemes.expandedstorage.api.client.function.ScreenSizeRetriever;
import ellemes.expandedstorage.api.client.gui.AbstractScreen;
import ellemes.expandedstorage.common.client.gui.PickScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScreenTypeApi {
    private ScreenTypeApi() {
        throw new IllegalStateException("ScreenTypeApi should not be instantiated.");
    }

    public static void registerScreenButton(ResourceLocation type, ResourceLocation texture, Component title, ScreenSizePredicate warningTest, List<Component> warningText) {
        ScreenTypeApi.requiresNonNull(type, "type");
        ScreenTypeApi.requiresNonNull(texture, "texture");
        ScreenTypeApi.requiresNonNull(title, "title");
        ScreenTypeApi.requiresNonNull(warningTest, "warningTest");
        ScreenTypeApi.requiresNonNull(warningText, "warningText");
        PickScreen.declareButtonSettings(type, texture, title, warningTest, warningText);
    }

    public static void registerScreenButton(ResourceLocation type, ResourceLocation texture, Component title) {
        ScreenTypeApi.requiresNonNull(type, "type");
        ScreenTypeApi.requiresNonNull(texture, "texture");
        ScreenTypeApi.requiresNonNull(title, "title");
        PickScreen.declareButtonSettings(type, texture, title, ScreenSizePredicate::noTest, List.of());
    }

    public static void registerScreenType(ResourceLocation type, ScreenConstructor<?> screenConstructor) {
        ScreenTypeApi.requiresNonNull(type, "type");
        ScreenTypeApi.requiresNonNull(screenConstructor, "screenConstructor");
        AbstractScreen.declareScreenType(type, screenConstructor);
    }

    public static void registerDefaultScreenSize(ResourceLocation type, ScreenSizeRetriever retriever) {
        ScreenTypeApi.requiresNonNull(type, "type");
        ScreenTypeApi.requiresNonNull(retriever, "retriever");
        AbstractScreen.declareScreenSizeRetriever(type, retriever);
    }

    public static void setPrefersSingleScreen(ResourceLocation type) {
        ScreenTypeApi.requiresNonNull(type, "type");
        AbstractScreen.setPrefersSingleScreen(type);
    }

    private static void requiresNonNull(Object value, String parameterName) {
        Objects.requireNonNull(value, parameterName + " must not be null");
    }
}

