/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.api.v3.helpers;

import ellemes.expandedstorage.api.helpers.VariableInventory;
import ellemes.expandedstorage.api.v3.OpenableInventory;
import java.util.Arrays;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;

public class OpenableInventories
implements OpenableInventory {
    private final OpenableInventory[] parts;
    private final Container inventory;
    private final Component inventoryTitle;

    private OpenableInventories(Component inventoryTitle, OpenableInventory ... parts) {
        this.parts = parts;
        this.inventory = VariableInventory.of((Container[])Arrays.stream(parts).map(OpenableInventory::getInventory).toArray(Container[]::new));
        this.inventoryTitle = inventoryTitle;
    }

    public static OpenableInventory of(Component inventoryTitle, OpenableInventory ... parts) {
        return new OpenableInventories(inventoryTitle, parts);
    }

    @Override
    public boolean canBeUsedBy(ServerPlayer player) {
        for (OpenableInventory part : this.parts) {
            if (part.canBeUsedBy(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public Component getInventoryTitle() {
        return this.inventoryTitle;
    }
}

