/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common;

import ellemes.expandedstorage.api.v3.client.ScreenTypeApi;
import ellemes.expandedstorage.common.block.MiniStorageBlock;
import ellemes.expandedstorage.common.client.gui.FakePickScreen;
import ellemes.expandedstorage.common.client.gui.PageScreen;
import ellemes.expandedstorage.common.client.gui.ScrollScreen;
import ellemes.expandedstorage.common.client.gui.SingleScreen;
import ellemes.expandedstorage.common.item.MutationMode;
import ellemes.expandedstorage.common.item.StorageMutator;
import ellemes.expandedstorage.common.misc.ClientPlatformHelper;
import ellemes.expandedstorage.common.misc.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CommonClient {
    private static ClientPlatformHelper platformHelper;

    public static void initialize(ClientPlatformHelper helper) {
        platformHelper = helper;
        ScreenTypeApi.registerScreenButton(Utils.PAGE_SCREEN_TYPE, Utils.id("textures/gui/page_button.png"), (Component)Component.m_237115_((String)"screen.ellemes_container_lib.page_screen"));
        ScreenTypeApi.registerScreenButton(Utils.SCROLL_SCREEN_TYPE, Utils.id("textures/gui/scroll_button.png"), (Component)Component.m_237115_((String)"screen.ellemes_container_lib.scroll_screen"));
        ScreenTypeApi.registerScreenButton(Utils.SINGLE_SCREEN_TYPE, Utils.id("textures/gui/single_button.png"), (Component)Component.m_237115_((String)"screen.ellemes_container_lib.single_screen"), (scaledWidth, scaledHeight) -> scaledWidth < 370 || scaledHeight < 386, List.of(Component.m_237115_((String)"screen.ellemes_container_lib.off_screen_warning_1").m_130940_(ChatFormatting.GRAY), Component.m_237115_((String)"screen.ellemes_container_lib.off_screen_warning_2").m_130940_(ChatFormatting.GRAY)));
        ScreenTypeApi.registerScreenType(Utils.UNSET_SCREEN_TYPE, FakePickScreen::new);
        ScreenTypeApi.registerScreenType(Utils.PAGE_SCREEN_TYPE, PageScreen::new);
        ScreenTypeApi.registerScreenType(Utils.SCROLL_SCREEN_TYPE, ScrollScreen::new);
        ScreenTypeApi.registerScreenType(Utils.SINGLE_SCREEN_TYPE, SingleScreen::new);
        ScreenTypeApi.registerDefaultScreenSize(Utils.UNSET_SCREEN_TYPE, FakePickScreen::retrieveScreenSize);
        ScreenTypeApi.registerDefaultScreenSize(Utils.PAGE_SCREEN_TYPE, PageScreen::retrieveScreenSize);
        ScreenTypeApi.registerDefaultScreenSize(Utils.SCROLL_SCREEN_TYPE, ScrollScreen::retrieveScreenSize);
        ScreenTypeApi.registerDefaultScreenSize(Utils.SINGLE_SCREEN_TYPE, SingleScreen::retrieveScreenSize);
        ScreenTypeApi.setPrefersSingleScreen(Utils.PAGE_SCREEN_TYPE);
        ScreenTypeApi.setPrefersSingleScreen(Utils.SCROLL_SCREEN_TYPE);
    }

    public static float hasSparrowProperty(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int i) {
        return MiniStorageBlock.hasSparrowProperty(stack) ? 1.0f : 0.0f;
    }

    public static float currentMutatorToolMode(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int i) {
        boolean isSparrow;
        MutationMode mode = StorageMutator.getMode(stack);
        boolean bl = isSparrow = stack.m_41788_() && stack.m_41786_().getString().equalsIgnoreCase("sparrow");
        if (mode == MutationMode.SWAP_THEME) {
            if (isSparrow) {
                return 1.0f;
            }
            return 0.8f;
        }
        if (mode == MutationMode.ROTATE) {
            return 0.6f;
        }
        if (mode == MutationMode.SPLIT) {
            return 0.4f;
        }
        if (mode == MutationMode.MERGE) {
            return 0.2f;
        }
        return 0.0f;
    }

    public static ClientPlatformHelper platformHelper() {
        return platformHelper;
    }
}

