/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.block;

import ellemes.expandedstorage.api.v3.OpenableInventory;
import ellemes.expandedstorage.api.v3.context.BlockContext;
import ellemes.expandedstorage.common.CommonMain;
import ellemes.expandedstorage.common.block.OpenableBlock;
import ellemes.expandedstorage.common.misc.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniStorageBlock
extends OpenableBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape NO_RIBBON_NO_SPARROW = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape RIBBON_NO_SPARROW = Shapes.m_83110_((VoxelShape)NO_RIBBON_NO_SPARROW, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    private static final VoxelShape NO_RIBBON_SPARROW_NS = Shapes.m_83110_((VoxelShape)NO_RIBBON_NO_SPARROW, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)5.0, (double)10.0, (double)13.0, (double)11.0));
    private static final VoxelShape NO_RIBBON_SPARROW_EW = Shapes.m_83110_((VoxelShape)NO_RIBBON_NO_SPARROW, (VoxelShape)Block.m_49796_((double)5.0, (double)8.0, (double)6.0, (double)11.0, (double)13.0, (double)10.0));
    private static final VoxelShape RIBBON_SPARROW_NS = Shapes.m_83110_((VoxelShape)NO_RIBBON_NO_SPARROW, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)5.0, (double)10.0, (double)14.0, (double)11.0));
    private static final VoxelShape RIBBON_SPARROW_EW = Shapes.m_83110_((VoxelShape)NO_RIBBON_NO_SPARROW, (VoxelShape)Block.m_49796_((double)5.0, (double)8.0, (double)6.0, (double)11.0, (double)14.0, (double)10.0));
    public static final BooleanProperty SPARROW = BooleanProperty.m_61465_((String)"sparrow");
    private final boolean hasRibbon;

    public MiniStorageBlock(BlockBehaviour.Properties settings, ResourceLocation openingStat, boolean hasRibbon) {
        super(settings, openingStat, 1);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SPARROW, (Comparable)Boolean.valueOf(false)));
        this.hasRibbon = hasRibbon;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter blockLevel, BlockPos pos, CollisionContext context) {
        boolean hasSparrow;
        boolean bl = hasSparrow = state.m_61138_((Property)SPARROW) && (Boolean)state.m_61143_((Property)SPARROW) != false;
        if (this.hasRibbon) {
            if (hasSparrow) {
                return ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122416_() % 2 == 0 ? RIBBON_SPARROW_NS : RIBBON_SPARROW_EW;
            }
            return RIBBON_NO_SPARROW;
        }
        if (hasSparrow) {
            return ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122416_() % 2 == 0 ? NO_RIBBON_SPARROW_NS : NO_RIBBON_SPARROW_EW;
        }
        return NO_RIBBON_NO_SPARROW;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean placingInWater = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        boolean isSparrowItem = MiniStorageBlock.hasSparrowProperty(context.m_43722_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(placingInWater))).m_61124_((Property)SPARROW, (Comparable)Boolean.valueOf(isSparrowItem));
    }

    public static boolean hasSparrowProperty(ItemStack stack) {
        Tag blockStateTag;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (blockStateTag = tag.m_128423_("BlockStateTag")) != null && blockStateTag.m_7060_() == 10) {
            return ((CompoundTag)blockStateTag).m_128461_("sparrow").equals("true");
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_, SPARROW});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return CommonMain.getMiniStorageBlockEntityType().m_155264_(pos, state);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    @Override
    public OpenableInventory getOpenableInventory(BlockContext context) {
        BlockEntity blockEntity = context.getLevel().m_7702_(context.getBlockPos());
        if (blockEntity instanceof OpenableInventory) {
            OpenableInventory inventory = (OpenableInventory)blockEntity;
            return inventory;
        }
        return null;
    }

    @Override
    public ResourceLocation getForcedScreenType() {
        return Utils.id("mini_chest");
    }
}

