/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.block;

import ellemes.expandedstorage.api.v3.OpenableInventoryProvider;
import ellemes.expandedstorage.api.v3.context.BlockContext;
import ellemes.expandedstorage.api.v4.InventoryOpeningApi;
import ellemes.expandedstorage.common.CommonMain;
import ellemes.expandedstorage.common.block.entity.extendable.OpenableBlockEntity;
import ellemes.expandedstorage.common.registration.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class OpenableBlock
extends Block
implements OpenableInventoryProvider<BlockContext>,
EntityBlock {
    private final ResourceLocation openingStat;
    private final int slotCount;

    public OpenableBlock(BlockBehaviour.Properties settings, ResourceLocation openingStat, int slotCount) {
        super(settings);
        this.openingStat = openingStat;
        this.slotCount = slotCount;
    }

    public Component getInventoryTitle() {
        MutableComponent result = this.m_49954_();
        return Component.m_237113_((String)result.getString().replace("Waxed ", ""));
    }

    public final ResourceLocation getBlockId() {
        return this.m_204297_().m_205785_().m_135782_();
    }

    public final int getSlotCount() {
        return this.slotCount;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (this == ModBlocks.BAMBOO_CHEST && CommonMain.platformHelper().canDestroyBamboo(player.m_21205_())) {
            return 1.0f;
        }
        return super.m_5880_(state, player, level, pos);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bl) {
        BlockEntity blockEntity;
        if (state.m_60734_().getClass() != newState.m_60734_().getClass()) {
            BlockEntity blockEntity2 = level.m_7702_(pos);
            if (blockEntity2 instanceof OpenableBlockEntity) {
                OpenableBlockEntity entity = (OpenableBlockEntity)blockEntity2;
                Containers.m_19010_((Level)level, (BlockPos)pos, entity.getItems());
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, bl);
        } else if (state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof OpenableBlockEntity) {
            OpenableBlockEntity entity = (OpenableBlockEntity)blockEntity;
            CompoundTag tag = entity.m_187482_();
            level.m_46747_(pos);
            BlockEntity blockEntity3 = level.m_7702_(pos);
            if (blockEntity3 instanceof OpenableBlockEntity) {
                OpenableBlockEntity newEntity = (OpenableBlockEntity)blockEntity3;
                newEntity.m_142466_(tag);
            }
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof OpenableBlockEntity) {
            OpenableBlockEntity entity = (OpenableBlockEntity)blockEntity;
            entity.setCustomName(stack.m_41786_());
        }
    }

    @Override
    public void onInitialOpen(ServerPlayer player) {
        player.m_36220_(this.openingStat);
        if (!player.m_9236_().m_5776_()) {
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isClient = level.m_5776_();
        if (!isClient) {
            InventoryOpeningApi.openBlockInventory((ServerPlayer)player, pos, this);
        }
        return InteractionResult.m_19078_((boolean)isClient);
    }
}

