/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.block.entity.extendable;

import ellemes.expandedstorage.common.block.entity.extendable.OpenableBlockEntity;
import ellemes.expandedstorage.common.block.strategies.Observable;
import ellemes.expandedstorage.common.misc.WrappedInventory;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryBlockEntity
extends OpenableBlockEntity
implements WrappedInventory {
    private final NonNullList<ItemStack> items;
    private Observable observable;
    private final WorldlyContainer inventory = new WorldlyContainer(){
        private int[] availableSlots;

        public int[] m_7071_(Direction side) {
            if (this.availableSlots == null) {
                this.availableSlots = IntStream.range(0, this.m_6643_()).toArray();
            }
            return this.availableSlots;
        }

        public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
            return true;
        }

        public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
            return true;
        }

        public int m_6643_() {
            return InventoryBlockEntity.this.items.size();
        }

        public boolean m_7983_() {
            for (ItemStack stack : InventoryBlockEntity.this.items) {
                if (stack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int slot) {
            return (ItemStack)InventoryBlockEntity.this.items.get(slot);
        }

        public ItemStack m_7407_(int slot, int amount) {
            ItemStack stack = ContainerHelper.m_18969_(InventoryBlockEntity.this.items, (int)slot, (int)amount);
            if (!stack.m_41619_()) {
                this.m_6596_();
            }
            return stack;
        }

        public ItemStack m_8016_(int slot) {
            return ContainerHelper.m_18966_(InventoryBlockEntity.this.items, (int)slot);
        }

        public void m_6836_(int slot, ItemStack stack) {
            if (stack.m_41613_() > this.m_6893_()) {
                stack.m_41764_(this.m_6893_());
            }
            InventoryBlockEntity.this.items.set(slot, (Object)stack);
            this.m_6596_();
        }

        public void m_6596_() {
            InventoryBlockEntity.this.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return InventoryBlockEntity.this.isValidAndPlayerInRange(player);
        }

        public void m_6211_() {
            InventoryBlockEntity.this.items.clear();
        }

        public void m_5856_(Player player) {
            if (player.m_5833_() || InventoryBlockEntity.this.observable == null) {
                return;
            }
            InventoryBlockEntity.this.observable.playerStartViewing(player);
        }

        public void m_5785_(Player player) {
            if (player.m_5833_() || InventoryBlockEntity.this.observable == null) {
                return;
            }
            InventoryBlockEntity.this.observable.playerStopViewing(player);
        }
    };

    public InventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ResourceLocation blockId, Component defaultName, int inventorySize) {
        super(type, pos, state, blockId, defaultName);
        this.items = NonNullList.m_122780_((int)inventorySize, (Object)ItemStack.f_41583_);
    }

    @Override
    public final WorldlyContainer getInventory() {
        return this.inventory;
    }

    @Override
    public final NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    protected void setObservable(Observable observable) {
        if (this.observable == null) {
            this.observable = observable;
        }
    }
}

