/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.block.misc;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import ellemes.expandedstorage.common.registration.ModBlocks;
import java.util.Optional;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CopperBlockHelper {
    private static final BiMap<Block, Block> OXIDISATION_MAP = ImmutableBiMap.builder().put((Object)ModBlocks.COPPER_BARREL, (Object)ModBlocks.EXPOSED_COPPER_BARREL).put((Object)ModBlocks.EXPOSED_COPPER_BARREL, (Object)ModBlocks.WEATHERED_COPPER_BARREL).put((Object)ModBlocks.WEATHERED_COPPER_BARREL, (Object)ModBlocks.OXIDIZED_COPPER_BARREL).put((Object)ModBlocks.COPPER_MINI_BARREL, (Object)ModBlocks.EXPOSED_COPPER_MINI_BARREL).put((Object)ModBlocks.EXPOSED_COPPER_MINI_BARREL, (Object)ModBlocks.WEATHERED_COPPER_MINI_BARREL).put((Object)ModBlocks.WEATHERED_COPPER_MINI_BARREL, (Object)ModBlocks.OXIDIZED_COPPER_MINI_BARREL).build();
    private static final BiMap<Block, Block> INVERSE_MAP = OXIDISATION_MAP.inverse();
    private static final BiMap<Block, Block> DEWAXED_MAP = ImmutableBiMap.builder().put((Object)ModBlocks.WAXED_COPPER_BARREL, (Object)ModBlocks.COPPER_BARREL).put((Object)ModBlocks.WAXED_EXPOSED_COPPER_BARREL, (Object)ModBlocks.EXPOSED_COPPER_BARREL).put((Object)ModBlocks.WAXED_WEATHERED_COPPER_BARREL, (Object)ModBlocks.WEATHERED_COPPER_BARREL).put((Object)ModBlocks.WAXED_OXIDIZED_COPPER_BARREL, (Object)ModBlocks.OXIDIZED_COPPER_BARREL).put((Object)ModBlocks.WAXED_COPPER_MINI_BARREL, (Object)ModBlocks.COPPER_MINI_BARREL).put((Object)ModBlocks.WAXED_EXPOSED_COPPER_MINI_BARREL, (Object)ModBlocks.EXPOSED_COPPER_MINI_BARREL).put((Object)ModBlocks.WAXED_WEATHERED_COPPER_MINI_BARREL, (Object)ModBlocks.WEATHERED_COPPER_MINI_BARREL).put((Object)ModBlocks.WAXED_OXIDIZED_COPPER_MINI_BARREL, (Object)ModBlocks.OXIDIZED_COPPER_MINI_BARREL).build();

    public static Optional<BlockState> getNextOxidisedState(BlockState state) {
        return Optional.ofNullable((Block)OXIDISATION_MAP.getOrDefault((Object)state.m_60734_(), null)).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getPreviousOxidisedState(BlockState state) {
        return Optional.ofNullable((Block)INVERSE_MAP.getOrDefault((Object)state.m_60734_(), null)).map(block -> block.m_152465_(state));
    }

    public static BiMap<Block, Block> oxidisation() {
        return OXIDISATION_MAP;
    }

    public static BiMap<Block, Block> dewaxing() {
        return DEWAXED_MAP;
    }

    public static Optional<BlockState> getDewaxed(BlockState state) {
        return Optional.ofNullable((Block)DEWAXED_MAP.getOrDefault((Object)state.m_60734_(), null)).map(block -> block.m_152465_(state));
    }
}

