/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import ellemes.expandedstorage.api.EsChestType;
import ellemes.expandedstorage.common.CommonMain;
import ellemes.expandedstorage.common.block.AbstractChestBlock;
import ellemes.expandedstorage.common.block.ChestBlock;
import ellemes.expandedstorage.common.block.entity.ChestBlockEntity;
import ellemes.expandedstorage.common.block.misc.PropertyRetriever;
import ellemes.expandedstorage.common.misc.Utils;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public final class ChestBlockEntityRenderer
implements BlockEntityRenderer<ChestBlockEntity> {
    public static final ModelLayerLocation SINGLE_LAYER = new ModelLayerLocation(Utils.id("single_chest"), "main");
    public static final ModelLayerLocation LEFT_LAYER = new ModelLayerLocation(Utils.id("left_chest"), "main");
    public static final ModelLayerLocation RIGHT_LAYER = new ModelLayerLocation(Utils.id("right_chest"), "main");
    public static final ModelLayerLocation TOP_LAYER = new ModelLayerLocation(Utils.id("top_chest"), "main");
    public static final ModelLayerLocation BOTTOM_LAYER = new ModelLayerLocation(Utils.id("bottom_chest"), "main");
    public static final ModelLayerLocation FRONT_LAYER = new ModelLayerLocation(Utils.id("front_chest"), "main");
    public static final ModelLayerLocation BACK_LAYER = new ModelLayerLocation(Utils.id("back_chest"), "main");
    private static final BlockState DEFAULT_STATE = ((Block)BuiltInRegistries.f_256975_.m_7745_(Utils.id("wood_chest"))).m_49966_();
    private static final ellemes.expandedstorage.common.block.misc.Property<ChestBlockEntity, Float2FloatFunction> LID_OPENNESS_FUNCTION_GETTER = new ellemes.expandedstorage.common.block.misc.Property<ChestBlockEntity, Float2FloatFunction>(){

        @Override
        public Float2FloatFunction get(ChestBlockEntity first, ChestBlockEntity second) {
            return delta -> Math.max(first.getLidOpenness(delta), second.getLidOpenness(delta));
        }

        @Override
        public Float2FloatFunction get(ChestBlockEntity single) {
            return single::getLidOpenness;
        }
    };
    private static final ellemes.expandedstorage.common.block.misc.Property<ChestBlockEntity, Int2IntFunction> BRIGHTNESS_PROPERTY = new ellemes.expandedstorage.common.block.misc.Property<ChestBlockEntity, Int2IntFunction>(){

        @Override
        public Int2IntFunction get(ChestBlockEntity first, ChestBlockEntity second) {
            return i -> {
                int firstLightColor = LevelRenderer.m_109541_((BlockAndTintGetter)first.m_58904_(), (BlockPos)first.m_58899_());
                int firstBlockLight = LightTexture.m_109883_((int)firstLightColor);
                int firstSkyLight = LightTexture.m_109894_((int)firstLightColor);
                int secondLightColor = LevelRenderer.m_109541_((BlockAndTintGetter)second.m_58904_(), (BlockPos)second.m_58899_());
                int secondBlockLight = LightTexture.m_109883_((int)secondLightColor);
                int secondSkyLight = LightTexture.m_109894_((int)secondLightColor);
                return LightTexture.m_109885_((int)Math.max(firstBlockLight, secondBlockLight), (int)Math.max(firstSkyLight, secondSkyLight));
            };
        }

        @Override
        public Int2IntFunction get(ChestBlockEntity single) {
            return i -> i;
        }
    };
    private final ModelPart singleBottom;
    private final ModelPart singleLid;
    private final ModelPart singleLock;
    private final ModelPart leftBottom;
    private final ModelPart leftLid;
    private final ModelPart leftLock;
    private final ModelPart rightBottom;
    private final ModelPart rightLid;
    private final ModelPart rightLock;
    private final ModelPart topBottom;
    private final ModelPart topLid;
    private final ModelPart topLock;
    private final ModelPart bottomBottom;
    private final ModelPart frontBottom;
    private final ModelPart frontLid;
    private final ModelPart frontLock;
    private final ModelPart backBottom;
    private final ModelPart backLid;

    public ChestBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart single = context.m_173582_(SINGLE_LAYER);
        this.singleBottom = single.m_171324_("bottom");
        this.singleLid = single.m_171324_("lid");
        this.singleLock = single.m_171324_("lock");
        ModelPart left = context.m_173582_(LEFT_LAYER);
        this.leftBottom = left.m_171324_("bottom");
        this.leftLid = left.m_171324_("lid");
        this.leftLock = left.m_171324_("lock");
        ModelPart right = context.m_173582_(RIGHT_LAYER);
        this.rightBottom = right.m_171324_("bottom");
        this.rightLid = right.m_171324_("lid");
        this.rightLock = right.m_171324_("lock");
        ModelPart top = context.m_173582_(TOP_LAYER);
        this.topBottom = top.m_171324_("bottom");
        this.topLid = top.m_171324_("lid");
        this.topLock = top.m_171324_("lock");
        ModelPart bottom = context.m_173582_(BOTTOM_LAYER);
        this.bottomBottom = bottom.m_171324_("bottom");
        ModelPart front = context.m_173582_(FRONT_LAYER);
        this.frontBottom = front.m_171324_("bottom");
        this.frontLid = front.m_171324_("lid");
        this.frontLock = front.m_171324_("lock");
        ModelPart back = context.m_173582_(BACK_LAYER);
        this.backBottom = back.m_171324_("bottom");
        this.backLid = back.m_171324_("lid");
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)48);
    }

    public static LayerDefinition createLeftBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)48);
    }

    public static LayerDefinition createRightBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)48);
    }

    public static LayerDefinition createTopBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)48);
    }

    public static LayerDefinition createBottomBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 16.0f, 14.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition createFrontBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 10.0f, 15.0f), PartPose.f_171404_);
        partDefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 15.0f, 14.0f, 5.0f, 15.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)-15.0f));
        partDefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 31.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)-16.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)48);
    }

    public static LayerDefinition createBackBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 15.0f), PartPose.f_171404_);
        partDefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 15.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)48, (int)48);
    }

    private static float getLidOpenness(float delta) {
        delta = 1.0f - delta;
        delta = 1.0f - delta * delta * delta;
        return -delta * 1.5707964f;
    }

    private static void renderBottom(PoseStack stack, VertexConsumer consumer, ModelPart bottom, int light, int overlay) {
        bottom.m_104301_(stack, consumer, light, overlay);
    }

    private static void renderTop(PoseStack stack, VertexConsumer consumer, ModelPart top, int light, int overlay, float openness) {
        top.f_104203_ = openness;
        top.m_104301_(stack, consumer, light, overlay);
    }

    public void render(ChestBlockEntity entity, float delta, PoseStack stack, MultiBufferSource provider, int light, int overlay) {
        Block block;
        BlockState state;
        ResourceLocation blockId = entity.getBlockId();
        BlockState blockState = state = entity.m_58898_() ? entity.m_58900_() : (BlockState)DEFAULT_STATE.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH);
        if (blockId == null || !((block = state.m_60734_()) instanceof ChestBlock)) {
            return;
        }
        ChestBlock block2 = (ChestBlock)block;
        EsChestType chestType = (EsChestType)((Object)state.m_61143_(AbstractChestBlock.CURSED_CHEST_TYPE));
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        int yOffset = entity.isDinnerbone() ? 180 : 0;
        stack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()));
        if (yOffset == 180) {
            stack.m_252781_(Axis.f_252403_.m_252977_((float)yOffset));
            if (chestType == EsChestType.LEFT) {
                chestType = EsChestType.RIGHT;
            } else if (chestType == EsChestType.RIGHT) {
                chestType = EsChestType.LEFT;
            } else if (chestType == EsChestType.TOP) {
                chestType = EsChestType.BOTTOM;
            } else if (chestType == EsChestType.BOTTOM) {
                chestType = EsChestType.TOP;
            }
        }
        stack.m_85837_(-0.5, -0.5, -0.5);
        PropertyRetriever<ChestBlockEntity> retriever = entity.m_58898_() ? AbstractChestBlock.createPropertyRetriever(block2, state, (LevelAccessor)entity.m_58904_(), entity.m_58899_(), true) : PropertyRetriever.createDirect(entity);
        VertexConsumer consumer = new Material(Sheets.f_110740_, CommonMain.getChestTexture(blockId, chestType)).m_119194_(provider, RenderType::m_110452_);
        float lidOpenness = ChestBlockEntityRenderer.getLidOpenness(retriever.get(LID_OPENNESS_FUNCTION_GETTER).orElse(f -> 0.0f).get(delta));
        int brightness = retriever.get(BRIGHTNESS_PROPERTY).orElse(i -> i).applyAsInt(light);
        if (chestType == EsChestType.SINGLE) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.singleBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.singleLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.singleLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.TOP) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.topBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.topLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.topLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.BOTTOM) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.bottomBottom, brightness, overlay);
        } else if (chestType == EsChestType.FRONT) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.frontBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.frontLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.frontLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.BACK) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.backBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.backLid, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.LEFT) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.leftBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.leftLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.leftLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.RIGHT) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.rightBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.rightLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.rightLock, brightness, overlay, lidOpenness);
        }
        stack.m_85849_();
    }
}

