/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.client.gui;

import com.google.common.collect.ImmutableSortedSet;
import com.mojang.blaze3d.vertex.PoseStack;
import ellemes.expandedstorage.api.client.function.ScreenSize;
import ellemes.expandedstorage.api.client.gui.AbstractScreen;
import ellemes.expandedstorage.api.inventory.AbstractHandler;
import ellemes.expandedstorage.common.CommonClient;
import ellemes.expandedstorage.common.client.PickButton;
import ellemes.expandedstorage.common.client.gui.PickScreen;
import ellemes.expandedstorage.common.client.gui.widget.ScreenPickButton;
import ellemes.expandedstorage.common.misc.Utils;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public final class FakePickScreen
extends AbstractScreen {
    private static final Component TITLE = Component.m_237115_((String)"screen.ellemes_container_lib.screen_picker_title");
    private final Set<ResourceLocation> options = ImmutableSortedSet.copyOf(PickScreen.BUTTON_SETTINGS.keySet());
    private int topPadding;

    public FakePickScreen(AbstractHandler handler, Inventory playerInventory, Component title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        for (int i = 0; i < ((AbstractHandler)this.f_97732_).getInventory().m_6643_(); ++i) {
            ((AbstractHandler)this.f_97732_).addClientSlot(new Slot(((AbstractHandler)this.f_97732_).getInventory(), i, 0, 0));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, y * 9 + x + 9, 0, 0));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, x, 0, 0));
        }
    }

    protected void m_7286_(PoseStack stack, float f, int i, int j) {
        this.m_7333_(stack);
    }

    public void m_7379_() {
        ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        if (preference.equals((Object)Utils.UNSET_SCREEN_TYPE)) {
            this.f_96541_.f_91074_.m_6915_();
        } else {
            int invSize = ((AbstractHandler)this.f_97732_).getInventory().m_6643_();
            if (AbstractScreen.getScreenSize(preference, invSize, this.f_96541_.m_91268_().m_85445_(), this.f_96541_.m_91268_().m_85446_()) == null) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"generic.ellemes_container_lib.label").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"chat.ellemes_container_lib.cannot_display_screen", (Object[])new Object[]{Component.m_237115_((String)("screen." + preference.m_135827_() + "." + preference.m_135815_() + "_screen"))}).m_130940_(ChatFormatting.WHITE)), false);
                this.f_96541_.f_91074_.m_6915_();
                return;
            }
            ((AbstractHandler)this.f_97732_).clearSlots();
            this.f_96541_.m_91152_((Screen)AbstractScreen.createScreen((AbstractHandler)this.f_97732_, Minecraft.m_91087_().f_91074_.m_150109_(), this.m_96636_()));
        }
    }

    protected void m_7856_() {
        int topPadding;
        super.m_7856_();
        ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int choices = this.options.size();
        int columns = Math.min(Math.floorDiv(this.f_96543_, 96), choices);
        int innerPadding = Math.min((this.f_96543_ - columns * 96) / (columns + 1), 20);
        int outerPadding = (this.f_96543_ - ((columns - 1) * innerPadding + columns * 96)) / 2;
        int x = 0;
        this.topPadding = topPadding = (this.f_96544_ - 96) / 2;
        for (ResourceLocation option : this.options) {
            PickButton settings = PickScreen.BUTTON_SETTINGS.get(option);
            boolean isWarn = settings.getWarningTest().test(this.f_96543_, this.f_96544_);
            boolean isCurrent = option.equals((Object)preference);
            MutableComponent tooltipMessage = Component.m_237113_((String)"").m_7220_(settings.getTitle());
            if (isCurrent) {
                tooltipMessage.m_130946_("\n");
                tooltipMessage.m_7220_(PickScreen.CURRENT_OPTION_TEXT);
            }
            if (isWarn) {
                tooltipMessage.m_130946_("\n");
                settings.getWarningText().forEach(arg_0 -> ((MutableComponent)tooltipMessage).m_7220_(arg_0));
            }
            this.m_142416_((GuiEventListener)new ScreenPickButton(outerPadding + (innerPadding + 96) * x, topPadding, 96, 96, settings.getTexture(), settings.getTitle(), isWarn, isCurrent, __ -> this.updatePlayerPreference(option), Tooltip.m_257550_((Component)tooltipMessage)));
            ++x;
        }
    }

    private void updatePlayerPreference(ResourceLocation selection) {
        CommonClient.platformHelper().configWrapper().setPreferredScreenType(selection);
        this.m_7379_();
    }

    @Override
    public void m_86412_(PoseStack stack, int mouseX, int mouseY, float delta) {
        this.m_7333_(stack);
        for (Renderable widget : this.f_169369_) {
            widget.m_86412_(stack, mouseX, mouseY, delta);
        }
        GuiComponent.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)TITLE, (int)(this.f_96543_ / 2), (int)Math.max(this.topPadding / 2, 0), (int)-1);
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        return ScreenSize.of(0, 0);
    }
}

