/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.client.gui;

import com.google.common.collect.ImmutableSortedSet;
import com.mojang.blaze3d.vertex.PoseStack;
import ellemes.expandedstorage.api.client.function.ScreenSizePredicate;
import ellemes.expandedstorage.api.client.gui.AbstractScreen;
import ellemes.expandedstorage.api.inventory.AbstractHandler;
import ellemes.expandedstorage.common.CommonClient;
import ellemes.expandedstorage.common.client.PickButton;
import ellemes.expandedstorage.common.client.gui.widget.ScreenPickButton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class PickScreen
extends Screen {
    public static final Component CURRENT_OPTION_TEXT = Component.m_237115_((String)"screen.ellemes_container_lib.current_option_notice").m_130940_(ChatFormatting.GOLD);
    public static final Map<ResourceLocation, PickButton> BUTTON_SETTINGS = new HashMap<ResourceLocation, PickButton>();
    private final Set<ResourceLocation> options = ImmutableSortedSet.copyOf(BUTTON_SETTINGS.keySet());
    private final Supplier<Screen> returnToScreen;
    private final AbstractHandler handler;
    private int topPadding;

    public PickScreen(AbstractScreen currentScreen) {
        this((AbstractHandler)currentScreen.m_6262_(), () -> AbstractScreen.createScreen((AbstractHandler)currentScreen.m_6262_(), Minecraft.m_91087_().f_91074_.m_150109_(), currentScreen.m_96636_()));
    }

    public PickScreen(Supplier<Screen> returnToScreen) {
        this(null, returnToScreen);
    }

    private PickScreen(@Nullable AbstractHandler handler, Supplier<Screen> returnToScreen) {
        super((Component)Component.m_237115_((String)"screen.ellemes_container_lib.screen_picker_title"));
        this.handler = handler;
        this.returnToScreen = returnToScreen;
    }

    @Deprecated
    @ApiStatus.Internal
    public static void declareButtonSettings(ResourceLocation type, ResourceLocation texture, Component title, ScreenSizePredicate warningTest, List<Component> warningText) {
        BUTTON_SETTINGS.putIfAbsent(type, new PickButton(texture, title, warningTest, warningText));
    }

    public void m_7379_() {
        if (this.handler != null) {
            int invSize;
            ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
            if (AbstractScreen.getScreenSize(preference, invSize = this.handler.getInventory().m_6643_(), this.f_96541_.m_91268_().m_85445_(), this.f_96541_.m_91268_().m_85446_()) == null) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"generic.ellemes_container_lib.label").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"chat.ellemes_container_lib.cannot_display_screen", (Object[])new Object[]{Component.m_237115_((String)("screen." + preference.m_135827_() + "." + preference.m_135815_() + "_screen"))}).m_130940_(ChatFormatting.WHITE)), false);
                this.f_96541_.f_91074_.m_6915_();
                return;
            }
            this.handler.clearSlots();
        }
        this.f_96541_.m_91152_(this.returnToScreen.get());
    }

    public boolean m_7043_() {
        return this.f_96541_.f_91073_ == null;
    }

    protected void m_7856_() {
        int topPadding;
        super.m_7856_();
        ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int choices = this.options.size();
        int columns = Math.min(Math.floorDiv(this.f_96543_, 96), choices);
        int innerPadding = Math.min((this.f_96543_ - columns * 96) / (columns + 1), 20);
        int outerPadding = (this.f_96543_ - ((columns - 1) * innerPadding + columns * 96)) / 2;
        int x = 0;
        this.topPadding = topPadding = (this.f_96544_ - 96) / 2;
        for (ResourceLocation option : this.options) {
            PickButton settings = BUTTON_SETTINGS.get(option);
            boolean isWarn = settings.getWarningTest().test(this.f_96543_, this.f_96544_);
            boolean isCurrent = option.equals((Object)preference);
            MutableComponent tooltipMessage = Component.m_237113_((String)"").m_7220_(settings.getTitle());
            if (isCurrent) {
                tooltipMessage.m_130946_("\n");
                tooltipMessage.m_7220_(CURRENT_OPTION_TEXT);
            }
            if (isWarn) {
                tooltipMessage.m_130946_("\n");
                settings.getWarningText().forEach(arg_0 -> ((MutableComponent)tooltipMessage).m_7220_(arg_0));
            }
            this.m_142416_((GuiEventListener)new ScreenPickButton(outerPadding + (innerPadding + 96) * x, topPadding, 96, 96, settings.getTexture(), settings.getTitle(), isWarn, isCurrent, __ -> this.updatePlayerPreference(option), Tooltip.m_257563_((Component)tooltipMessage, (Component)tooltipMessage)));
            ++x;
        }
    }

    private void updatePlayerPreference(ResourceLocation selection) {
        CommonClient.platformHelper().configWrapper().setPreferredScreenType(selection);
        this.m_7379_();
    }

    public void m_86412_(PoseStack stack, int mouseX, int mouseY, float delta) {
        this.m_7333_(stack);
        super.m_86412_(stack, mouseX, mouseY, delta);
        GuiComponent.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)Math.max(this.topPadding / 2, 0), (int)-1);
    }
}

