/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import ellemes.expandedstorage.api.client.function.ScreenSize;
import ellemes.expandedstorage.api.client.gui.AbstractScreen;
import ellemes.expandedstorage.api.client.gui.TexturedRect;
import ellemes.expandedstorage.api.inventory.AbstractHandler;
import ellemes.expandedstorage.common.CommonClient;
import ellemes.expandedstorage.common.misc.ToggleableSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScrollScreen
extends AbstractScreen {
    private static final int THUMB_WIDTH = 12;
    private static final int THUMB_HEIGHT = 15;
    private final int totalRows;
    private final boolean scrollingUnrestricted;
    private boolean isDragging;
    private boolean blankAreaVisible;
    private int topRow;
    private int scrollYOffset;
    private int thumbY;
    private int blankSlots;
    @Nullable
    private TexturedRect blankArea;

    public ScrollScreen(AbstractHandler handler, Inventory playerInventory, Component title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        this.initializeSlots(playerInventory);
        this.totalRows = Mth.m_14165_((double)((double)this.totalSlots / (double)this.inventoryWidth));
        this.f_97726_ = 7 + 18 * this.inventoryWidth + 7;
        this.f_97727_ = 17 + 18 * this.inventoryHeight + 14 + 54 + 4 + 18 + 7;
        this.scrollingUnrestricted = CommonClient.platformHelper().configWrapper().isScrollingUnrestricted();
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        ArrayList<ScreenSize> options = new ArrayList<ScreenSize>();
        options.add(ScreenSize.of(9, 6));
        if (slots > 90) {
            options.add(ScreenSize.of(15, 6));
        }
        if (scaledHeight >= 276) {
            if (slots > 54) {
                options.add(ScreenSize.of(9, 9));
            }
            if (scaledWidth >= 248 && slots > 81) {
                options.add(ScreenSize.of(12, 9));
            }
            if (scaledWidth >= 302 && slots > 108) {
                options.add(ScreenSize.of(15, 9));
            }
            if (scaledWidth >= 356 && slots > 135) {
                options.add(ScreenSize.of(18, 9));
            }
        }
        if (scaledHeight >= 330 && scaledWidth >= 356 && slots > 162) {
            options.add(ScreenSize.of(18, 12));
        }
        if (scaledHeight >= 384 && scaledWidth >= 356 && slots > 216) {
            options.add(ScreenSize.of(18, 15));
        }
        return (ScreenSize)options.get(options.size() - 1);
    }

    private void initializeSlots(Inventory playerInventory) {
        for (int i = 0; i < this.totalSlots; ++i) {
            int slotXPos = i % this.inventoryWidth;
            int slotYPos = Mth.m_14165_((double)((double)(i - slotXPos) / (double)this.inventoryWidth));
            int realYPos = slotYPos >= this.inventoryHeight ? -2000 : slotYPos * 18 + 18;
            ((AbstractHandler)this.f_97732_).addClientSlot(new ToggleableSlot(((AbstractHandler)this.f_97732_).getInventory(), i, slotXPos * 18 + 8, realYPos, realYPos != -2000));
        }
        int left = (this.inventoryWidth * 18 + 14) / 2 - 80;
        int top = 32 + this.inventoryHeight * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, y * 9 + x + 9, left + 18 * x, top + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, x, left + 18 * x, top + 58));
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - (this.f_97726_ + 22 - 4)) / 2;
        this.isDragging = false;
        int remainderSlots = this.totalSlots % this.inventoryWidth;
        if (remainderSlots > 0) {
            this.blankSlots = this.inventoryWidth - remainderSlots;
            int xRight = this.f_97735_ + 7 + this.inventoryWidth * 18;
            int yTop = this.f_97736_ + 17 + (this.inventoryHeight - 1) * 18;
            int width = this.blankSlots * 18;
            this.blankArea = new TexturedRect(xRight - width, yTop, width, 18, 7, this.f_97727_, this.textureWidth, this.textureHeight);
            this.blankAreaVisible = this.topRow == this.totalRows - this.inventoryHeight;
        }
    }

    protected void m_7286_(PoseStack stack, float delta, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.textureLocation);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiComponent.m_93133_((PoseStack)stack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.textureWidth, (int)this.textureHeight);
        int containerSlotsHeight = this.inventoryHeight * 18;
        int scrollbarHeight = containerSlotsHeight + (this.inventoryWidth > 9 ? 34 : 24);
        GuiComponent.m_93133_((PoseStack)stack, (int)(this.f_97735_ + this.f_97726_ - 4), (int)this.f_97736_, (float)this.f_97726_, (float)0.0f, (int)22, (int)scrollbarHeight, (int)this.textureWidth, (int)this.textureHeight);
        GuiComponent.m_93133_((PoseStack)stack, (int)(this.f_97735_ + this.f_97726_ - 2), (int)(this.f_97736_ + 17 + 1 + this.thumbY), (float)this.f_97726_, (float)scrollbarHeight, (int)12, (int)15, (int)this.textureWidth, (int)this.textureHeight);
        if (this.blankArea != null && this.blankAreaVisible) {
            this.blankArea.render(stack);
        }
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(stack, this.f_96539_, 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(stack, this.f_169604_, 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
    }

    private boolean isMouseOverTrack(double mouseX, double mouseY) {
        boolean xCheck = (double)(this.f_97735_ + this.f_97726_ - 2) <= mouseX && mouseX <= (double)(this.f_97735_ + this.f_97726_ - 2 + 12);
        int scrollbarStart = this.f_97736_ + 17 + 1;
        return xCheck && (double)scrollbarStart <= mouseY && mouseY <= (double)(scrollbarStart + this.inventoryHeight * 18 - 2);
    }

    private boolean isMouseOverThumb(double mouseX, double mouseY) {
        boolean xCheck = (double)(this.f_97735_ + this.f_97726_ - 2) <= mouseX && mouseX <= (double)(this.f_97735_ + this.f_97726_ - 2 + 12);
        double correctedThumbY = this.f_97736_ + 17 + 1 + this.thumbY;
        return xCheck && correctedThumbY <= mouseY && mouseY <= correctedThumbY + 15.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMouseOverScrollbar(double mouseX, double mouseY, int left, int top) {
        if (!(mouseX > (double)(left + this.f_97726_ - 4))) return false;
        if (!(mouseX <= (double)(left + this.f_97726_ + 22))) return false;
        if (!(mouseY >= (double)top)) return false;
        int n = this.inventoryWidth > 9 ? 10 : 0;
        if (!(mouseY < (double)(top + 17 + this.inventoryHeight * 18 + n + 7))) return false;
        return true;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        int outsideRegion;
        if (this.inventoryWidth > 9 && mouseY >= (double)(top + 17 + this.inventoryHeight * 18 + 17) && (mouseX < (double)(left + (outsideRegion = (this.f_97726_ - 176) / 2)) || mouseX > (double)(left + this.f_97726_ - outsideRegion))) {
            return true;
        }
        return super.m_7467_(mouseX, mouseY, left, top, button) && !this.isMouseOverScrollbar(mouseX, mouseY, this.f_97735_, this.f_97736_);
    }

    @Override
    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 264 || keyCode == 267) {
            if (this.topRow != this.totalRows - this.inventoryHeight) {
                if (Screen.m_96638_()) {
                    this.setTopRowAndMoveThumb(this.topRow, Math.min(this.topRow + this.inventoryHeight, this.totalRows - this.inventoryHeight));
                } else {
                    this.setTopRowAndMoveThumb(this.topRow, this.topRow + 1);
                }
            }
            return true;
        }
        if (keyCode == 265 || keyCode == 266) {
            if (this.topRow != 0) {
                if (Screen.m_96638_()) {
                    this.setTopRowAndMoveThumb(this.topRow, Math.max(this.topRow - this.inventoryHeight, 0));
                } else {
                    this.setTopRowAndMoveThumb(this.topRow, this.topRow - 1);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isMouseOverThumb(mouseX, mouseY) && button == 0) {
            this.scrollYOffset = (int)mouseY - this.thumbY;
            this.isDragging = true;
        } else if (this.isMouseOverTrack(mouseX, mouseY) && button == 0) {
            this.updateThumbPosition(mouseY - 17.0 - 1.0 - (double)this.f_97736_);
            this.snapThumbToGradation();
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging) {
            this.updateThumbPosition(mouseY - (double)this.scrollYOffset);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isDragging) {
            this.isDragging = false;
            this.snapThumbToGradation();
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void snapThumbToGradation() {
        this.thumbY = (int)((double)this.topRow / (double)(this.totalRows - this.inventoryHeight) * (double)(this.inventoryHeight * 18 - 2 - 15));
    }

    private void updateThumbPosition(double adjustedMouseY) {
        this.thumbY = (int)Math.min(Math.max(adjustedMouseY, 0.0), (double)(this.inventoryHeight * 18 - 2 - 15));
        int row = (int)Math.round((double)this.thumbY / (double)(this.inventoryHeight * 18 - 2 - 15) * (double)(this.totalRows - this.inventoryHeight));
        this.setTopRow(this.topRow, row);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.scrollingUnrestricted || this.isMouseOverTrack(mouseX, mouseY)) {
            int newTop = delta < 0.0 ? Math.min(this.topRow + (Screen.m_96638_() ? this.inventoryHeight : 1), this.totalRows - this.inventoryHeight) : Math.max(this.topRow - (Screen.m_96638_() ? this.inventoryHeight : 1), 0);
            this.setTopRowAndMoveThumb(this.topRow, newTop);
            return true;
        }
        return false;
    }

    private void setTopRowAndMoveThumb(int oldTopRow, int newTopRow) {
        this.setTopRow(oldTopRow, newTopRow);
        this.snapThumbToGradation();
    }

    private void setTopRow(int oldTopRow, int newTopRow) {
        if (oldTopRow == newTopRow) {
            return;
        }
        this.topRow = newTopRow;
        this.blankAreaVisible = this.topRow == this.totalRows - this.inventoryHeight;
        int delta = newTopRow - oldTopRow;
        int rows = Math.abs(delta);
        if (rows < this.inventoryHeight) {
            int setAmount = rows * this.inventoryWidth;
            int movableAmount = (this.inventoryHeight - rows) * this.inventoryWidth;
            if (delta > 0) {
                int setOutBegin = oldTopRow * this.inventoryWidth;
                int movableBegin = newTopRow * this.inventoryWidth;
                int setInBegin = movableBegin + movableAmount;
                ((AbstractHandler)this.f_97732_).setSlotRange(setOutBegin, setOutBegin + setAmount, index -> -2000);
                ((AbstractHandler)this.f_97732_).moveSlotRange(movableBegin, setInBegin, -18 * rows);
                ((AbstractHandler)this.f_97732_).setSlotRange(setInBegin, Math.min(setInBegin + setAmount, this.totalSlots), index -> 18 * Math.floorDiv(index - movableBegin + this.inventoryWidth, this.inventoryWidth));
            } else {
                int setInBegin = newTopRow * this.inventoryWidth;
                int movableBegin = oldTopRow * this.inventoryWidth;
                int setOutBegin = movableBegin + movableAmount;
                ((AbstractHandler)this.f_97732_).setSlotRange(setInBegin, setInBegin + setAmount, index -> 18 * Math.floorDiv(index - setInBegin + this.inventoryWidth, this.inventoryWidth));
                ((AbstractHandler)this.f_97732_).moveSlotRange(movableBegin, setOutBegin, 18 * rows);
                ((AbstractHandler)this.f_97732_).setSlotRange(setOutBegin, Math.min(setOutBegin + setAmount, this.totalSlots), index -> -2000);
            }
        } else {
            int oldMin = oldTopRow * this.inventoryWidth;
            ((AbstractHandler)this.f_97732_).setSlotRange(oldMin, Math.min(oldMin + this.inventoryWidth * this.inventoryHeight, this.totalSlots), index -> -2000);
            int newMin = newTopRow * this.inventoryWidth;
            ((AbstractHandler)this.f_97732_).setSlotRange(newMin, newMin + this.inventoryWidth * this.inventoryHeight - (this.blankAreaVisible ? this.blankSlots : 0), index -> 18 + 18 * Math.floorDiv(index - newMin, this.inventoryWidth));
        }
    }

    @Override
    @NotNull
    public List<Rect2i> getExclusionZones() {
        int height = 17 + this.inventoryHeight * 18 + (this.inventoryWidth > 9 ? 10 : 0) + 7;
        return Collections.singletonList(new Rect2i(this.f_97735_ + this.f_97726_, this.f_97736_, 18, height));
    }
}

