/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import ellemes.expandedstorage.api.client.function.ScreenSize;
import ellemes.expandedstorage.api.client.gui.AbstractScreen;
import ellemes.expandedstorage.api.client.gui.TexturedRect;
import ellemes.expandedstorage.api.inventory.AbstractHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public final class SingleScreen
extends AbstractScreen {
    private final Set<TexturedRect> blankArea = new HashSet<TexturedRect>();
    private final int blankSlots;

    public SingleScreen(AbstractHandler handler, Inventory playerInventory, Component title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        this.initializeSlots(playerInventory);
        this.blankSlots = this.inventoryWidth * this.inventoryHeight - this.totalSlots;
        this.f_97726_ = 7 + 18 * this.inventoryWidth + 7;
        this.f_97727_ = 17 + 18 * this.inventoryHeight + 14 + 54 + 4 + 18 + 7;
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        int width;
        if (slots <= 81) {
            width = 9;
        } else if (slots <= 108) {
            width = 12;
        } else if (slots <= 135) {
            width = 15;
        } else if (slots <= 270) {
            width = 18;
        } else {
            return null;
        }
        int height = slots <= 27 ? 3 : (slots <= 45 ? 5 : (slots <= 54 ? 6 : (slots <= 162 ? 9 : (slots <= 216 ? 12 : 15))));
        return ScreenSize.of(width, height);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.blankSlots > 0) {
            this.blankArea.clear();
            int rows = Math.floorDiv(this.blankSlots, this.inventoryWidth);
            int remainder = this.blankSlots - this.inventoryWidth * rows;
            int yTop = this.f_97736_ + 17 + (this.inventoryHeight - 1) * 18;
            int xLeft = this.f_97735_ + 7;
            for (int i = 0; i < rows; ++i) {
                this.blankArea.add(new TexturedRect(xLeft, yTop, this.inventoryWidth * 18, 18, 7, this.f_97727_, this.textureWidth, this.textureHeight));
                yTop -= 18;
            }
            if (remainder > 0) {
                int xRight = this.f_97735_ + 7 + this.inventoryWidth * 18;
                int width = remainder * 18;
                this.blankArea.add(new TexturedRect(xRight - width, yTop, width, 18, 7, this.f_97727_, this.textureWidth, this.textureHeight));
            }
        }
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        int outsideRegion;
        if (this.inventoryWidth > 9 && mouseY >= (double)(top + 17 + this.inventoryHeight * 18 + 17) && (mouseX < (double)(left + (outsideRegion = (this.f_97726_ - 176) / 2)) || mouseX > (double)(left + this.f_97726_ - outsideRegion))) {
            return true;
        }
        return super.m_7467_(mouseX, mouseY, left, top, button);
    }

    protected void m_7286_(PoseStack stack, float delta, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.textureLocation);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiComponent.m_93133_((PoseStack)stack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.textureWidth, (int)this.textureHeight);
        this.blankArea.forEach(image -> image.render(stack));
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(stack, this.f_96539_, 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(stack, this.f_169604_, 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
    }

    private void initializeSlots(Inventory playerInventory) {
        int y;
        for (int i = 0; i < ((AbstractHandler)this.f_97732_).getInventory().m_6643_(); ++i) {
            int x = i % this.inventoryWidth;
            y = (i - x) / this.inventoryWidth;
            ((AbstractHandler)this.f_97732_).addClientSlot(new Slot(((AbstractHandler)this.f_97732_).getInventory(), i, x * 18 + 8, y * 18 + 18));
        }
        int left = (this.inventoryWidth * 18 + 14) / 2 - 80;
        int top = 32 + this.inventoryHeight * 18;
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, y * 9 + x + 9, left + 18 * x, top + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, x, left + 18 * x, top + 58));
        }
    }
}

