/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.config;

import ellemes.expandedstorage.common.config.Config;
import ellemes.expandedstorage.common.config.Converter;
import ellemes.expandedstorage.common.misc.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ConfigV0
implements Config {
    private final boolean restrictiveScrolling;
    private final boolean preferSmallerScreens;
    private ResourceLocation screenType;

    public ConfigV0() {
        this(Utils.UNSET_SCREEN_TYPE, false, true);
    }

    public ConfigV0(ResourceLocation screenType, boolean restrictiveScrolling, boolean preferSmallerScreens) {
        this.screenType = screenType == null ? Utils.UNSET_SCREEN_TYPE : screenType;
        this.restrictiveScrolling = restrictiveScrolling;
        this.preferSmallerScreens = preferSmallerScreens;
    }

    public ResourceLocation getScreenType() {
        return this.screenType;
    }

    public void setScreenType(ResourceLocation screenType) {
        this.screenType = screenType;
    }

    public boolean isScrollingRestricted() {
        return this.restrictiveScrolling;
    }

    public boolean preferSmallerScreens() {
        return this.preferSmallerScreens;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    public Converter<Map<String, Object>, ConfigV0> getConverter() {
        return Factory.INSTANCE;
    }

    public static final class Factory
    implements Converter<Map<String, Object>, ConfigV0> {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public ConfigV0 fromSource(Map<String, Object> source) {
            Object object = source.get("container_type");
            if (object instanceof String) {
                String screenType = (String)object;
                object = source.get("restrictive_scrolling");
                if (object instanceof Boolean) {
                    Object object2;
                    Boolean restrictiveScrolling = (Boolean)object;
                    Boolean preferSmallerScreens = Boolean.TRUE;
                    if (source.containsKey("prefer_smaller_screens") && (object2 = source.get("prefer_smaller_screens")) instanceof Boolean) {
                        Boolean bool;
                        preferSmallerScreens = bool = (Boolean)object2;
                    }
                    return new ConfigV0(ResourceLocation.m_135820_((String)screenType), restrictiveScrolling, preferSmallerScreens);
                }
            }
            return null;
        }

        @Override
        public Map<String, Object> toSource(ConfigV0 target) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("container_type", target.screenType);
            values.put("restrictive_scrolling", target.restrictiveScrolling);
            values.put("prefer_bigger_screens", target.preferSmallerScreens);
            return values;
        }

        @Override
        public int getSourceVersion() {
            return 0;
        }

        @Override
        public int getTargetVersion() {
            return 0;
        }
    }
}

