/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.item;

import ellemes.expandedstorage.common.entity.ChestMinecart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class ChestMinecartItem
extends Item {
    private static final DispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DispenseItemBehavior defaultDispenserBehaviour = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource block, ItemStack stack) {
            BlockState belowFrontState;
            Direction forward = (Direction)block.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            double x = block.m_7096_() + (double)forward.m_122429_() * 1.125;
            double y = Math.floor(block.m_7098_()) + (double)forward.m_122430_();
            double z = block.m_7094_() + (double)forward.m_122431_() * 1.125;
            BlockPos frontPos = block.m_7961_().m_121945_(forward);
            ServerLevel level = block.m_7727_();
            BlockState frontState = level.m_8055_(frontPos);
            double railHeight = -2.0;
            if (BaseRailBlock.m_49416_((BlockState)frontState)) {
                RailShape railShape = (RailShape)frontState.m_61143_(((BaseRailBlock)frontState.m_60734_()).m_7978_());
                railHeight = railShape.m_61745_() ? 0.5 : 0.0;
            } else if (frontState.m_60795_() && BaseRailBlock.m_49416_((BlockState)(belowFrontState = level.m_8055_(frontPos.m_7495_())))) {
                RailShape railShape = (RailShape)belowFrontState.m_61143_(((BaseRailBlock)belowFrontState.m_60734_()).m_7978_());
                double d = railHeight = forward != Direction.DOWN && railShape.m_61745_() ? -0.5 : -1.0;
            }
            if (railHeight == -2.0) {
                this.defaultDispenserBehaviour.m_6115_(block, stack);
            } else {
                Vec3 posVec = new Vec3(x, y + railHeight + 0.0625, z);
                ChestMinecart cart = ChestMinecart.createMinecart((Level)level, posVec, ((ChestMinecartItem)stack.m_41720_()).cartId);
                if (stack.m_41788_()) {
                    cart.m_6593_(stack.m_41786_());
                }
                level.m_7967_((Entity)cart);
            }
            stack.m_41774_(1);
            return stack;
        }
    };
    protected final ResourceLocation cartId;

    public ChestMinecartItem(Item.Properties properties, ResourceLocation cartId) {
        super(properties);
        this.cartId = cartId;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (!BaseRailBlock.m_49416_((BlockState)state)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43722_();
        if (!level.m_5776_()) {
            RailShape railShape = (RailShape)state.m_61143_(((BaseRailBlock)state.m_60734_()).m_7978_());
            double railHeight = railShape.m_61745_() ? 0.5 : 0.0;
            Vec3 posVec = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + railHeight + 0.0625, (double)pos.m_123343_() + 0.5);
            ChestMinecart cart = ChestMinecart.createMinecart(level, posVec, this.cartId);
            if (stack.m_41788_()) {
                cart.m_6593_(stack.m_41786_());
            }
            level.m_7967_((Entity)cart);
            level.m_220407_(GameEvent.f_157810_, pos, GameEvent.Context.m_223719_((Entity)context.m_43723_(), (BlockState)level.m_8055_(pos.m_7495_())));
        }
        stack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }
}

