/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.misc;

import com.google.gson.JsonParseException;
import ellemes.expandedstorage.api.client.gui.AbstractScreen;
import ellemes.expandedstorage.common.config.Config;
import ellemes.expandedstorage.common.config.ConfigV0;
import ellemes.expandedstorage.common.config.Converter;
import ellemes.expandedstorage.common.misc.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public abstract class ConfigWrapper {
    public static final Logger LOGGER = LogManager.getLogger((String)"expandedstorage");
    private final ConfigV0 config;
    private final Path oldConfigPath;
    private final Path configPath;

    public static void warnThrowableMessage(String message, Throwable throwable, Object ... values) {
        LOGGER.warn((Message)new FormattedMessage(message, values, throwable));
    }

    public ConfigWrapper(Path configPath, Path oldConfigPath) {
        this.configPath = configPath;
        this.oldConfigPath = oldConfigPath;
        this.config = this.getConfig();
    }

    public final boolean isScrollingUnrestricted() {
        return !this.config.isScrollingRestricted();
    }

    public final boolean preferSmallerScreens() {
        return this.config.preferSmallerScreens();
    }

    public final ResourceLocation getPreferredScreenType() {
        return this.config.getScreenType();
    }

    public final void setPreferredScreenType(ResourceLocation type) {
        if (AbstractScreen.isScreenTypeDeclared(type) && type != this.config.getScreenType()) {
            this.config.setScreenType(type);
            this.saveConfig(this.config);
        }
    }

    protected abstract ConfigV0 readOldConfig(String var1, Path var2);

    private ConfigV0 getConfig() {
        ConfigV0 config;
        boolean triedLoadingNewConfig;
        boolean triedLoadingOldConfig;
        block13: {
            triedLoadingOldConfig = false;
            triedLoadingNewConfig = false;
            config = null;
            if (Files.exists(this.configPath, new LinkOption[0])) {
                triedLoadingNewConfig = true;
                config = this.loadConfig(this.configPath, ConfigV0.Factory.INSTANCE, false);
            }
            if (Files.exists(this.oldConfigPath, new LinkOption[0])) {
                triedLoadingOldConfig = true;
                try (BufferedReader reader = Files.newBufferedReader(this.oldConfigPath);){
                    ConfigV0 oldConfig;
                    String configLines = reader.lines().collect(Collectors.joining());
                    if (config == null && (oldConfig = this.readOldConfig(configLines, this.oldConfigPath)) != null) {
                        config = oldConfig;
                        this.saveConfig(config);
                    }
                    this.backupFile(this.oldConfigPath, String.format("Failed to backup legacy Expanded Storage config, '%s'.", this.oldConfigPath.getFileName().toString()), configLines);
                }
                catch (IOException e) {
                    if (config != null) break block13;
                    LOGGER.warn("Failed to load legacy Expanded Storage Config, new default config will be used.", (Throwable)e);
                }
            }
        }
        if (config == null) {
            if (triedLoadingOldConfig || triedLoadingNewConfig) {
                LOGGER.warn("Could not load an existing config, Expanded Storage is using it's default config.");
            }
            config = new ConfigV0();
            this.saveConfig(config);
        }
        return config;
    }

    protected final <T extends Config> void saveConfig(T config) {
        try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
            Map<String, Object> configValues = config.getConverter().toSource(config);
            configValues.put("config_version", config.getVersion());
            Utils.GSON.toJson(configValues, Utils.MAP_TYPE, Utils.GSON.newJsonWriter((Writer)writer));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to save Expanded Storage's config.", (Throwable)e);
        }
    }

    protected final <T extends Config> T convertToConfig(String lines, Converter<Map<String, Object>, T> converter, Path configPath) {
        try {
            Map configMap = (Map)Utils.GSON.fromJson(lines, Utils.MAP_TYPE);
            int configVersion = Mth.m_14107_((double)configMap.getOrDefault("config_version", -1.0));
            return this.convert(configMap, configVersion, converter);
        }
        catch (JsonParseException e) {
            String configFileName = configPath.getFileName().toString();
            ConfigWrapper.warnThrowableMessage("Failed to convert config, backing up config '{}'.", e, configFileName);
            this.backupFile(configPath, String.format("Failed to backup expanded storage config which failed to read, '%s'.%n", configFileName), lines);
            return null;
        }
    }

    protected final <A, B extends Config> B convert(A config, int configVersion, Converter<A, B> converter) {
        if (configVersion == converter.getSourceVersion()) {
            Config returnValue = (Config)converter.fromSource(config);
            if (returnValue == null) {
                return null;
            }
            if (returnValue.getVersion() == converter.getTargetVersion()) {
                return (B)returnValue;
            }
            throw new IllegalStateException(String.format("CODE ERROR: Converter converted to an invalid config, expected version %s, got %s.", converter.getTargetVersion(), returnValue.getVersion()));
        }
        throw new IllegalStateException(String.format("CODE ERROR: Converter converted to an invalid config, expected version %s, got %s.", converter.getSourceVersion(), configVersion));
    }

    protected final void backupFile(Path path, String failureMessage, String contents) {
        block2: {
            try {
                Path backupPath = path.resolveSibling(path.getFileName() + new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss").format(new Date()) + ".backup");
                Files.move(path, backupPath, new CopyOption[0]);
            }
            catch (IOException e) {
                LOGGER.warn(failureMessage, (Throwable)e);
                if (contents == null) break block2;
                LOGGER.warn(contents);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final <T extends Config> T loadConfig(Path configPath, Converter<Map<String, Object>, T> converter, boolean isLegacy) {
        try (BufferedReader reader = Files.newBufferedReader(configPath);){
            String configLines2 = reader.lines().collect(Collectors.joining());
            T t = this.convertToConfig(configLines2, converter, configPath);
            return t;
        }
        catch (IOException e) {
            String configFileName = configPath.getFileName().toString();
            ConfigWrapper.warnThrowableMessage("Failed to read {}Expanded Storage config, '{}'.", e, isLegacy ? "legacy " : "", configFileName);
            e.printStackTrace();
            this.backupFile(configPath, String.format("Failed to backup %sExpanded Storage config, '%s'.%n", isLegacy ? "legacy " : "", configFileName), null);
            return null;
        }
    }
}

