/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ellemes.expandedstorage.api.EsChestType;
import ellemes.expandedstorage.api.ExpandedStorageAccessors;
import ellemes.expandedstorage.common.block.AbstractChestBlock;
import ellemes.expandedstorage.common.block.entity.extendable.OpenableBlockEntity;
import ellemes.expandedstorage.common.item.StorageConversionKit;
import ellemes.expandedstorage.common.item.ToolUsageResult;
import ellemes.expandedstorage.common.recipe.ConversionRecipe;
import ellemes.expandedstorage.common.recipe.conditions.RecipeCondition;
import ellemes.expandedstorage.common.recipe.misc.PartialBlockState;
import ellemes.expandedstorage.common.recipe.misc.RecipeTool;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockConversionRecipe<O extends Block>
extends ConversionRecipe<BlockState> {
    private final PartialBlockState<O> output;

    public BlockConversionRecipe(RecipeTool recipeTool, PartialBlockState<O> output, RecipeCondition input) {
        super(recipeTool, input);
        this.output = output;
    }

    public final ToolUsageResult process(Level level, Player player, ItemStack tool, BlockState clickedState, BlockPos clickedPos) {
        ArrayList<BlockPos> convertPositions = new ArrayList<BlockPos>();
        convertPositions.add(clickedPos);
        if (clickedState.m_61138_((Property)BlockStateProperties.f_61392_)) {
            ChestType type = (ChestType)clickedState.m_61143_((Property)BlockStateProperties.f_61392_);
            if (type != ChestType.SINGLE) {
                convertPositions.add(clickedPos.m_121945_(ChestBlock.m_51584_((BlockState)clickedState)));
            }
        } else if (clickedState.m_61138_(AbstractChestBlock.CURSED_CHEST_TYPE) && clickedState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            ExpandedStorageAccessors.getAttachedChestDirection(clickedState).ifPresent(direction -> convertPositions.add(clickedPos.m_121945_(direction)));
        }
        if (tool.m_41613_() < convertPositions.size() && !player.m_7500_()) {
            return StorageConversionKit.NOT_ENOUGH_UPGRADES;
        }
        HashMap<BlockPos, InputState> originalStates = new HashMap<BlockPos, InputState>();
        for (BlockPos position : convertPositions) {
            BlockEntity entity = level.m_7702_(position);
            if (!(entity instanceof OpenableBlockEntity) && !(entity instanceof RandomizableContainerBlockEntity)) {
                return ToolUsageResult.fail();
            }
            originalStates.put(position, new InputState(level.m_8055_(position), entity));
        }
        int toolsUsed = 0;
        for (BlockPos position : convertPositions) {
            NonNullList originalItems;
            OpenableBlockEntity entity;
            InputState input = (InputState)originalStates.get(position);
            BlockState originalState = input.state();
            BlockState newState = this.output.getBlock().m_152465_(originalState);
            if (originalState.m_61138_((Property)BlockStateProperties.f_61392_) && newState.m_61138_(AbstractChestBlock.CURSED_CHEST_TYPE)) {
                newState = (BlockState)newState.m_61124_(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.from((ChestType)originalState.m_61143_((Property)BlockStateProperties.f_61392_))));
            }
            if ((newState = this.output.transform(newState)) == originalState) continue;
            Component customName = null;
            CompoundTag tagForLock = input.entity().m_187482_();
            BlockEntity blockEntity = input.entity();
            if (blockEntity instanceof OpenableBlockEntity) {
                entity = (OpenableBlockEntity)blockEntity;
                originalItems = entity.getItems();
                if (entity.m_8077_()) {
                    customName = entity.m_7755_();
                }
            } else {
                blockEntity = input.entity();
                if (blockEntity instanceof RandomizableContainerBlockEntity) {
                    RandomizableContainerBlockEntity entity2 = (RandomizableContainerBlockEntity)blockEntity;
                    originalItems = entity2.m_7086_();
                    customName = entity2.m_7770_();
                } else {
                    throw new IllegalStateException();
                }
            }
            level.m_46747_(position);
            if (level.m_46597_(position, newState)) {
                blockEntity = level.m_7702_(position);
                if (blockEntity instanceof OpenableBlockEntity) {
                    int i;
                    entity = (OpenableBlockEntity)blockEntity;
                    NonNullList<ItemStack> newInventory = entity.getItems();
                    int commonSize = Math.min(originalItems.size(), newInventory.size());
                    for (i = 0; i < commonSize; ++i) {
                        newInventory.set(i, (ItemStack)originalItems.get(i));
                    }
                    if (newInventory.size() < originalItems.size()) {
                        for (i = newInventory.size(); i < originalItems.size(); ++i) {
                            Containers.m_18992_((Level)level, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (ItemStack)((ItemStack)originalItems.get(i)));
                        }
                    }
                    entity.setCustomName(customName);
                    entity.getLockable().readLock(tagForLock);
                }
                ++toolsUsed;
                continue;
            }
            level.m_151523_(input.entity());
        }
        if (this.recipeTool instanceof RecipeTool.UpgradeTool) {
            tool.m_41764_(tool.m_41613_() - toolsUsed);
        }
        return toolsUsed > 0 ? ToolUsageResult.slowSuccess() : ToolUsageResult.fail();
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        this.recipeTool.writeToBuffer(buffer);
        this.output.writeToBuffer(buffer);
        buffer.m_130085_(this.input.getNetworkId());
        this.input.writeToBuffer(buffer);
    }

    public static BlockConversionRecipe<?> readFromBuffer(FriendlyByteBuf buffer) {
        RecipeTool recipeTool = RecipeTool.fromNetworkBuffer(buffer);
        PartialBlockState<?> output = PartialBlockState.readFromBuffer(buffer);
        RecipeCondition inputs = RecipeCondition.readFromNetworkBuffer(buffer);
        return new BlockConversionRecipe(recipeTool, output, inputs);
    }

    @Override
    public JsonElement toJson() {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "expandedstorage:block_conversion");
        recipe.add("tool", (JsonElement)this.recipeTool.toJson());
        recipe.add("result", (JsonElement)this.output.toJson());
        recipe.add("inputs", this.input.toJson(null));
        return recipe;
    }

    private record InputState(BlockState state, BlockEntity entity) {
    }
}

