/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.recipe;

import ellemes.expandedstorage.common.recipe.BlockConversionRecipe;
import ellemes.expandedstorage.common.recipe.EntityConversionRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class ConversionRecipeManager {
    public static final ConversionRecipeManager INSTANCE = new ConversionRecipeManager();
    private final List<BlockConversionRecipe<?>> blockRecipes = new ArrayList();
    private final List<EntityConversionRecipe<?>> entityRecipes = new ArrayList();

    public BlockConversionRecipe<?> getBlockRecipe(BlockState state, ItemStack tool) {
        return this.blockRecipes.stream().map(recipe -> Map.entry(recipe, recipe.getRecipeWeight(state, tool))).filter(entry -> (Integer)entry.getValue() > 0).max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(null);
    }

    public EntityConversionRecipe<?> getEntityRecipe(Entity entity, ItemStack tool) {
        return this.entityRecipes.stream().map(recipe -> Map.entry(recipe, recipe.getRecipeWeight(entity, tool))).filter(entry -> (Integer)entry.getValue() > 0).max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(null);
    }

    public List<BlockConversionRecipe<?>> getBlockRecipes() {
        return Collections.unmodifiableList(this.blockRecipes);
    }

    public List<EntityConversionRecipe<?>> getEntityRecipes() {
        return Collections.unmodifiableList(this.entityRecipes);
    }

    public void replaceAllRecipes(List<BlockConversionRecipe<?>> blockRecipes, List<EntityConversionRecipe<?>> entityRecipes) {
        this.blockRecipes.clear();
        this.blockRecipes.addAll(blockRecipes);
        this.entityRecipes.clear();
        this.entityRecipes.addAll(entityRecipes);
    }
}

