/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.recipe.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ellemes.expandedstorage.common.misc.Utils;
import ellemes.expandedstorage.common.recipe.conditions.RecipeCondition;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AndCondition
implements RecipeCondition {
    public static final ResourceLocation NETWORK_ID = Utils.id("and");
    private final RecipeCondition[] conditions;

    public AndCondition(RecipeCondition ... conditions) {
        this.conditions = conditions;
    }

    @Override
    public boolean isExactMatch() {
        return Arrays.stream(this.conditions).anyMatch(RecipeCondition::isExactMatch);
    }

    @Override
    public boolean test(Object subject) {
        for (RecipeCondition condition : this.conditions) {
            if (condition.test(subject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResourceLocation getNetworkId() {
        return NETWORK_ID;
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_236828_(Arrays.asList(this.conditions), (b, condition) -> {
            buffer.m_130085_(condition.getNetworkId());
            condition.writeToBuffer((FriendlyByteBuf)b);
        });
    }

    public static AndCondition readFromBuffer(FriendlyByteBuf buffer) {
        RecipeCondition[] conditions = (RecipeCondition[])((ArrayList)buffer.m_236838_(ArrayList::new, RecipeCondition::readFromNetworkBuffer)).toArray(RecipeCondition[]::new);
        return new AndCondition(conditions);
    }

    @Override
    @Nullable
    public JsonElement toJson(@Nullable JsonObject object) {
        if (object != null) {
            this.writeToJsonObject(object);
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        this.writeToJsonObject(jsonObject);
        return jsonObject;
    }

    private void writeToJsonObject(JsonObject object) {
        for (RecipeCondition condition : this.conditions) {
            condition.toJson(object);
        }
    }
}

