/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.recipe.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ellemes.expandedstorage.common.misc.Utils;
import ellemes.expandedstorage.common.recipe.conditions.RecipeCondition;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class HasPropertyCondition
implements RecipeCondition {
    public static final ResourceLocation NETWORK_ID = Utils.id("has_property");
    private final ResourceLocation blockId;
    private final Map<Property<?>, Object> properties;
    private final boolean optional;

    public HasPropertyCondition(ResourceLocation blockId, Map<Property<?>, Object> properties, boolean optional) {
        this.blockId = blockId;
        this.properties = properties;
        this.optional = optional;
    }

    @Override
    public boolean isExactMatch() {
        return false;
    }

    @Override
    public boolean test(Object subject) {
        BlockState state = (BlockState)subject;
        for (Map.Entry<Property<?>, Object> entry : this.properties.entrySet()) {
            if (!(state.m_61138_(entry.getKey()) ? !state.m_61143_(entry.getKey()).equals(entry.getValue()) : !this.optional)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResourceLocation getNetworkId() {
        return NETWORK_ID;
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.blockId);
        buffer.writeBoolean(this.optional);
        buffer.writeInt(this.properties.size());
        for (Map.Entry<Property<?>, Object> property : this.properties.entrySet()) {
            buffer.m_130070_(property.getKey().m_61708_());
            buffer.m_130070_(property.getValue().toString());
        }
    }

    public static HasPropertyCondition readFromBuffer(FriendlyByteBuf buffer) {
        ResourceLocation blockId = buffer.m_130281_();
        if (!BuiltInRegistries.f_256975_.m_7804_(blockId)) {
            throw new IllegalStateException("Received an unknown block: " + blockId);
        }
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
        boolean optional = buffer.readBoolean();
        int numProperties = buffer.readInt();
        HashMap properties = Maps.newHashMapWithExpectedSize((int)numProperties);
        for (int i = 0; i < numProperties; ++i) {
            Property key = block.m_49965_().m_61081_(buffer.m_130277_());
            Object value = key.m_6215_(buffer.m_130277_()).orElseThrow();
            properties.put(key, value);
        }
        return new HasPropertyCondition(blockId, properties, optional);
    }

    @Override
    @Nullable
    public JsonElement toJson(@Nullable JsonObject object) {
        if (object != null) {
            this.writeToJsonObject(object);
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        this.writeToJsonObject(jsonObject);
        return jsonObject;
    }

    private void writeToJsonObject(JsonObject object) {
        JsonObject state = new JsonObject();
        for (Map.Entry<Property<?>, Object> entry : this.properties.entrySet()) {
            state.addProperty(entry.getKey().m_61708_(), entry.getValue().toString());
        }
        object.add("state", (JsonElement)state);
    }
}

