/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.recipe.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ellemes.expandedstorage.common.misc.Utils;
import ellemes.expandedstorage.common.recipe.conditions.RecipeCondition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class IsInstanceOfCondition
implements RecipeCondition {
    public static final ResourceLocation NETWORK_ID = Utils.id("is_instance");
    private final Class<?> clazz;

    public IsInstanceOfCondition(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean isExactMatch() {
        return false;
    }

    @Override
    public boolean test(Object subject) {
        return this.clazz.isAssignableFrom(RecipeCondition.unwrap(subject).getClass());
    }

    @Override
    public ResourceLocation getNetworkId() {
        return NETWORK_ID;
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buffer) {
        if (this == RecipeCondition.IS_WOODEN_BARREL) {
            buffer.m_130085_(RecipeCondition.IS_WOODEN_BARREL_ID);
        } else if (this == RecipeCondition.IS_WOODEN_CHEST) {
            buffer.m_130085_(RecipeCondition.IS_WOODEN_CHEST_ID);
        } else {
            throw new IllegalStateException("trying to send unknown is instance condition.");
        }
    }

    public static IsInstanceOfCondition readFromBuffer(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        if (RecipeCondition.IS_WOODEN_BARREL_ID.equals((Object)id)) {
            return RecipeCondition.IS_WOODEN_BARREL;
        }
        if (RecipeCondition.IS_WOODEN_CHEST_ID.equals((Object)id)) {
            return RecipeCondition.IS_WOODEN_CHEST;
        }
        throw new IllegalStateException("unknown is instance condition sent.");
    }

    @Override
    @Nullable
    public JsonElement toJson(@Nullable JsonObject object) {
        if (object != null) {
            this.writeToJsonObject(object);
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        this.writeToJsonObject(jsonObject);
        return jsonObject;
    }

    private void writeToJsonObject(JsonObject object) {
        String conditionName = null;
        if (this == RecipeCondition.IS_WOODEN_BARREL) {
            conditionName = RecipeCondition.IS_WOODEN_BARREL_ID.toString();
        } else if (this == RecipeCondition.IS_WOODEN_CHEST) {
            conditionName = RecipeCondition.IS_WOODEN_CHEST_ID.toString();
        }
        if (conditionName == null) {
            throw new IllegalStateException("Cannot serialize this instance of to json");
        }
        object.addProperty("condition", conditionName);
    }
}

