/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.recipe.misc;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ellemes.expandedstorage.common.recipe.misc.JsonHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PartialBlockState<T extends Block> {
    private final T block;
    private final Map<Property<?>, ?> properties;

    public PartialBlockState(T block) {
        this(block, Map.of());
    }

    public PartialBlockState(T block, Map<Property<?>, ?> properties) {
        this.block = block;
        this.properties = properties;
    }

    public static PartialBlockState<?> readFromJson(JsonObject object) {
        ResourceLocation blockId = JsonHelper.getJsonResourceLocation(object, "id");
        if (blockId.toString().equals("minecraft:air")) {
            return null;
        }
        Optional block = BuiltInRegistries.f_256975_.m_6612_(blockId);
        if (block.isEmpty()) {
            throw new IllegalArgumentException("Block id refers to unregistered block");
        }
        if (object.has("state")) {
            JsonObject properties = object.getAsJsonObject("state");
            if (properties.size() == 0) {
                throw new IllegalStateException("state must contain at least one property.");
            }
            Map<String, Property> propertyLookup = ((Block)block.get()).m_49966_().m_61147_().stream().map(it -> Map.entry(it.m_61708_(), it)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map.Entry[] stateProperties = new Map.Entry[properties.size()];
            int index = 0;
            for (Map.Entry propertyEntry : properties.entrySet()) {
                String propertyValue;
                if (!propertyLookup.containsKey(propertyEntry.getKey())) {
                    throw new IllegalArgumentException("Block does not contain property with name: " + (String)propertyEntry.getKey());
                }
                Property property = propertyLookup.get(propertyEntry.getKey());
                Optional value = property.m_6215_(propertyValue = JsonHelper.toString(property.m_61708_(), (JsonElement)propertyEntry.getValue()));
                if (value.isEmpty()) {
                    throw new IllegalStateException("Property " + property.m_61708_() + " doesn't contain value " + propertyValue);
                }
                stateProperties[index] = Map.entry(property, value.get());
                ++index;
            }
            return new PartialBlockState<Block>((Block)block.get(), Map.ofEntries(stateProperties));
        }
        return new PartialBlockState<Block>((Block)block.get(), Map.of());
    }

    public T getBlock() {
        return this.block;
    }

    public boolean matches(BlockState state) {
        if (state.m_60734_() != this.block) {
            return false;
        }
        for (Map.Entry<Property<?>, ?> property : this.properties.entrySet()) {
            if (!state.m_61138_(property.getKey())) {
                return false;
            }
            if (state.m_61143_(property.getKey()).equals(property.getValue())) continue;
            return false;
        }
        return true;
    }

    public <K extends Comparable<K>, V extends K> BlockState transform(BlockState state) {
        for (Map.Entry<Property<?>, ?> entry : this.properties.entrySet()) {
            state = (BlockState)state.m_61124_(entry.getKey(), (Comparable)entry.getValue());
        }
        return state;
    }

    public static <T extends Block> PartialBlockState<T> of(T block) {
        return new PartialBlockState<T>(block, Map.of());
    }

    public static <T extends Block> PartialBlockState<T> of(T block, Map<Property<?>, ?> properties) {
        return new PartialBlockState<T>(block, properties);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130085_(BuiltInRegistries.f_256975_.m_7981_(this.block));
        buffer.writeInt(this.properties.size());
        for (Map.Entry<Property<?>, ?> property : this.properties.entrySet()) {
            buffer.m_130070_(property.getKey().m_61708_());
            buffer.m_130070_(property.getValue().toString());
        }
    }

    public static PartialBlockState<?> readFromBuffer(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
        int mapSize = buffer.readInt();
        if (mapSize == 0) {
            return PartialBlockState.of(block);
        }
        HashMap properties = Maps.newHashMapWithExpectedSize((int)mapSize);
        for (int i = 0; i < mapSize; ++i) {
            Property key = block.m_49965_().m_61081_(buffer.m_130277_());
            Object value = key.m_6215_(buffer.m_130277_()).orElseThrow();
            properties.put(key, value);
        }
        return PartialBlockState.of(block, properties);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.block.m_204297_().m_205785_().m_135782_().toString());
        if (!this.properties.isEmpty()) {
            JsonObject jsonProperties = new JsonObject();
            for (Map.Entry<Property<?>, ?> property : this.properties.entrySet()) {
                jsonProperties.addProperty(property.getKey().m_61708_(), property.getValue().toString());
            }
            json.add("state", (JsonElement)jsonProperties);
        }
        return json;
    }
}

