/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common.recipe.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ellemes.expandedstorage.common.item.StorageConversionKit;
import ellemes.expandedstorage.common.misc.Utils;
import ellemes.expandedstorage.common.recipe.misc.JsonHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class RecipeTool {
    private final ResourceLocation toolId;

    private RecipeTool(ResourceLocation toolId) {
        this.toolId = toolId;
    }

    public boolean isMatchFor(ItemStack tool) {
        return tool.m_41720_().m_204114_().m_203373_(this.toolId);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.toolId);
    }

    public JsonObject toJson() {
        JsonObject tool = new JsonObject();
        tool.addProperty("id", this.toolId.toString());
        return tool;
    }

    public static RecipeTool fromJsonObject(JsonObject object) {
        ResourceLocation toolId = JsonHelper.getJsonResourceLocation(object, "id");
        if (toolId.toString().equals("expandedstorage:storage_mutator")) {
            if (object.has("name")) {
                JsonElement name = object.get("name");
                if (name.isJsonPrimitive() && name.getAsJsonPrimitive().isString()) {
                    return new MutatorTool(name.getAsString());
                }
                throw new JsonSyntaxException("Tool's name entry must be a string");
            }
            return new MutatorTool(null);
        }
        if (BuiltInRegistries.f_257033_.m_7745_(toolId) instanceof StorageConversionKit) {
            return new UpgradeTool(toolId);
        }
        throw new IllegalArgumentException("Tool id supplied is not a conversion kit or the storage mutator.");
    }

    public static RecipeTool fromNetworkBuffer(FriendlyByteBuf buffer) {
        ResourceLocation toolId = buffer.m_130281_();
        if (toolId.toString().equals("expandedstorage:storage_mutator")) {
            String name = (String)buffer.m_236868_(FriendlyByteBuf::m_130277_);
            return new MutatorTool(name);
        }
        if (BuiltInRegistries.f_257033_.m_7745_(toolId) instanceof StorageConversionKit) {
            return new UpgradeTool(toolId);
        }
        throw new IllegalArgumentException("Invalid tool id sent by the server.");
    }

    public static final class MutatorTool
    extends RecipeTool {
        private final String requiredName;

        public MutatorTool(String requiredName) {
            super(Utils.id("storage_mutator"));
            this.requiredName = requiredName;
        }

        @Override
        public boolean isMatchFor(ItemStack tool) {
            boolean isNameMatch = true;
            if (this.requiredName != null) {
                isNameMatch = tool.m_41786_().getString().equalsIgnoreCase(this.requiredName);
            }
            return isNameMatch && super.isMatchFor(tool);
        }

        @Override
        public void writeToBuffer(FriendlyByteBuf buffer) {
            super.writeToBuffer(buffer);
            buffer.m_236821_((Object)this.requiredName, FriendlyByteBuf::m_130070_);
        }

        @Override
        public JsonObject toJson() {
            JsonObject tool = super.toJson();
            if (this.requiredName != null) {
                tool.addProperty("name", this.requiredName);
            }
            return tool;
        }

        public String getRequiredName() {
            return this.requiredName;
        }
    }

    public static final class UpgradeTool
    extends RecipeTool {
        public UpgradeTool(ResourceLocation toolId) {
            super(toolId);
        }

        public UpgradeTool(Item item) {
            super(item.m_204114_().m_205785_().m_135782_());
        }
    }
}

