/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.forge;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import ellemes.expandedstorage.common.CommonMain;
import ellemes.expandedstorage.common.block.entity.extendable.OpenableBlockEntity;
import ellemes.expandedstorage.common.block.misc.BasicLockable;
import ellemes.expandedstorage.common.block.misc.CopperBlockHelper;
import ellemes.expandedstorage.common.block.strategies.ItemAccess;
import ellemes.expandedstorage.common.misc.Utils;
import ellemes.expandedstorage.common.recipe.ConversionRecipeManager;
import ellemes.expandedstorage.common.recipe.ConversionRecipeReloadListener;
import ellemes.expandedstorage.common.registration.Content;
import ellemes.expandedstorage.common.registration.NamedValue;
import ellemes.expandedstorage.forge.ForgeClient;
import ellemes.expandedstorage.forge.block.misc.ChestItemAccess;
import ellemes.expandedstorage.forge.block.misc.GenericItemAccess;
import ellemes.expandedstorage.forge.item.ChestBlockItem;
import ellemes.expandedstorage.forge.item.ChestMinecartItem;
import ellemes.expandedstorage.forge.item.MiniStorageBlockItem;
import ellemes.expandedstorage.forge.misc.ForgePlatformHelper;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="expandedstorage")
public final class ForgeMain {
    public ForgeMain() {
        CommonMain.constructContent(new ForgePlatformHelper(), GenericItemAccess::new, BasicLockable::new, FMLLoader.getDist().isClient(), this::registerContent, false, ChestBlockItem::new, ChestItemAccess::new, ChestMinecartItem::new, (TagKey<Block>)TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.BLOCKS, (ResourceLocation)new ResourceLocation("forge", "barrels/wooden")), MiniStorageBlockItem::new);
        MinecraftForge.EVENT_BUS.addListener(event -> event.addListener((PreparableReloadListener)new ConversionRecipeReloadListener()));
        MinecraftForge.EVENT_BUS.addListener(event -> CommonMain.platformHelper().sendConversionRecipesToClient(event.getPlayer(), ConversionRecipeManager.INSTANCE.getBlockRecipes(), ConversionRecipeManager.INSTANCE.getEntityRecipes()));
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, event -> {
            Object patt4031$temp = event.getObject();
            if (patt4031$temp instanceof OpenableBlockEntity) {
                final OpenableBlockEntity entity = (OpenableBlockEntity)patt4031$temp;
                event.addCapability(Utils.id("item_access"), new ICapabilityProvider(){

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
                        if (capability == ForgeCapabilities.ITEM_HANDLER) {
                            return LazyOptional.of(() -> CommonMain.getItemAccess(entity.m_58904_(), entity.m_58899_(), entity.m_58900_(), entity).map(ItemAccess::get).orElseThrow());
                        }
                        return LazyOptional.empty();
                    }
                });
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            InteractionResult result = CommonMain.interactWithEntity(event.getLevel(), event.getEntity(), event.getHand(), event.getTarget());
            if (result != InteractionResult.PASS) {
                event.setCancellationResult(result);
                event.setCanceled(true);
            }
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> event.register(ForgeRegistries.Keys.MENU_TYPES, helper -> helper.register(Utils.HANDLER_TYPE_ID, CommonMain.platformHelper().getScreenHandlerType())));
    }

    private void registerContent(Content content) {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(event -> {
            event.register(ForgeRegistries.Keys.STAT_TYPES, helper -> content.getStats().forEach(it -> Registry.m_122965_((Registry)BuiltInRegistries.f_256771_, (ResourceLocation)it, (Object)it)));
            event.register(ForgeRegistries.Keys.BLOCKS, helper -> CommonMain.iterateNamedList(content.getBlocks(), (arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
            event.register(ForgeRegistries.Keys.ITEMS, helper -> CommonMain.iterateNamedList(content.getItems(), (arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
            event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> {
                ForgeMain.registerBlockEntity(helper, content.getChestBlockEntityType());
                ForgeMain.registerBlockEntity(helper, content.getOldChestBlockEntityType());
                ForgeMain.registerBlockEntity(helper, content.getBarrelBlockEntityType());
                ForgeMain.registerBlockEntity(helper, content.getMiniChestBlockEntityType());
            });
            event.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> CommonMain.iterateNamedList(content.getEntityTypes(), (arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        });
        Supplier originalWaxablesMap = HoneycombItem.f_150863_;
        HoneycombItem.f_150863_ = Suppliers.memoize(() -> ForgeMain.lambda$registerContent$13((Supplier)originalWaxablesMap));
        modBus.addListener(event -> event.registerCreativeModeTab(Utils.id("expandedstorage.tab"), builder -> {
            builder.m_257737_(() -> ((Item)ForgeRegistries.ITEMS.getValue(Utils.id("netherite_chest"))).m_7968_());
            builder.m_257501_((displayParameters, output) -> CommonMain.generateDisplayItems(displayParameters, arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0)));
            builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.expandedstorage.tab"));
        }));
        if (FMLLoader.getDist() == Dist.CLIENT) {
            ForgeClient.initialize(modBus, content);
        }
    }

    private static <T extends BlockEntity> void registerBlockEntity(RegisterEvent.RegisterHelper<BlockEntityType<?>> helper, NamedValue<BlockEntityType<T>> blockEntityType) {
        helper.register(blockEntityType.getName(), blockEntityType.getValue());
    }

    private static /* synthetic */ BiMap lambda$registerContent$13(Supplier originalWaxablesMap) {
        return ImmutableBiMap.builder().putAll((Map)originalWaxablesMap.get()).putAll((Map)CopperBlockHelper.dewaxing().inverse()).build();
    }
}

