/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements.critereon;

import com.google.gson.JsonObject;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.mixin.PlayerAdvancementsAccessor;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactionCriterionTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "faction");
    private static final Logger LOGGER = LogManager.getLogger();

    @NotNull
    public static Instance level(@Nullable IPlayableFaction<?> faction, int level) {
        return new Instance(Type.LEVEL, faction, level);
    }

    @NotNull
    public static Instance lord(@Nullable IPlayableFaction<?> faction, int lordLevel) {
        return new Instance(Type.LORD, faction, lordLevel);
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(@NotNull ServerPlayer playerMP, IPlayableFaction<?> faction, int level, int lordLevel) {
        this.m_66234_(playerMP, instance -> instance.test(faction, level, lordLevel));
    }

    public void revokeAll(ServerPlayer player) {
        this.revoke(player, instance -> true);
    }

    public void revokeLevel(ServerPlayer player, IPlayableFaction<?> faction, Type type, int newLevel) {
        this.revoke(player, instance -> instance.faction == faction && instance.type == type && instance.level > newLevel);
    }

    private void revoke(ServerPlayer player, Predicate<Instance> instancePredicate) {
        PlayerAdvancements advancements = player.m_8960_();
        ((PlayerAdvancementsAccessor)advancements).getAdvancements().entrySet().stream().filter(entry -> !((AdvancementProgress)entry.getValue()).m_8193_()).forEach(advancementProgressEntry -> {
            if (((Advancement)advancementProgressEntry.getKey()).m_138325_().values().stream().anyMatch(pair -> {
                CriterionTriggerInstance trigger = pair.m_11416_();
                return trigger != null && trigger.m_7294_().equals((Object)ID) && instancePredicate.test((Instance)trigger);
            })) {
                ((AdvancementProgress)advancementProgressEntry.getValue()).m_8220_().forEach(a -> advancements.m_135998_((Advancement)advancementProgressEntry.getKey(), a));
            }
        });
    }

    @NotNull
    protected Instance createInstance(@NotNull JsonObject json, @NotNull EntityPredicate.Composite entityPredicate, @NotNull DeserializationContext conditionsParser) {
        String idStr;
        Type type;
        IPlayableFaction playableFaction = null;
        Type type2 = type = json.has("type") ? Type.valueOf(json.get("type").getAsString()) : Type.LEVEL;
        if (json.has("faction") && !"null".equals(idStr = json.get("faction").getAsString())) {
            ResourceLocation id = new ResourceLocation(json.get("faction").getAsString());
            IFaction<?> faction = VampirismAPI.factionRegistry().getFactionByID(id);
            if (faction instanceof IPlayableFaction) {
                IPlayableFaction playableFaction1;
                playableFaction = playableFaction1 = (IPlayableFaction)faction;
            } else {
                LOGGER.warn("Given faction name does not exist or is not a playable faction: {}", (Object)id);
            }
        }
        int level = json.has("level") ? json.get("level").getAsInt() : 1;
        return new Instance(type, playableFaction, level);
    }

    static class Instance
    extends AbstractCriterionTriggerInstance {
        @NotNull
        private final Type type;
        @Nullable
        private final IPlayableFaction<?> faction;
        private final int level;

        Instance(@NotNull Type type, @Nullable IPlayableFaction<?> faction, int level) {
            super(ID, EntityPredicate.Composite.f_36667_);
            this.type = type;
            this.faction = faction;
            this.level = level;
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext serializer) {
            JsonObject json = super.m_7683_(serializer);
            json.addProperty("type", this.type.name());
            json.addProperty("faction", this.faction == null ? "null" : this.faction.getID().toString());
            json.addProperty("level", (Number)this.level);
            return json;
        }

        public boolean test(IPlayableFaction<?> faction, int level, int lordLevel) {
            if (faction == null && this.faction == null || Objects.equals(this.faction, faction)) {
                if (this.type == Type.LEVEL) {
                    return level >= this.level;
                }
                if (this.type == Type.LORD) {
                    return lordLevel >= this.level;
                }
            }
            return false;
        }
    }

    public static enum Type {
        LEVEL,
        LORD;

    }
}

