/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.FluidTankWithListener;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampireLevelingConf;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleOptions;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidHandlerBlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class AltarInspirationBlockEntity
extends FluidHandlerBlockEntity
implements FluidTankWithListener.IFluidTankListener {
    public static final int CAPACITY = 10000;
    public static final ModelProperty<Integer> FLUID_LEVEL_PROP = new ModelProperty();
    private static final int RITUAL_TIME = 60;
    private int ritualTicksLeft = 0;
    private int targetLevel;
    private Player ritualPlayer;
    private ModelData modelData;

    public static void setBloodValue(@NotNull BlockGetter worldIn, @NotNull Random randomIn, @NotNull BlockPos blockPosIn) {
        BlockEntity tileEntity = worldIn.m_7702_(blockPosIn);
        if (tileEntity instanceof AltarInspirationBlockEntity) {
            tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack((Fluid)ModFluids.BLOOD.get(), BloodBottleFluidHandler.getAdjustedAmount((int)(10000.0f * randomIn.nextFloat()))), IFluidHandler.FluidAction.EXECUTE));
        }
    }

    public AltarInspirationBlockEntity(@NotNull BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.ALTAR_INSPIRATION.get(), pos, state);
        this.tank = new InternalTank(10000).setListener(this);
    }

    @NotNull
    public ModelData getModelData() {
        if (this.modelData == null) {
            this.updateModelData(false);
        }
        return this.modelData;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(Connection net, @NotNull ClientboundBlockEntityDataPacket pkt) {
        if (!this.m_58898_()) {
            return;
        }
        FluidStack old = this.tank.getFluid();
        this.m_142466_(pkt.m_131708_());
        if (!old.isFluidStackIdentical(this.tank.getFluid())) {
            this.updateModelData(true);
        }
    }

    @Override
    public void onTankContentChanged() {
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.updateModelData(true);
            }
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
            super.m_6596_();
        }
    }

    public void startRitual(@NotNull Player p) {
        if (this.ritualTicksLeft > 0 || !p.m_6084_()) {
            return;
        }
        this.targetLevel = VampirismPlayerAttributes.get((Player)p).vampireLevel + 1;
        VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
        if (!levelingConf.isLevelValidForAltarInspiration(this.targetLevel)) {
            if (p.f_19853_.f_46443_) {
                p.m_5661_((Component)Component.m_237115_((String)"text.vampirism.altar_infusion.ritual_level_wrong"), true);
            }
            return;
        }
        int neededBlood = levelingConf.getRequiredBloodForAltarInspiration(this.targetLevel) * 100;
        if (this.tank.getFluidAmount() + 99 < neededBlood) {
            if (p.f_19853_.f_46443_) {
                p.m_5661_((Component)Component.m_237115_((String)"text.vampirism.not_enough_blood"), true);
            }
            return;
        }
        if (!p.f_19853_.f_46443_) {
            ModParticles.spawnParticlesServer(p.f_19853_, new FlyingBloodEntityParticleOptions(p.m_19879_(), false), (double)this.f_58858_.m_123341_() + 0.5, this.f_58858_.m_123342_() + 1, (double)this.f_58858_.m_123343_() + 0.5, 40, 0.1f, 0.1f, 0.1f, 0.0);
        } else {
            ((InternalTank)this.tank).doDrain(neededBlood, IFluidHandler.FluidAction.EXECUTE);
        }
        this.ritualPlayer = p;
        this.ritualTicksLeft = 60;
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull AltarInspirationBlockEntity blockEntity) {
        if (blockEntity.ritualTicksLeft == 0 || blockEntity.ritualPlayer == null || !blockEntity.ritualPlayer.m_6084_()) {
            return;
        }
        switch (blockEntity.ritualTicksLeft) {
            case 5: {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)pos));
                lightningboltentity.m_20874_(true);
                level.m_7967_((Entity)lightningboltentity);
                blockEntity.ritualPlayer.m_21153_(blockEntity.ritualPlayer.m_21233_());
                break;
            }
            case 1: {
                VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
                int blood = levelingConf.getRequiredBloodForAltarInspiration(blockEntity.targetLevel) * 100;
                ((InternalTank)blockEntity.tank).doDrain(blood, IFluidHandler.FluidAction.EXECUTE);
                blockEntity.ritualPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19605_, blockEntity.targetLevel * 10 * 20));
                FactionPlayerHandler.getOpt(blockEntity.ritualPlayer).ifPresent(h -> h.setFactionLevel(VReference.VAMPIRE_FACTION, blockEntity.targetLevel));
                VampirePlayer.getOpt(blockEntity.ritualPlayer).ifPresent(v -> v.drinkBlood(Integer.MAX_VALUE, 0.0f, false));
            }
        }
        --blockEntity.ritualTicksLeft;
    }

    private void updateModelData(boolean refresh) {
        FluidStack fluid = this.tank.getFluid();
        int l = 0;
        if (!fluid.isEmpty()) {
            float i = (float)fluid.getAmount() / 10000.0f * 10.0f;
            l = i > 0.0f && i < 1.0f ? 1 : (int)i;
        }
        this.modelData = ModelData.builder().with(FLUID_LEVEL_PROP, (Object)l).build();
        if (refresh) {
            this.requestModelDataUpdate();
        }
    }

    private static class InternalTank
    extends FluidTankWithListener {
        private InternalTank(int capacity) {
            super(capacity, fluidStack -> ((Fluid)ModFluids.BLOOD.get()).m_6212_(fluidStack.getFluid()));
            this.setDrainable(false);
        }

        void doDrain(int maxDrain, IFluidHandler.FluidAction action) {
            this.setDrainable(true);
            super.drain(maxDrain, action);
            this.setDrainable(false);
        }
    }
}

