/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.IAggressiveVillager;
import de.teamlapen.vampirism.api.entity.ICaptureIgnore;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.event.VampirismVillageEvent;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.api.world.ITotem;
import de.teamlapen.vampirism.blocks.TotemBaseBlock;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.effects.SanguinareEffectInstance;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedVillagerEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.AggressiveVillagerEntity;
import de.teamlapen.vampirism.entity.hunter.DummyHunterTrainerEntity;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.TotemHelper;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.ServerMultiBossEvent;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TotemBlockEntity
extends BlockEntity
implements ITotem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final RandomSource RNG = RandomSource.m_216327_();
    private static final ResourceLocation nonFactionTotem = new ResourceLocation("none");
    private final ServerMultiBossEvent captureInfo = new ServerMultiBossEvent((Component)Component.m_237115_((String)"text.vampirism.village.bossinfo.raid"), BossEvent.BossBarOverlay.NOTCHED_10, new Color[0]);
    public long timeSinceLastRaid = 0L;
    private boolean isComplete;
    private boolean isInsideVillage;
    private boolean isDisabled;
    @NotNull
    private Set<PoiRecord> village = Sets.newHashSet();
    @Nullable
    private IFaction<?> controllingFaction;
    @Nullable
    private IFaction<?> capturingFaction;
    @Nullable
    private AABB villageArea;
    @Nullable
    private AABB villageAreaReduced;
    @Nullable
    private IFaction<?> forcedFaction;
    private int forcedFactionTimer;
    private boolean forceVillageUpdate;
    private CAPTURE_PHASE phase;
    private int captureTimer;
    private int captureAbortTimer;
    private int captureDuration;
    private int captureForceTargetTimer;
    private float strengthRatio;
    private int badOmenLevel;
    @OnlyIn(value=Dist.CLIENT)
    private long beamRenderCounter;
    @OnlyIn(value=Dist.CLIENT)
    private float beamRenderScale;
    private float[] baseColors = DyeColor.WHITE.m_41068_();
    private float[] progressColor = DyeColor.WHITE.m_41068_();
    @Nullable
    private CompletableFuture<BlockPos> closestVampireForest = null;
    private boolean unloaded;

    public static void makeAgressive(@NotNull Villager villager) {
        AggressiveVillagerEntity hunter = AggressiveVillagerEntity.makeHunter(villager);
        UtilLib.replaceEntity((LivingEntity)villager, (LivingEntity)hunter);
    }

    public TotemBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.TOTEM.get(), pos, state);
    }

    public void abortCapture() {
        this.applyVictoryBonus(false);
        this.notifyNearbyPlayers((Component)Component.m_237115_((String)"text.vampirism.village.defended"));
        this.breakCapture();
    }

    public void breakCapture() {
        this.setCapturingFaction(null);
        this.forceVillageUpdate = true;
        this.informEntitiesAboutCaptureStop();
        this.updateBossinfoPlayers(null);
        this.captureInfo.clear();
        VampirismWorld.getOpt(this.f_58857_).ifPresent(vw -> vw.updateTemporaryArtificialFog(this.f_58858_, null));
        this.m_6596_();
    }

    public boolean canPlayerRemoveBlock(@NotNull Player player) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        if (!player.m_6084_()) {
            return false;
        }
        @Nullable IPlayableFaction<?> faction = VampirismPlayerAttributes.get((Player)player).faction;
        if (faction == this.controllingFaction) {
            if (this.capturingFaction == null) {
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.village.totem_destroy.fail_other_capturing"), true);
            return false;
        }
        if (faction == this.capturingFaction) {
            if (this.controllingFaction == null) {
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.village.totem_destroy.fail_other_faction"), true);
            return false;
        }
        if (this.capturingFaction != null || this.controllingFaction != null) {
            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.village.totem_destroy.fail_other_faction"), true);
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getBaseColors() {
        return this.baseColors;
    }

    @Override
    @NotNull
    public Optional<EntityType<? extends Mob>> getCaptureEntityForFaction(@NotNull IFaction<?> faction) {
        return WeightedRandom.m_216822_((RandomSource)RNG, faction.getVillageData().getCaptureEntries()).map(CaptureEntityEntry::getEntity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCaptureProgress() {
        return this.capturingFaction == null ? 0 : (this.phase == CAPTURE_PHASE.PHASE_2 ? 80 : (int)((float)this.captureTimer / (float)((Integer)VampirismConfig.BALANCE.viPhase1Duration.get()).intValue() * 80.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getCapturingColors() {
        return this.progressColor;
    }

    @Override
    @Nullable
    public IFaction<?> getCapturingFaction() {
        return this.capturingFaction;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    @Nullable
    public IFaction<?> getControllingFaction() {
        return this.controllingFaction;
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @NotNull
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int getSize() {
        return this.village.size();
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void initiateCapture(@NotNull Player player) {
        if (!player.m_6084_()) {
            return;
        }
        this.initiateCapture(VampirismPlayerAttributes.get((Player)player).faction, (arg_0, arg_1) -> ((Player)player).m_5661_(arg_0, arg_1), -1, -1.0f);
    }

    @Override
    @NotNull
    public AABB getVillageArea() {
        if (this.villageArea == null) {
            this.updateVillageArea();
        }
        return this.villageArea;
    }

    @Override
    @NotNull
    public AABB getVillageAreaReduced() {
        if (this.villageAreaReduced == null) {
            this.updateVillageArea();
        }
        return this.villageAreaReduced;
    }

    public void initiateCapture(@NotNull IFaction<?> faction, @Nullable BiConsumer<Component, Boolean> feedback, int badOmenLevel, float strengthModifier) {
        this.updateTileStatus();
        if (!this.capturePreconditions(faction, feedback == null ? (a, b) -> {} : feedback)) {
            return;
        }
        this.forceVillageUpdate = true;
        this.captureAbortTimer = 0;
        this.captureDuration = 24000;
        this.captureTimer = 0;
        this.captureForceTargetTimer = 0;
        this.setCapturingFaction(faction);
        this.calculateAttackStrength(badOmenLevel, strengthModifier);
        this.timeSinceLastRaid = 0L;
        if (this.controllingFaction == null) {
            this.phase = CAPTURE_PHASE.PHASE_1_NEUTRAL;
            this.notifyNearbyPlayers((Component)Component.m_237110_((String)"text.vampirism.village.neutral_village_under_attack", (Object[])new Object[]{faction.getNamePlural()}));
        } else {
            this.phase = CAPTURE_PHASE.PHASE_1_OPPOSITE;
            this.notifyNearbyPlayers((Component)Component.m_237110_((String)"text.vampirism.village.faction_village_under_attack", (Object[])new Object[]{this.controllingFaction.getNamePlural(), faction.getNamePlural()}));
        }
        this.m_6596_();
        this.makeAgressive();
        LOGGER.debug("Initiated capture with strength {} by {} at {} with badomen level {}", (Object)Float.valueOf(this.strengthRatio), (Object)faction.getID(), (Object)this.m_58899_(), (Object)badOmenLevel);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.badOmenLevel = compound.m_128451_("badOmenTriggered");
        this.isDisabled = compound.m_128471_("isDisabled");
        this.isComplete = compound.m_128471_("isComplete");
        this.isInsideVillage = compound.m_128471_("isInsideVillage");
        if (compound.m_128441_("controllingFaction")) {
            this.setControllingFaction(VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(compound.m_128461_("controllingFaction"))));
        } else {
            this.setControllingFaction(null);
        }
        if (compound.m_128441_("capturingFaction")) {
            this.setCapturingFaction(VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(compound.m_128461_("capturingFaction"))));
            this.captureTimer = compound.m_128451_("captureTimer");
            this.captureDuration = compound.m_128451_("captureDuration");
            this.phase = CAPTURE_PHASE.valueOf(compound.m_128461_("phase"));
            this.strengthRatio = compound.m_128457_("strengthRatio");
            this.captureAbortTimer = compound.m_128451_("captureAbortTimer");
            if (this.phase == CAPTURE_PHASE.PHASE_2) {
                this.setupPhase2();
            }
        } else {
            this.setCapturingFaction(null);
        }
        if (this.f_58857_ != null && compound.m_128441_("villageArea")) {
            VampirismWorld.getOpt(this.f_58857_).ifPresent(vw -> {
                AABB aabb = UtilLib.intToBB(compound.m_128465_("villageArea"));
                vw.updateArtificialFogBoundingBox(this.f_58858_, (AABB)(this.controllingFaction == VReference.VAMPIRE_FACTION ? aabb : null));
                if (this.isRaidTriggeredByBadOmen() && this.capturingFaction == VReference.VAMPIRE_FACTION) {
                    vw.updateTemporaryArtificialFog(this.f_58858_, aabb);
                }
            });
        }
        this.forceVillageUpdate = true;
        ListTag list = compound.m_128437_("captureInfo", 10);
        for (Tag inbt : list) {
            Color color = new Color(((CompoundTag)inbt).m_128451_("color"), true);
            float perc = ((CompoundTag)inbt).m_128457_("perc");
            this.captureInfo.setPercentage(color, perc);
        }
        this.timeSinceLastRaid = compound.m_128454_("timeSinceLastRaid");
    }

    public void notifyNearbyPlayers(@NotNull Component textComponent) {
        for (Player player : this.f_58857_.m_6907_()) {
            if (player.m_20275_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()) > (double)((Integer)VampirismConfig.BALANCE.viNotifyDistanceSQ.get()).intValue()) continue;
            player.m_5661_(textComponent, true);
        }
    }

    public boolean initiateCaptureOrIncreaseBadOmenLevel(@NotNull IFaction<?> faction, @Nullable BiConsumer<Component, Boolean> feedback, int badOmenLevel, float strengthModifier) {
        if (this.capturingFaction == null) {
            this.initiateCapture(faction, feedback, badOmenLevel, strengthModifier);
            return true;
        }
        if (this.capturingFaction == faction) {
            if (this.phase == CAPTURE_PHASE.PHASE_1_OPPOSITE) {
                int tmpBadOmen = this.badOmenLevel;
                float tmpStrength = this.strengthRatio;
                this.calculateAttackStrength(this.badOmenLevel + badOmenLevel, strengthModifier);
                this.captureTimer /= 2;
                LOGGER.debug("Increase capture from strength {} and badomen level {} to strength {} and badomen level {}", (Object)Float.valueOf(tmpStrength), (Object)tmpBadOmen, (Object)Float.valueOf(this.strengthRatio), (Object)this.badOmenLevel);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isRaidTriggeredByBadOmen() {
        return this.badOmenLevel >= 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58898_()) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    public void ringBell(@NotNull Player playerEntity) {
        if (this.capturingFaction != null) {
            IPlayableFaction<?> faction = VampirismPlayerAttributes.get((Player)playerEntity).faction;
            boolean defender = faction == this.controllingFaction;
            boolean attacker = faction == this.capturingFaction;
            List entities = this.f_58857_.m_45976_(LivingEntity.class, this.getVillageArea());
            for (LivingEntity entity : entities) {
                IFaction<?> f = VampirismAPI.factionRegistry().getFaction((Entity)entity);
                if (f == null || entity instanceof ICaptureIgnore || attacker && this.capturingFaction == f || defender && this.controllingFaction == f) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120));
            }
        }
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("isDisabled", this.isDisabled);
        compound.m_128379_("isComplete", this.isComplete);
        compound.m_128379_("isInsideVillage", this.isInsideVillage);
        if (this.controllingFaction != null) {
            compound.m_128359_("controllingFaction", this.controllingFaction.getID().toString());
        }
        if (this.capturingFaction != null) {
            compound.m_128359_("capturingFaction", this.capturingFaction.getID().toString());
            compound.m_128405_("captureTimer", this.captureTimer);
            compound.m_128350_("strengthRatio", this.strengthRatio);
            compound.m_128405_("captureDuration", this.captureDuration);
            compound.m_128405_("captureAbortTimer", this.captureAbortTimer);
            compound.m_128359_("phase", this.phase.name());
        }
        if (!this.village.isEmpty()) {
            compound.m_128385_("villageArea", UtilLib.bbToInt(this.getVillageArea()));
        }
        ListTag list = new ListTag();
        for (Map.Entry<Color, Float> entry : this.captureInfo.getEntries().entrySet()) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("color", entry.getKey().getRGB());
            nbt.m_128350_("perc", entry.getValue().floatValue());
            list.add((Object)nbt);
        }
        compound.m_128365_("captureInfo", (Tag)list);
        compound.m_128405_("badOmenTriggered", this.badOmenLevel);
        compound.m_128356_("timeSinceLastRaid", this.timeSinceLastRaid);
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            super.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
            if (!this.village.isEmpty()) {
                VampirismWorld.getOpt(this.f_58857_).ifPresent(vw -> {
                    vw.updateArtificialFogBoundingBox(this.f_58858_, this.controllingFaction == VReference.VAMPIRE_FACTION ? this.getVillageArea() : null);
                    if (this.isRaidTriggeredByBadOmen() && this.capturingFaction == VReference.VAMPIRE_FACTION) {
                        vw.updateTemporaryArtificialFog(this.f_58858_, this.getVillageArea());
                    }
                });
            }
        }
    }

    public void setForcedFaction(@Nullable IFaction<?> faction) {
        this.forcedFaction = faction;
        this.forcedFactionTimer = 5;
        this.m_6596_();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void onRemovedNotDueTuChunkUnload() {
        if (this.capturingFaction != null) {
            this.breakCapture();
        } else {
            this.updateBossinfoPlayers(null);
        }
    }

    public void m_7651_() {
        VampirismWorld.getOpt(this.f_58857_).ifPresent(vw -> vw.updateArtificialFogBoundingBox(this.f_58858_, null));
        TotemHelper.removeTotem((ResourceKey<Level>)this.f_58857_.m_46472_(), this.village, this.f_58858_, true);
        if (!this.unloaded) {
            this.onRemovedNotDueTuChunkUnload();
        }
        super.m_7651_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float shouldRenderBeam() {
        if (!this.isComplete || this.isDisabled || !this.isInsideVillage) {
            return 0.0f;
        }
        if (this.capturingFaction == null) {
            return 0.0f;
        }
        int i = (int)(this.f_58857_.m_46467_() - this.beamRenderCounter);
        this.beamRenderCounter = this.f_58857_.m_46467_();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    public static void clientTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull TotemBlockEntity blockEntity) {
        if (level.m_46467_() % 10L == 7L && blockEntity.controllingFaction != null) {
            ModParticles.spawnParticlesClient(level, new GenericParticleOptions(new ResourceLocation("minecraft", "generic_4"), 20, blockEntity.controllingFaction.getColor(), 0.2f), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 3, 30.0, level.f_46441_);
        }
    }

    private void serverTickSecondNonCapture(int timeInSeconds) {
        if (this.controllingFaction != null && timeInSeconds % 16 == 0) {
            List guards;
            int defenderNumMax;
            int max;
            int beds = (int)((ServerLevel)this.f_58857_).m_8904_().m_27181_(pointOfInterestType -> pointOfInterestType.m_203565_(PoiTypes.f_218060_), this.f_58858_, (int)Math.sqrt(Math.pow(this.getVillageArea().m_82362_(), 2.0) + Math.pow(this.getVillageArea().m_82385_(), 2.0)) / 2, PoiManager.Occupancy.ANY).count();
            boolean spawnTaskMaster = RNG.m_188503_(6) == 0;
            int villager = this.f_58857_.m_45976_(Villager.class, this.getVillageArea().m_82400_(20.0)).size();
            if (villager < (max = Math.min(beds, (Integer)VampirismConfig.BALANCE.viMaxVillagerRespawn.get()))) {
                boolean isConverted = this.controllingFaction == VReference.VAMPIRE_FACTION && RNG.m_188499_();
                this.spawnVillagerDefault(this.controllingFaction == VReference.HUNTER_FACTION, isConverted);
            } else {
                spawnTaskMaster = true;
            }
            if (spawnTaskMaster) {
                if (this.f_58857_.m_6443_(VampirismEntity.class, this.getVillageArea(), ITaskMasterEntity.class::isInstance).isEmpty()) {
                    this.spawnTaskMaster();
                }
            }
            if ((defenderNumMax = Math.min(6, this.village.size() / 5)) > (guards = this.f_58857_.m_45976_(this.controllingFaction.getVillageData().getGuardSuperClass(), this.getVillageArea())).size()) {
                this.getCaptureEntityForFaction(this.controllingFaction).ifPresent(entityType -> this.spawnEntity((Mob)entityType.m_20615_(this.f_58857_)));
            }
        }
        if (this.timeSinceLastRaid > 12000L && this.f_58857_.m_46791_() != Difficulty.PEACEFUL && (double)this.f_58857_.f_46441_.m_188501_() < (Double)VampirismConfig.BALANCE.viRandomRaidChance.get()) {
            ArrayList factions = Lists.newArrayList((Object[])VampirismAPI.factionRegistry().getFactions());
            if (this.controllingFaction != null) {
                factions.remove(this.controllingFaction);
            }
            this.initiateCapture((IFaction)factions.get(this.f_58857_.f_46441_.m_188503_(factions.size())), null, 0, -1.0f);
        }
    }

    private void serverTickSecondCapture(int timeInSeconds) {
        List entities = this.f_58857_.m_45976_(LivingEntity.class, this.getVillageArea());
        this.updateBossinfoPlayers(entities);
        int currentAttacker = 0;
        int attackerPlayer = 0;
        int currentDefender = 0;
        int defenderPlayer = 0;
        int neutral = 0;
        float attackerStrength = 0.0f;
        float defenderStrength = 0.0f;
        float attackerHealth = 0.0f;
        float attackerMaxHealth = 0.0f;
        float defenderHealth = 0.0f;
        float defenderMaxHealth = 0.0f;
        CaptureInfo captureInfo = new CaptureInfo(this);
        for (LivingEntity entity : entities) {
            IVillageCaptureEntity captureEntity;
            IFaction<?> faction = VampirismAPI.factionRegistry().getFaction((Entity)entity);
            if (faction == null || entity instanceof ICaptureIgnore || !entity.m_6084_()) continue;
            if (this.capturingFaction.equals(faction)) {
                ++currentAttacker;
                attackerStrength += this.getStrength(entity);
                attackerMaxHealth += entity.m_21233_();
                attackerHealth += entity.m_21223_();
                if (entity instanceof Player) {
                    ++attackerPlayer;
                }
                if (!(entity instanceof IVillageCaptureEntity)) continue;
                captureEntity = (IVillageCaptureEntity)entity;
                captureEntity.attackVillage(captureInfo);
                continue;
            }
            if (faction.equals(this.controllingFaction)) {
                ++currentDefender;
                defenderStrength += this.getStrength(entity);
                defenderMaxHealth += entity.m_21233_();
                defenderHealth += entity.m_21223_();
                if (entity instanceof Player) {
                    ++defenderPlayer;
                }
                if (!(entity instanceof IVillageCaptureEntity)) continue;
                captureEntity = (IVillageCaptureEntity)entity;
                captureEntity.defendVillage(captureInfo);
                continue;
            }
            ++neutral;
        }
        this.captureAbortTimer = currentAttacker == 0 ? ++this.captureAbortTimer : 0;
        ++this.captureTimer;
        --this.captureDuration;
        if (this.phase == CAPTURE_PHASE.PHASE_2) {
            ++this.captureForceTargetTimer;
        }
        if (this.captureDuration == 0 || this.captureAbortTimer > 10) {
            this.abortCapture();
        } else {
            switch (this.phase) {
                case PHASE_1_NEUTRAL: {
                    if (this.captureTimer >= (Integer)VampirismConfig.BALANCE.viPhase1Duration.get()) {
                        this.captureTimer = 1;
                        this.setupPhase2();
                        this.m_6596_();
                        break;
                    }
                    if (this.captureTimer % 2 != 0 || !(attackerStrength < 5.0f)) break;
                    this.spawnCaptureEntity(this.capturingFaction);
                    break;
                }
                case PHASE_1_OPPOSITE: {
                    if (this.captureTimer >= (Integer)VampirismConfig.BALANCE.viPhase1Duration.get()) {
                        this.captureTimer = 1;
                        this.setupPhase2();
                        this.m_6596_();
                        this.notifyNearbyPlayers((Component)Component.m_237110_((String)"text.vampirism.village.almost_captured", (Object[])new Object[]{currentDefender}));
                        break;
                    }
                    if (this.captureTimer % 2 != 0) break;
                    float max = attackerStrength + defenderStrength;
                    if (attackerStrength / max <= this.strengthRatio) {
                        this.spawnCaptureEntity(this.capturingFaction);
                        break;
                    }
                    if (!(defenderStrength / max <= 1.0f - this.strengthRatio)) break;
                    this.spawnCaptureEntity(this.controllingFaction);
                    break;
                }
                case PHASE_2: {
                    if (currentDefender == 0) {
                        ++this.captureTimer;
                        if (this.captureTimer <= 4) break;
                        this.completeCapture(true, false);
                        break;
                    }
                    if (currentAttacker == 0) {
                        ++this.captureTimer;
                        if (this.captureTimer <= 4) break;
                        this.abortCapture();
                        break;
                    }
                    this.captureTimer = 1;
                }
            }
            this.handleBossBar(defenderMaxHealth, defenderHealth, attackerMaxHealth, attackerHealth);
        }
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull TotemBlockEntity blockEntity) {
        long time;
        if (blockEntity.isDisabled) {
            level.m_46961_(pos, true);
            if (level.m_8055_(pos.m_7495_()).m_60734_() instanceof TotemBaseBlock) {
                level.m_46961_(pos.m_7495_(), true);
            }
        }
        if ((time = level.m_46467_()) % 20L == 0L) {
            blockEntity.updateTileStatus();
        }
        if (!blockEntity.checkTileStatus()) {
            if (!blockEntity.isInsideVillage && blockEntity.capturingFaction != null) {
                blockEntity.breakCapture();
            }
            return;
        }
        if (blockEntity.forcedFaction != null) {
            if (blockEntity.forcedFactionTimer > 0) {
                if (blockEntity.forcedFactionTimer == 1) {
                    blockEntity.breakCapture();
                }
                --blockEntity.forcedFactionTimer;
            } else {
                blockEntity.setCapturingFaction(blockEntity.forcedFaction);
                blockEntity.completeCapture(false, true);
                blockEntity.forcedFaction = null;
            }
        }
        if (blockEntity.forceVillageUpdate) {
            blockEntity.updateTileStatus();
            blockEntity.forceVillageUpdate = false;
        }
        if (time % 12000L == 0L) {
            blockEntity.updateVillageArea();
        }
        TotemBlockEntity.setupVampireForestSearch(blockEntity, (ServerLevel)level, pos);
        if (blockEntity.capturingFaction != null) {
            if (time % 20L == 0L) {
                assert (blockEntity.f_58857_ == level);
                blockEntity.serverTickSecondCapture((int)(time / 20L));
            }
        } else {
            ++blockEntity.timeSinceLastRaid;
            if (time % 20L == 7L) {
                blockEntity.serverTickSecondNonCapture((int)(time / 20L));
            }
        }
    }

    public void updateTileStatus() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            Set<PoiRecord> points;
            ServerLevel serverLevel = (ServerLevel)level;
            Block b = this.f_58857_.m_8055_(this.f_58858_).m_60734_();
            this.isComplete = b instanceof TotemTopBlock && serverLevel.m_8055_(this.f_58858_.m_7495_()).m_60734_().equals(ModBlocks.TOTEM_BASE.get());
            if (!this.isComplete) {
                return;
            }
            ResourceLocation blockFaction = ((TotemTopBlock)b).faction;
            if (!blockFaction.equals((Object)(this.controllingFaction == null ? nonFactionTotem : this.controllingFaction.getID()))) {
                this.forcedFaction = VampirismAPI.factionRegistry().getFactionByID(blockFaction);
            }
            if (!(this.isInsideVillage = !(points = TotemHelper.getVillagePointsOfInterest(serverLevel, this.f_58858_)).isEmpty())) {
                this.village = Collections.emptySet();
                if (this.controllingFaction != null) {
                    this.setControllingFaction(null);
                }
            } else if (7 != TotemHelper.isVillage(points, serverLevel, this.f_58858_, this.controllingFaction != null || this.capturingFaction != null)) {
                this.isInsideVillage = false;
                this.village = Collections.emptySet();
                if (this.controllingFaction != null) {
                    this.setControllingFaction(null);
                }
            } else {
                this.isDisabled = !TotemHelper.addTotem(serverLevel, points, this.f_58858_);
                if (!this.isDisabled) {
                    this.village.removeIf(points::contains);
                    TotemHelper.removeTotem((ResourceKey<Level>)serverLevel.m_46472_(), this.village, this.f_58858_, false);
                    this.village = points;
                } else {
                    this.village = Collections.emptySet();
                }
            }
            this.m_6596_();
        }
    }

    public void updateTrainer(boolean toDummy) {
        EntityType entityType;
        List trainer;
        if (toDummy) {
            trainer = this.f_58857_.m_45976_(HunterTrainerEntity.class, this.getVillageArea());
            entityType = (EntityType)ModEntities.HUNTER_TRAINER_DUMMY.get();
        } else {
            trainer = this.f_58857_.m_45976_(DummyHunterTrainerEntity.class, this.getVillageArea());
            entityType = (EntityType)ModEntities.HUNTER_TRAINER.get();
        }
        for (VampirismEntity oldEntity : trainer) {
            VampirismEntity newEntity = (VampirismEntity)entityType.m_20615_(this.f_58857_);
            if (newEntity == null) continue;
            newEntity.m_20361_((Entity)oldEntity);
            newEntity.m_20084_(Mth.m_14002_());
            newEntity.m_20331_(true);
            UtilLib.replaceEntity((LivingEntity)oldEntity, (LivingEntity)newEntity);
        }
    }

    private void applyVictoryBonus(boolean attackWin) {
        for (Player player : this.f_58857_.m_6907_()) {
            if (player.m_5833_() || !this.getVillageArea().m_82390_(player.m_20182_()) || player.m_5833_() || VampirismAPI.factionRegistry().getFaction((Entity)player) != (attackWin ? this.capturingFaction : this.controllingFaction)) continue;
            if (!attackWin) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 48000, Math.max(this.badOmenLevel - 1, 0), false, false, true));
            }
            player.m_36220_(ModStats.win_village_capture);
            if (attackWin) {
                player.m_36220_(ModStats.capture_village);
                continue;
            }
            player.m_36220_(ModStats.defend_village);
        }
    }

    private boolean capturePreconditions(@Nullable IFaction<?> faction, @NotNull BiConsumer<Component, Boolean> feedback) {
        if (faction == null) {
            feedback.accept((Component)Component.m_237115_((String)"text.vampirism.village.no_faction"), true);
            return false;
        }
        if (this.capturingFaction != null) {
            feedback.accept((Component)Component.m_237115_((String)"text.vampirism.village.capturing_in_progress"), true);
            return false;
        }
        if (faction.equals(this.controllingFaction)) {
            feedback.accept((Component)Component.m_237115_((String)"text.vampirism.village.same_faction"), true);
            return false;
        }
        if (!this.isInsideVillage) {
            if (this.getControllingFaction() != null) {
                this.setControllingFaction(null);
                this.m_6596_();
            }
            Map<Integer, Integer> stats = TotemHelper.getVillageStats(TotemHelper.getVillagePointsOfInterest((ServerLevel)this.f_58857_, this.f_58858_), this.f_58857_);
            int status = TotemHelper.isVillage(stats, this.controllingFaction != null || this.capturingFaction != null);
            MutableComponent text = Component.m_237115_((String)"text.vampirism.village.missing_components");
            if ((status & 1) == 0) {
                text.m_130946_("\n  - ");
                text.m_7220_((Component)Component.m_237115_((String)"text.vampirism.village.missing_components.home"));
                text.m_130946_(" " + stats.get(1) + "/4");
            }
            if ((status & 2) == 0) {
                text.m_130946_("\n  - ");
                text.m_7220_((Component)Component.m_237115_((String)"text.vampirism.village.missing_components.workstations"));
                text.m_130946_(" " + stats.get(2) + "/2");
            }
            if ((status & 4) == 0) {
                text.m_130946_("\n  - ");
                text.m_7220_((Component)Component.m_237115_((String)"text.vampirism.village.missing_components.villager"));
                text.m_130946_(" " + stats.get(4) + "/4");
            }
            feedback.accept((Component)text, false);
            return false;
        }
        if (this.isDisabled) {
            feedback.accept((Component)Component.m_237115_((String)"text.vampirism.village.othertotem"), true);
            return false;
        }
        VampirismVillageEvent.InitiateCapture event = new VampirismVillageEvent.InitiateCapture(this, faction);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult().equals((Object)Event.Result.DENY)) {
            feedback.accept((Component)Component.m_237115_((String)event.getMessage()), true);
            return false;
        }
        return true;
    }

    private void completeCapture(boolean notifyPlayer, boolean fullConvert) {
        this.informEntitiesAboutCaptureStop();
        if (!this.f_58857_.f_46443_) {
            this.updateCreaturesOnCapture(fullConvert);
        }
        this.applyVictoryBonus(true);
        this.setControllingFaction(this.capturingFaction);
        this.setCapturingFaction(null);
        if (notifyPlayer) {
            assert (this.controllingFaction != null);
            this.notifyNearbyPlayers((Component)Component.m_237110_((String)"text.vampirism.village.village_captured_by", (Object[])new Object[]{this.controllingFaction.getNamePlural()}));
        }
        this.updateBossinfoPlayers(null);
        this.m_6596_();
    }

    private void calculateAttackStrength(int badOmenLevel, float strengthModifier) {
        this.badOmenLevel = Mth.m_14045_((int)badOmenLevel, (int)-1, (int)5);
        int level = this.badOmenLevel - 1;
        float defenderStrength = 1.0f;
        float attackerStrength = 1.0f;
        if (level >= 0) {
            attackerStrength += 0.25f + 0.4375f * (float)level;
        }
        if (strengthModifier > 0.0f) {
            attackerStrength += strengthModifier;
        } else {
            defenderStrength -= strengthModifier;
        }
        Pair<Float, Float> strength = VampirismEventFactory.fireDefineRaidStrengthEvent(this, level, defenderStrength, attackerStrength);
        this.strengthRatio = ((Float)strength.getRight()).floatValue() / (((Float)strength.getLeft()).floatValue() + ((Float)strength.getRight()).floatValue());
    }

    private void informEntitiesAboutCaptureStop() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        List list = this.f_58857_.m_45976_(PathfinderMob.class, this.getVillageArea());
        for (PathfinderMob e : list) {
            if (!(e instanceof IVillageCaptureEntity)) continue;
            IVillageCaptureEntity captureEntity = (IVillageCaptureEntity)e;
            captureEntity.stopVillageAttackDefense();
        }
    }

    private boolean checkTileStatus() {
        return this.isComplete && this.isInsideVillage && !this.isDisabled && !this.village.isEmpty();
    }

    private void makeAgressive() {
        if (((Boolean)VampirismConfig.SERVER.disableVillageGuards.get()).booleanValue()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            List villagerEntities = this.f_58857_.m_45976_(Villager.class, this.getVillageArea());
            for (Villager villager : villagerEntities) {
                if (villager instanceof IFactionEntity || !VampirismEventFactory.fireMakeAggressive(this, villager) || !VReference.VAMPIRE_FACTION.equals(this.capturingFaction) || villager.m_146764_() < 0 || RNG.m_188503_(3) != 0) continue;
                TotemBlockEntity.makeAgressive(villager);
            }
        }
    }

    private float getStrength(@NotNull LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return FactionPlayerHandler.getOpt(player).map(FactionPlayerHandler::getCurrentLevelRelative).orElse(Float.valueOf(0.0f)).floatValue();
        }
        if (entity instanceof ConvertedVillagerEntity) {
            return 0.5f;
        }
        if (entity instanceof IAggressiveVillager) {
            return 0.7f;
        }
        if (entity instanceof Villager) {
            return 0.4f;
        }
        return 1.0f;
    }

    private void handleBossBar(float defenderMaxHealth, float defenderHealth, float attackerMaxHealth, float attackerHealth) {
        float neutralPerc;
        switch (this.phase) {
            case PHASE_1_NEUTRAL: 
            case PHASE_1_OPPOSITE: {
                neutralPerc = (float)this.captureTimer / (float)((Integer)VampirismConfig.BALANCE.viPhase1Duration.get()).intValue();
                break;
            }
            case PHASE_2: {
                neutralPerc = 1.0f;
                this.captureInfo.setName((Component)Component.m_237115_((String)"text.vampirism.village.bossinfo.remaining"));
                break;
            }
            default: {
                neutralPerc = 0.0f;
            }
        }
        float max = defenderHealth + attackerHealth;
        this.captureInfo.setPercentage(neutralPerc * attackerHealth / max, 1.0f - neutralPerc, neutralPerc * defenderHealth / max);
    }

    private void setCapturingFaction(@Nullable IFaction<?> faction) {
        this.capturingFaction = faction;
        float[] fArray = this.progressColor = faction != null ? new Color(faction.getColor()).getRGBColorComponents() : DyeColor.WHITE.m_41068_();
        if (faction != null) {
            this.captureInfo.setColors(new Color(faction.getColor()), Color.WHITE, this.controllingFaction == null ? Color.WHITE : new Color(this.controllingFaction.getColor()));
            this.captureInfo.setName((Component)Component.m_237110_((String)"text.vampirism.village.bossinfo.raid", (Object[])new Object[]{faction.getName().m_6879_().m_130938_(style -> style.m_131148_(faction.getChatColor()))}));
        }
    }

    private void setControllingFaction(@Nullable IFaction<?> faction) {
        this.controllingFaction = faction;
        float[] fArray = this.baseColors = faction != null ? new Color(faction.getColor()).getRGBColorComponents() : DyeColor.WHITE.m_41068_();
        if (this.f_58857_ != null) {
            TotemTopBlock totem;
            boolean crafted;
            BlockState oldBlockState = this.m_58900_();
            Block b = oldBlockState.m_60734_();
            boolean bl = crafted = b instanceof TotemTopBlock && (totem = (TotemTopBlock)b).isCrafted();
            BlockState newBlockState = (faction == null ? (crafted ? (TotemTopBlock)((Object)ModBlocks.TOTEM_TOP_CRAFTED.get()) : (TotemTopBlock)((Object)ModBlocks.TOTEM_TOP.get())) : faction.getVillageData().getTotemTopBlock(crafted)).m_49966_();
            try {
                this.f_58857_.m_7731_(this.f_58858_, newBlockState, 55);
            }
            catch (IllegalStateException e) {
                LOGGER.error("Setting blockstate from {} to {}", (Object)oldBlockState, (Object)newBlockState);
                LOGGER.error("Failed to set totem blockstate", (Throwable)e);
            }
        }
    }

    private void setupPhase2() {
        if (this.phase != CAPTURE_PHASE.PHASE_2) {
            this.phase = CAPTURE_PHASE.PHASE_2;
            this.captureInfo.setName((Component)Component.m_237115_((String)"text.vampirism.village.bossinfo.remaining"));
        }
    }

    private void spawnCaptureEntity(@Nullable IFaction<?> faction) {
        if (faction == null) {
            return;
        }
        assert (this.f_58857_ instanceof ServerLevel);
        EntityType entityType = this.getCaptureEntityForFaction(faction).orElse(null);
        if (entityType == null) {
            LOGGER.warn("No village capture entity registered for {}", faction);
            return;
        }
        Mob entity = (Mob)entityType.m_20615_(this.f_58857_);
        if (entity instanceof VampireBaseEntity) {
            VampireBaseEntity vampire = (VampireBaseEntity)entity;
            vampire.setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SIMPLE);
        }
        List players = this.f_58857_.m_6907_();
        players.removeIf(Player::m_5833_);
        if (entity != null && !UtilLib.spawnEntityInWorld((ServerLevel)this.f_58857_, this.getVillageAreaReduced(), (Entity)entity, 50, (List<? extends LivingEntity>)players, MobSpawnType.EVENT)) {
            entity.m_146870_();
            entity = null;
        }
        if (entity instanceof IVillageCaptureEntity) {
            IVillageCaptureEntity captureEntity = (IVillageCaptureEntity)entity;
            if (faction == this.controllingFaction) {
                captureEntity.defendVillage(new CaptureInfo(this));
            } else {
                captureEntity.attackVillage(new CaptureInfo(this));
            }
        } else if (entity != null) {
            LOGGER.warn("Creature registered for village capture does not implement IVillageCaptureEntity ({})", (Object)RegUtil.id(entityType));
        } else {
            LOGGER.info("Failed to spawn capture creature");
        }
    }

    private void spawnEntity(@NotNull Mob newEntity) {
        assert (this.f_58857_ instanceof ServerLevel);
        UtilLib.spawnEntityInWorld((ServerLevel)this.f_58857_, this.getVillageAreaReduced(), (Entity)newEntity, 50, (List<? extends LivingEntity>)Lists.newArrayList(), MobSpawnType.EVENT);
    }

    private void spawnEntity(@NotNull Mob newEntity, @NotNull Mob oldEntity, boolean replaceOld, boolean copyData) {
        if (copyData) {
            newEntity.m_20361_((Entity)oldEntity);
        } else {
            newEntity.m_20359_((Entity)oldEntity);
        }
        newEntity.m_20084_(Mth.m_14002_());
        assert (this.f_58857_ != null);
        if (replaceOld) {
            UtilLib.replaceEntity((LivingEntity)oldEntity, (LivingEntity)newEntity);
        } else {
            this.f_58857_.m_7967_((Entity)newEntity);
        }
    }

    private void spawnTaskMaster() {
        assert (this.f_58857_ instanceof ServerLevel);
        assert (this.controllingFaction != null);
        EntityType<? extends ITaskMasterEntity> entity = this.controllingFaction.getVillageData().getTaskMasterEntity();
        if (entity != null) {
            ITaskMasterEntity newEntity = (ITaskMasterEntity)entity.m_20615_(this.f_58857_);
            newEntity.setHome(this.getVillageAreaReduced());
            UtilLib.spawnEntityInWorld((ServerLevel)this.f_58857_, this.getVillageAreaReduced(), (Entity)newEntity, 25, (List<? extends LivingEntity>)Lists.newArrayList(), MobSpawnType.EVENT);
        }
    }

    private void spawnVillagerDefault(boolean poisonousBlood, boolean vampire) {
        assert (!poisonousBlood || !vampire);
        Villager newVillager = (Villager)(vampire ? (EntityType)ModEntities.VILLAGER_CONVERTED.get() : EntityType.f_20492_).m_20615_(this.f_58857_);
        newVillager = VampirismEventFactory.fireSpawnNewVillagerEvent(this, null, newVillager, false);
        ExtendedCreature.getSafe((Entity)newVillager).ifPresent(e -> e.setPoisonousBlood(poisonousBlood));
        this.spawnEntity((Mob)newVillager);
    }

    private void spawnVillagerReplace(@NotNull Mob oldEntity, boolean poisonousBlood, boolean vampire) {
        assert (!poisonousBlood || !vampire);
        Villager newVillager = (Villager)(vampire ? (EntityType)ModEntities.VILLAGER_CONVERTED.get() : EntityType.f_20492_).m_20615_(this.f_58857_);
        if (oldEntity instanceof Villager) {
            newVillager.m_21446_(oldEntity.m_21534_(), (int)oldEntity.m_21535_());
        }
        newVillager = VampirismEventFactory.fireSpawnNewVillagerEvent(this, oldEntity, newVillager, true);
        ExtendedCreature.getSafe((Entity)newVillager).ifPresent(e -> e.setPoisonousBlood(poisonousBlood));
        this.spawnEntity((Mob)newVillager, oldEntity, true, true);
    }

    private void spawnVillagerReplaceForced(@NotNull Mob oldEntity, boolean poisonousBlood, boolean vampire) {
        assert (!poisonousBlood || !vampire);
        Villager newVillager = (Villager)(vampire ? (EntityType)ModEntities.VILLAGER_CONVERTED.get() : EntityType.f_20492_).m_20615_(this.f_58857_);
        newVillager.m_20359_((Entity)oldEntity);
        if (oldEntity instanceof Villager) {
            newVillager.m_21446_(oldEntity.m_21534_(), (int)oldEntity.m_21535_());
        }
        newVillager = VampirismEventFactory.fireSpawnNewVillagerEvent(this, oldEntity, newVillager, true);
        ExtendedCreature.getSafe((Entity)newVillager).ifPresent(e -> e.setPoisonousBlood(poisonousBlood));
        UtilLib.replaceEntity((LivingEntity)oldEntity, (LivingEntity)newVillager);
    }

    private void updateBossinfoPlayers(@Nullable List<LivingEntity> includedPlayerEntities) {
        HashSet<ServerPlayer> oldList = new HashSet<ServerPlayer>(this.captureInfo.getPlayers());
        if (includedPlayerEntities != null) {
            for (LivingEntity entity : includedPlayerEntities) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (oldList.remove(entity)) continue;
                this.captureInfo.addPlayer(serverPlayer);
            }
        }
        for (ServerPlayer player : oldList) {
            this.captureInfo.removePlayer(player);
        }
    }

    private void updateCreaturesOnCapture(boolean fullConvert) {
        List villagerEntities = this.f_58857_.m_45976_(Villager.class, this.getVillageArea());
        if (VampirismEventFactory.fireVillagerCaptureEventPre(this, villagerEntities, fullConvert)) {
            return;
        }
        if (VReference.HUNTER_FACTION.equals(this.capturingFaction)) {
            hunterEntities = this.f_58857_.m_45976_(HunterBaseEntity.class, this.getVillageArea());
            int i = Math.max(2, hunterEntities.size() / 2);
            Iterator iterator = hunterEntities.iterator();
            while (iterator.hasNext()) {
                HunterBaseEntity hunter = (HunterBaseEntity)iterator.next();
                if (hunter instanceof ICaptureIgnore || i-- <= 0) continue;
                this.spawnVillagerReplace((Mob)hunter, true, false);
            }
            for (int o = i; o > 0; --o) {
                this.spawnVillagerDefault(true, false);
            }
            for (Villager villager : villagerEntities) {
                ExtendedCreature.getSafe((Entity)villager).ifPresent(e -> e.setPoisonousBlood(true));
            }
            this.updateTrainer(false);
        } else if (VReference.HUNTER_FACTION.equals(this.controllingFaction)) {
            this.updateTrainer(true);
            for (Object villager : villagerEntities) {
                ExtendedCreature.getSafe((Entity)villager).ifPresent(e -> e.setPoisonousBlood(false));
            }
            if (fullConvert) {
                Object villager;
                hunterEntities = this.f_58857_.m_45976_(HunterBaseEntity.class, this.getVillageArea());
                villager = hunterEntities.iterator();
                while (villager.hasNext()) {
                    HunterBaseEntity hunter = (HunterBaseEntity)villager.next();
                    if (hunter instanceof ICaptureIgnore) continue;
                    this.getCaptureEntityForFaction(this.capturingFaction).ifPresent(type -> this.spawnEntity((Mob)type.m_20615_(this.f_58857_), (Mob)hunter, true, false));
                }
            }
        } else {
            this.updateTrainer(true);
        }
        if (VReference.VAMPIRE_FACTION.equals(this.capturingFaction)) {
            for (Villager villager : villagerEntities) {
                if (!fullConvert) {
                    if (RNG.m_188503_(2) == 1) continue;
                    SanguinareEffect.addRandom((LivingEntity)villager, false);
                    continue;
                }
                villager.m_7292_((MobEffectInstance)new SanguinareEffectInstance(11));
            }
        } else if (VReference.VAMPIRE_FACTION.equals(this.controllingFaction)) {
            for (Villager villager : villagerEntities) {
                if (villager.m_21023_((MobEffect)ModEffects.SANGUINARE.get())) {
                    villager.m_21195_((MobEffect)ModEffects.SANGUINARE.get());
                }
                if (!fullConvert || !(villager instanceof ConvertedVillagerEntity)) continue;
                this.spawnVillagerReplaceForced((Mob)villager, this.capturingFaction == VReference.HUNTER_FACTION, false);
            }
            if (fullConvert) {
                List vampireEntities = this.f_58857_.m_45976_(VampireBaseEntity.class, this.getVillageArea());
                for (VampireBaseEntity vampire : vampireEntities) {
                    if (vampire instanceof ICaptureIgnore) continue;
                    this.getCaptureEntityForFaction(this.capturingFaction).ifPresent(type -> this.spawnEntity((Mob)type.m_20615_(this.f_58857_), (Mob)vampire, true, false));
                }
            }
        }
        villagerEntities = this.f_58857_.m_45976_(Villager.class, this.getVillageArea());
        for (Villager villager : villagerEntities) {
            if (!ForgeRegistries.VILLAGER_PROFESSIONS.tags().getTag(ModTags.Professions.HAS_FACTION).contains((Object)villager.m_7141_().m_35571_())) continue;
            villager.m_34375_(villager.m_7141_().m_35565_(VillagerProfession.f_35585_));
        }
        VampirismEventFactory.fireVillagerCaptureEventPost(this, villagerEntities, fullConvert);
    }

    private void updateVillageArea() {
        Optional<StructureStart> start;
        if (this.villageArea != null && this.villageAreaReduced != null && this.village.stream().allMatch(point -> this.villageAreaReduced.m_82390_(Vec3.m_82528_((Vec3i)point.m_27257_())))) {
            return;
        }
        AABB totem = TotemHelper.getAABBAroundPOIs(this.village);
        if (totem == null) {
            totem = new AABB(this.f_58858_);
        }
        if ((start = UtilLib.getStructureStartAt(this.f_58857_, this.f_58858_, (TagKey<Structure>)StructureTags.f_215889_)).isPresent()) {
            totem = totem.m_82367_(UtilLib.MBtoAABB(start.get().m_73601_()));
        }
        this.villageArea = totem;
        this.villageAreaReduced = totem.m_82377_(-30.0, -10.0, -30.0);
    }

    private static void setupVampireForestSearch(@NotNull TotemBlockEntity blockEntity, @NotNull ServerLevel level, @NotNull BlockPos center) {
        if (blockEntity.closestVampireForest == null) {
            ResourceKey<Biome> biomeId = ModBiomes.VAMPIRE_FOREST;
            blockEntity.closestVampireForest = CompletableFuture.supplyAsync(Util.m_183946_((String)"Find vampire forest", () -> {
                Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.f_211544_);
                com.mojang.datafixers.util.Pair location = level.m_215069_(b -> b.m_203565_(biomeId), center, 5000, 8, 16);
                LOGGER.debug("Looking for vampire forest took {}s", (Object)((double)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0));
                return location == null ? null : (BlockPos)location.getFirst();
            }), Util.m_183991_()).handle((result, exception) -> result);
        }
    }

    @Override
    public Optional<BlockPos> getVampireForestLocation() {
        if (this.closestVampireForest == null || !this.closestVampireForest.isDone()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.closestVampireForest.join());
    }

    private static enum CAPTURE_PHASE {
        PHASE_1_NEUTRAL,
        PHASE_1_OPPOSITE,
        PHASE_2;

    }

    public static class CaptureInfo
    implements ICaptureAttributes {
        @Nullable
        private final IFaction<?> defendingFaction;
        @Nullable
        private final IFaction<?> attackingFaction;
        @NotNull
        private final AABB villageArea;
        @NotNull
        private final BlockPos pos;
        private final boolean shouldForceTargets;

        private CaptureInfo(@NotNull TotemBlockEntity totem) {
            this.defendingFaction = totem.controllingFaction;
            this.attackingFaction = totem.capturingFaction;
            this.villageArea = totem.getVillageAreaReduced();
            this.pos = totem.f_58858_;
            this.shouldForceTargets = totem.captureForceTargetTimer > (Integer)VampirismConfig.BALANCE.viForceTargetTime.get();
        }

        @Override
        @Nullable
        public IFaction<?> getAttackingFaction() {
            return this.attackingFaction;
        }

        @Override
        @Nullable
        public IFaction<?> getDefendingFaction() {
            return this.defendingFaction;
        }

        @Override
        public BlockPos getPosition() {
            return this.pos;
        }

        @Override
        public AABB getVillageArea() {
            return this.villageArea;
        }

        @Override
        public boolean shouldForceTargets() {
            return this.shouldForceTargets;
        }
    }
}

