/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.teamlapen.vampirism.blocks.CursedBarkBlock;
import de.teamlapen.vampirism.blocks.CursedSpruceBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.util.Helper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class DiagonalCursedBarkBlock
extends CursedBarkBlock {
    public static final Table<Direction, Direction, BooleanProperty> PROPERTY_TABLE = HashBasedTable.create();
    private static final Map<BooleanProperty, Pair<Direction, Direction>> DIRECTION_MAP = new HashMap<BooleanProperty, Pair<Direction, Direction>>();
    public static final BooleanProperty UP_WEST = DiagonalCursedBarkBlock.createProperty(Direction.UP, Direction.WEST);
    public static final BooleanProperty UP_NORTH = DiagonalCursedBarkBlock.createProperty(Direction.UP, Direction.NORTH);
    public static final BooleanProperty UP_EAST = DiagonalCursedBarkBlock.createProperty(Direction.UP, Direction.EAST);
    public static final BooleanProperty UP_SOUTH = DiagonalCursedBarkBlock.createProperty(Direction.UP, Direction.SOUTH);
    public static final BooleanProperty DOWN_WEST = DiagonalCursedBarkBlock.createProperty(Direction.DOWN, Direction.WEST);
    public static final BooleanProperty DOWN_NORTH = DiagonalCursedBarkBlock.createProperty(Direction.DOWN, Direction.NORTH);
    public static final BooleanProperty DOWN_EAST = DiagonalCursedBarkBlock.createProperty(Direction.DOWN, Direction.EAST);
    public static final BooleanProperty DOWN_SOUTH = DiagonalCursedBarkBlock.createProperty(Direction.DOWN, Direction.SOUTH);
    public static final BooleanProperty NORTH_WEST = DiagonalCursedBarkBlock.createProperty(Direction.NORTH, Direction.WEST);
    public static final BooleanProperty WEST_SOUTH = DiagonalCursedBarkBlock.createProperty(Direction.WEST, Direction.SOUTH);
    public static final BooleanProperty SOUTH_EAST = DiagonalCursedBarkBlock.createProperty(Direction.SOUTH, Direction.EAST);
    public static final BooleanProperty EAST_NORTH = DiagonalCursedBarkBlock.createProperty(Direction.EAST, Direction.NORTH);

    public DiagonalCursedBarkBlock() {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST_NORTH, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return DIRECTION_MAP.entrySet().stream().filter(entry -> (Boolean)state.m_61143_((Property)entry.getKey())).anyMatch(e -> level.m_8055_(pos.m_121945_((Direction)((Pair)e.getValue()).getKey()).m_121945_((Direction)((Pair)e.getValue()).getValue())).m_60734_() instanceof CursedSpruceBlock);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState otherState, @NotNull LevelAccessor levelAccessor, @NotNull BlockPos pos, @NotNull BlockPos otherPos) {
        if (!otherState.m_60713_((Block)ModBlocks.DIRECT_CURSED_BARK.get())) {
            for (Map.Entry entry : PROPERTY_TABLE.column((Object)direction).entrySet()) {
                state = (BlockState)state.m_61124_((Property)entry.getValue(), (Comparable)Boolean.valueOf(false));
            }
            if (!this.anyProperty(state)) {
                state = Blocks.f_50016_.m_49966_();
            }
        } else {
            for (Map.Entry entry : PROPERTY_TABLE.row((Object)direction).entrySet()) {
                if (!levelAccessor.m_8055_(pos.m_121945_((Direction)entry.getKey())).m_60713_((Block)ModBlocks.DIRECT_CURSED_BARK.get())) continue;
                state.m_61124_((Property)entry.getValue(), (Comparable)Boolean.valueOf(true));
            }
        }
        return state;
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (Helper.isVampire(entity) || entity instanceof Player && ((Player)entity).m_150110_().f_35934_) {
            return;
        }
        BlockPos targetPos = pos;
        for (Map.Entry<BooleanProperty, Pair<Direction, Direction>> entry : DIRECTION_MAP.entrySet()) {
            if (!((Boolean)state.m_61143_((Property)entry.getKey())).booleanValue()) continue;
            targetPos = targetPos.m_121945_((Direction)entry.getValue().getLeft()).m_121945_((Direction)entry.getValue().getRight());
        }
        this.moveEntityTo(level, entity, targetPos);
    }

    private boolean anyProperty(BlockState state) {
        for (BooleanProperty property : PROPERTY_TABLE.values()) {
            if (!((Boolean)state.m_61143_((Property)property)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static BooleanProperty createProperty(Direction direction1, Direction direction2) {
        BooleanProperty property = BooleanProperty.m_61465_((String)(direction1.m_7912_() + "_" + direction2.m_7912_()));
        PROPERTY_TABLE.put((Object)direction1, (Object)direction2, (Object)property);
        PROPERTY_TABLE.put((Object)direction2, (Object)direction1, (Object)property);
        DIRECTION_MAP.put(property, (Pair<Direction, Direction>)Pair.of((Object)direction1, (Object)direction2));
        return property;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP_WEST, UP_NORTH, UP_EAST, UP_SOUTH, DOWN_WEST, DOWN_NORTH, DOWN_EAST, DOWN_SOUTH, NORTH_WEST, WEST_SOUTH, SOUTH_EAST, EAST_NORTH});
    }
}

