/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blockentity.GarlicDiffuserBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTiles;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GarlicDiffuserBlock
extends VampirismBlockContainer {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape shape = GarlicDiffuserBlock.makeShape();
    private final Type type;

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape b = Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        return Shapes.m_83110_((VoxelShape)a, (VoxelShape)b);
    }

    public GarlicDiffuserBlock(Type type) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.0f).m_60918_(SoundType.f_56742_).m_60955_());
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter world, @NotNull List<Component> tooltip, @NotNull TooltipFlag advanced) {
        if (this.type == Type.WEAK || this.type == Type.IMPROVED) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_7705_() + "." + this.type.getName())).m_130940_(ChatFormatting.AQUA));
        }
        tooltip.add((Component)Component.m_237115_((String)"block.vampirism.garlic_diffuser.tooltip1").m_130940_(ChatFormatting.GRAY));
        int c = VampirismConfig.BALANCE.hsGarlicDiffuserEnhancedDist == null ? 1 : 1 + 2 * (this.type == Type.IMPROVED ? (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserEnhancedDist.get() : (this.type == Type.WEAK ? (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserWeakDist.get() : (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserNormalDist.get()));
        tooltip.add((Component)Component.m_237110_((String)"block.vampirism.garlic_diffuser.tooltip2", (Object[])new Object[]{c, c}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_6256_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player playerIn) {
        GarlicDiffuserBlockEntity tile = this.getTile((BlockGetter)worldIn, pos);
        if (tile != null) {
            tile.onTouched(playerIn);
        }
    }

    @NotNull
    public String m_7705_() {
        return "block.vampirism.garlic_diffuser";
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return shape;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        GarlicDiffuserBlockEntity tile = new GarlicDiffuserBlockEntity(pos, state);
        tile.setType(this.type);
        tile.initiateBootTimer();
        return tile;
    }

    public void m_6240_(@NotNull Level worldIn, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity te, @NotNull ItemStack stack) {
        super.m_6240_(worldIn, player, pos, state, te, stack);
        if (te instanceof GarlicDiffuserBlockEntity) {
            ((GarlicDiffuserBlockEntity)te).onTouched(player);
        }
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, @NotNull Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        GarlicDiffuserBlockEntity t;
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_() && ModItems.PURIFIED_GARLIC.get() == heldItem.m_41720_()) {
            GarlicDiffuserBlockEntity t2;
            if (!world.f_46443_ && (t2 = this.getTile((BlockGetter)world, pos)) != null) {
                if (t2.getFuelTime() > 0) {
                    player.m_213846_((Component)Component.m_237115_((String)"block.vampirism.garlic_diffuser.already_fueled"));
                } else {
                    t2.onFueled();
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    player.m_213846_((Component)Component.m_237115_((String)"block.vampirism.garlic_diffuser.successfully_fueled"));
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (world.f_46443_ && (t = this.getTile((BlockGetter)world, pos)) != null) {
            VampirismMod.proxy.displayGarlicBeaconScreen(t, (Component)this.m_49954_());
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    private GarlicDiffuserBlockEntity getTile(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        BlockEntity t = world.m_7702_(pos);
        if (t instanceof GarlicDiffuserBlockEntity) {
            return (GarlicDiffuserBlockEntity)t;
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return GarlicDiffuserBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModTiles.GARLIC_DIFFUSER.get()), GarlicDiffuserBlockEntity::tick);
    }

    public static enum Type implements StringRepresentable
    {
        NORMAL("normal"),
        IMPROVED("improved"),
        WEAK("weak");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.m_7912_();
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

