/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MedChairBlock
extends VampirismHorizontalBlock {
    public static final EnumProperty<EnumPart> PART = EnumProperty.m_61587_((String)"part", EnumPart.class);
    @NotNull
    private static final VoxelShape SHAPE_TOP = MedChairBlock.m_49796_((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    @NotNull
    private static final VoxelShape SHAPE_BOTTOM = MedChairBlock.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0);
    private final VoxelShape NORTH1;
    @NotNull
    private final VoxelShape EAST1;
    @NotNull
    private final VoxelShape SOUTH1;
    @NotNull
    private final VoxelShape WEST1;
    private final VoxelShape NORTH2;
    @NotNull
    private final VoxelShape EAST2;
    @NotNull
    private final VoxelShape SOUTH2;
    @NotNull
    private final VoxelShape WEST2;

    public MedChairBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)EnumPart.BOTTOM)));
        this.NORTH1 = SHAPE_BOTTOM;
        this.EAST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.NINETY);
        this.SOUTH1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        this.NORTH2 = SHAPE_TOP;
        this.EAST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.NINETY);
        this.SOUTH2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.m_6084_()) {
            ItemStack stack = player.m_21120_(hand);
            if (this.handleInjections(player, world, stack)) {
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    player.m_150109_().m_36057_(stack);
                }
            }
        } else if (world.f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.need_item_to_use", (Object[])new Object[]{Component.m_237115_((String)new ItemStack((ItemLike)ModItems.INJECTION_GARLIC.get()).m_41778_())}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean handleGarlicInjection(@NotNull Player player, @NotNull Level world, @NotNull IFactionPlayerHandler handler, @Nullable IPlayableFaction<?> currentFaction) {
        if (handler.canJoin(VReference.HUNTER_FACTION)) {
            if (world.f_46443_) {
                VampirismMod.proxy.renderScreenFullColor(4, 30, -1145324545);
            } else {
                handler.joinFaction(VReference.HUNTER_FACTION);
                player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.POISON.get(), 200, 1));
            }
            return true;
        }
        if (currentFaction != null && !world.f_46443_) {
            player.m_213846_((Component)Component.m_237110_((String)"text.vampirism.med_chair_other_faction", (Object[])new Object[]{currentFaction.getName()}));
        }
        return false;
    }

    private boolean handleInjections(@NotNull Player player, @NotNull Level world, @NotNull ItemStack stack) {
        return FactionPlayerHandler.getOpt(player).map(handler -> {
            IPlayableFaction<?> faction = handler.getCurrentFaction();
            if (stack.m_41720_().equals(ModItems.INJECTION_GARLIC.get())) {
                return this.handleGarlicInjection(player, world, (IFactionPlayerHandler)handler, faction);
            }
            if (stack.m_41720_().equals(ModItems.INJECTION_SANGUINARE.get())) {
                return this.handleSanguinareInjection(player, (IFactionPlayerHandler)handler, faction);
            }
            return false;
        }).orElse(false);
    }

    private boolean handleSanguinareInjection(@NotNull Player player, @NotNull IFactionPlayerHandler handler, @Nullable IPlayableFaction<?> currentFaction) {
        if (VReference.VAMPIRE_FACTION.equals(currentFaction)) {
            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.already_vampire"), false);
            return false;
        }
        if (VReference.HUNTER_FACTION.equals(currentFaction)) {
            if (player.f_19853_.m_5776_()) {
                VampirismMod.proxy.displayRevertBackScreen();
            }
            return true;
        }
        if (currentFaction == null && handler.canJoin(VReference.VAMPIRE_FACTION)) {
            if (((Boolean)VampirismConfig.SERVER.disableFangInfection.get()).booleanValue()) {
                player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.deactivated_by_serveradmin"), true);
            } else {
                SanguinareEffect.addRandom((LivingEntity)player, true);
                player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.POISON.get(), 60));
                return true;
            }
        }
        return false;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.DESTROY;
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        boolean main = state.m_61143_(PART) == EnumPart.BOTTOM;
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> {
                if (main) {
                    yield this.NORTH1;
                }
                yield this.NORTH2;
            }
            case Direction.EAST -> {
                if (main) {
                    yield this.EAST1;
                }
                yield this.EAST2;
            }
            case Direction.SOUTH -> {
                if (main) {
                    yield this.SOUTH1;
                }
                yield this.SOUTH2;
            }
            case Direction.WEST -> {
                if (main) {
                    yield this.WEST1;
                }
                yield this.WEST2;
            }
            default -> this.NORTH1;
        };
    }

    @Override
    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Direction enumfacing = context.m_8125_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(enumfacing);
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)enumfacing.m_122424_()) : null;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Override
    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5707_(@NotNull Level world, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Player player) {
        BlockPos blockpos;
        BlockState otherState;
        EnumPart part;
        if (!world.f_46443_ && player.m_7500_() && (part = (EnumPart)((Object)blockState.m_61143_(PART))) == EnumPart.TOP && (otherState = world.m_8055_(blockpos = blockPos.m_121945_(this.getOtherBlockDirection(blockState)))).m_60734_() == this && otherState.m_61143_(PART) == EnumPart.BOTTOM) {
            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)otherState));
        }
        super.m_5707_(world, blockPos, blockState, player);
    }

    @Override
    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, @NotNull Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_) {
            BlockPos blockpos = pos.m_121945_(this.getOtherBlockDirection(state));
            BlockState otherState = (BlockState)state.m_61124_(PART, (Comparable)((Object)EnumPart.TOP));
            otherState = (BlockState)otherState.m_61124_((Property)FACING, (Comparable)((Direction)otherState.m_61143_((Property)FACING)));
            world.m_7731_(blockpos, otherState, 3);
            world.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == this.getOtherBlockDirection(stateIn)) {
            return facingState.m_60734_() == this && facingState.m_61143_(PART) != stateIn.m_61143_(PART) ? this.updateFromOther(stateIn, facingState) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PART});
    }

    @NotNull
    protected Direction getOtherBlockDirection(@NotNull BlockState blockState) {
        return blockState.m_61143_(PART) == EnumPart.BOTTOM ? ((Direction)blockState.m_61143_((Property)FACING)).m_122424_() : (Direction)blockState.m_61143_((Property)FACING);
    }

    protected BlockState updateFromOther(BlockState thisState, BlockState otherState) {
        return thisState;
    }

    public static enum EnumPart implements StringRepresentable
    {
        TOP("top", 0),
        BOTTOM("bottom", 1);

        public final String name;
        public final int meta;

        @NotNull
        public static EnumPart fromMeta(int meta) {
            if (meta == 1) {
                return BOTTOM;
            }
            return TOP;
        }

        private EnumPart(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return this.m_7912_();
        }
    }
}

