/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.mixin.client.BossOverlayGuiAccessor;
import de.teamlapen.vampirism.network.ClientboundUpdateMultiBossEventPacket;
import de.teamlapen.vampirism.world.MultiBossEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.jetbrains.annotations.NotNull;

public class CustomBossEventOverlay
extends GuiComponent
implements IGuiOverlay {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    @NotNull
    private final Minecraft client;
    private final Map<UUID, MultiBossEvent> bossInfoMap = new LinkedHashMap<UUID, MultiBossEvent>();

    public CustomBossEventOverlay() {
        this.client = Minecraft.m_91087_();
    }

    public void clear() {
        this.bossInfoMap.clear();
    }

    public void read(@NotNull ClientboundUpdateMultiBossEventPacket packet) {
        if (packet.operation() == ClientboundUpdateMultiBossEventPacket.OperationType.ADD) {
            this.bossInfoMap.put(packet.uniqueId(), new MultiBossEvent(packet));
        } else if (packet.operation() == ClientboundUpdateMultiBossEventPacket.OperationType.REMOVE) {
            this.bossInfoMap.remove(packet.uniqueId());
        } else {
            this.bossInfoMap.get(packet.uniqueId()).updateFromPackage(packet);
        }
    }

    public void render(ForgeGui gui, @NotNull PoseStack stack, float partialTicks, int width, int height) {
        RenderSystem.m_69453_();
        RenderSystem.m_69478_();
        int i = Minecraft.m_91087_().m_91268_().m_85445_();
        int n = ((BossOverlayGuiAccessor)this.client.f_91065_.m_93090_()).getMapBossInfos().size();
        Objects.requireNonNull(this.client.f_91062_);
        int j = 12 + n * (10 + 9);
        for (MultiBossEvent value : this.bossInfoMap.values()) {
            int k = i / 2 - 91;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BARS_TEXTURES);
            this.render(stack, k, j, value);
            Component itextcomponent = value.getName();
            int l = this.client.f_91062_.m_92852_((FormattedText)itextcomponent);
            int i1 = i / 2 - l / 2;
            int j1 = j - 9;
            this.client.f_91062_.m_92763_(stack, itextcomponent, (float)i1, (float)j1, 0xFFFFFF);
            if (j < this.client.m_91268_().m_85446_() / 3) continue;
            break;
        }
        RenderSystem.m_69461_();
    }

    private void render(@NotNull PoseStack stack, int k, int j, @NotNull MultiBossEvent value) {
        int width;
        int textureStart = 0;
        List<Color> s = value.getColors();
        Map<Color, Float> perc = value.getEntries();
        for (int i = 0; i < s.size() && textureStart < 182; textureStart += width, ++i) {
            Color color = s.get(i);
            width = (int)(perc.getOrDefault(color, Float.valueOf(0.0f)).floatValue() * 182.0f);
            if (i == s.size() - 1 && textureStart + width < 182) {
                width = 182 - textureStart;
            }
            RenderSystem.m_157429_((float)color.getRedF(), (float)color.getGreenF(), (float)color.getBlueF(), (float)color.getAlphaF());
            CustomBossEventOverlay.m_93228_((PoseStack)stack, (int)(k + textureStart), (int)j, (int)textureStart, (int)(BossEvent.BossBarColor.WHITE.ordinal() * 5 * 2 + 5), (int)width, (int)5);
        }
        if (value.getOverlay() != BossEvent.BossBarOverlay.PROGRESS) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CustomBossEventOverlay.m_93228_((PoseStack)stack, (int)k, (int)j, (int)0, (int)(80 + (value.getOverlay().ordinal() - 1) * 5 * 2), (int)182, (int)5);
        }
    }
}

