/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.gui.screens.MinionStatsScreen;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterMinionStatsScreen
extends MinionStatsScreen<HunterMinionEntity.HunterMinionData, HunterMinionEntity> {
    private final MutableComponent inventoryLevel = Component.m_237115_((String)"text.vampirism.minion.stats.inventory_level");
    private final MutableComponent healthLevel = Component.m_237115_((String)Attributes.f_22276_.m_22087_());
    private final MutableComponent strengthLevel = Component.m_237115_((String)Attributes.f_22281_.m_22087_());
    private final MutableComponent resourceLevel = Component.m_237115_((String)"text.vampirism.minion.stats.resource_level");

    public HunterMinionStatsScreen(HunterMinionEntity entity, @Nullable Screen backScreen) {
        super(entity, 4, backScreen);
    }

    @Override
    protected boolean areButtonsVisible(@NotNull HunterMinionEntity.HunterMinionData d) {
        return d.getRemainingStatPoints() > 0 || d.getLevel() < 6;
    }

    @Override
    protected int getRemainingStatPoints(@NotNull HunterMinionEntity.HunterMinionData d) {
        return d.getRemainingStatPoints();
    }

    @Override
    protected boolean isActive(@NotNull HunterMinionEntity.HunterMinionData data, int i) {
        return switch (i) {
            case 0 -> {
                if (data.getRemainingStatPoints() > 0 && data.getInventoryLevel() < 2) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (data.getRemainingStatPoints() > 0 && data.getHealthLevel() < 3) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (data.getRemainingStatPoints() > 0 && data.getStrengthLevel() < 3) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (data.getRemainingStatPoints() > 0 && data.getResourceEfficiencyLevel() < 2) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    protected void renderStats(@NotNull PoseStack mStack, @NotNull HunterMinionEntity.HunterMinionData data) {
        this.renderLevelRow(mStack, data.getLevel() + 1, 7);
        this.renderStatRow(mStack, 0, this.inventoryLevel, (Component)Component.m_237113_((String)("" + data.getInventorySize())), data.getInventoryLevel() + 1, 3);
        this.renderStatRow(mStack, 1, this.healthLevel, (Component)Component.m_237113_((String)String.format("%.1f", ((HunterMinionEntity)this.entity).m_21051_(Attributes.f_22276_).m_22115_())), data.getHealthLevel() + 1, 4);
        this.renderStatRow(mStack, 2, this.strengthLevel, (Component)Component.m_237113_((String)String.format("%.1f", ((HunterMinionEntity)this.entity).m_21051_(Attributes.f_22281_).m_22115_())), data.getStrengthLevel() + 1, 4);
        this.renderStatRow(mStack, 3, this.resourceLevel, (Component)Component.m_237113_((String)(String.format("%.1f", Math.ceil((float)(data.getResourceEfficiencyLevel() + 1) / 3.0f * 100.0f)) + "%")), data.getResourceEfficiencyLevel() + 1, 3);
    }
}

