/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.client.gui.components.SimpleList;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.inventory.MinionContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.LockIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MinionScreen
extends AbstractContainerScreen<MinionContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("vampirism", "textures/gui/minion_inventory.png");
    private final int extraSlots;
    private SimpleList<?> taskList;
    private Button taskButton;
    private Button appearanceButton;
    private Button statButton;
    private LockIconButton lockActionButton;

    public MinionScreen(@NotNull MinionContainer screenContainer, @NotNull Inventory inv, @NotNull Component titleIn) {
        super((AbstractContainerMenu)Objects.requireNonNull(screenContainer), inv, titleIn);
        this.f_97726_ = 214;
        this.f_97727_ = 185;
        this.extraSlots = screenContainer.getExtraSlots();
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        this.taskList.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        return super.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public void m_86412_(@NotNull PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(mStack);
        super.m_86412_(mStack, mouseX, mouseY, partialTicks);
        this.m_7025_(mStack, mouseX, mouseY);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.appearanceButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 6, this.f_97736_ + 21, 18, 18, 238, 0, 18, GUI_TEXTURE, this::onConfigurePressed));
        this.lockActionButton = (LockIconButton)this.m_142416_((GuiEventListener)new LockIconButton(this.f_97735_ + 99, this.f_97736_ + 19, this::toggleActionLock));
        this.statButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 6, this.f_97736_ + 40, 18, 18, 220, 0, 18, GUI_TEXTURE, this::onStatsPressed));
        this.lockActionButton.m_94309_(((MinionContainer)this.f_97732_).isTaskLocked());
        List<Component> taskNames = Arrays.stream(((MinionContainer)this.f_97732_).getAvailableTasks()).map(IMinionTask::getName).toList();
        this.taskList = (SimpleList)this.m_142416_((GuiEventListener)SimpleList.builder(this.f_97735_ + 119, this.f_97736_ + 19 + 19, 88, Math.min(54, taskNames.size() * 18) + 2).componentsWithClick(taskNames, this::selectTask).build());
        this.taskButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 119, this.f_97736_ + 19, 88, 20, this.getActiveTaskName(), button -> {
            this.taskList.isVisible = !this.taskList.isVisible;
        }));
        this.taskList.isVisible = false;
    }

    protected void m_7286_(@NotNull PoseStack mStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        MinionScreen.m_93228_((PoseStack)mStack, (int)i, (int)j, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
        for (int k = this.extraSlots; k < 15; ++k) {
            MinionScreen.m_93228_((PoseStack)mStack, (int)(i + 29 + 18 * (k / 3)), (int)(j + 44 + 18 * (k % 3)), (int)236, (int)80, (int)13, (int)13);
        }
    }

    protected void m_7027_(@NotNull PoseStack mStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(mStack, this.f_96539_, 5.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(mStack, (Component)Component.m_237115_((String)"gui.vampirism.minion.active_task"), 120.0f, 10.0f, 0x404040);
    }

    protected void m_7025_(@NotNull PoseStack mStack, int mouseX, int mouseY) {
        if (this.lockActionButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(mStack, (Component)Component.m_237115_((String)"gui.vampirism.minion.lock_action"), mouseX, mouseY);
        } else if (this.appearanceButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(mStack, (Component)Component.m_237115_((String)"gui.vampirism.minion.appearance"), mouseX, mouseY);
        } else if (this.statButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(mStack, (Component)Component.m_237115_((String)"gui.vampirism.minion_stats"), mouseX, mouseY);
        } else {
            super.m_7025_(mStack, mouseX, mouseY);
        }
    }

    private void drawButtonTip(@NotNull PoseStack mStack, Component text, int mouseX, int mouseY) {
        this.renderTooltip(mStack, Collections.singletonList(text), Optional.empty(), mouseX, mouseY, this.f_96547_);
    }

    private Component getActiveTaskName() {
        return ((MinionContainer)this.f_97732_).getSelectedTask().getName();
    }

    private void onConfigurePressed(Button b) {
        ((MinionContainer)this.f_97732_).openConfigurationScreen();
    }

    private void onStatsPressed(Button b) {
        ((MinionContainer)this.f_97732_).openStatsScreen();
    }

    private void selectTask(int id) {
        this.taskList.isVisible = false;
        ((MinionContainer)this.f_97732_).setTaskToActivate(id);
        this.taskButton.m_93666_(this.getActiveTaskName());
    }

    private void toggleActionLock(Button b) {
        this.lockActionButton.m_94309_(!this.lockActionButton.m_94302_());
        ((MinionContainer)this.f_97732_).setTaskLocked(this.lockActionButton.m_94302_());
    }
}

