/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.items.OblivionItem;
import de.teamlapen.vampirism.network.ServerboundUpgradeMinionStatPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MinionStatsScreen<T extends MinionData, Q extends MinionEntity<T>>
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/appearance.png");
    private static final ResourceLocation RESET = new ResourceLocation("vampirism", "textures/gui/reset.png");
    protected final Q entity;
    protected final int xSize = 256;
    protected final int ySize = 177;
    protected final int statCount;
    @Nullable
    protected final Screen backScreen;
    private final MutableComponent textLevel = Component.m_237115_((String)"text.vampirism.level");
    private final List<Button> statButtons = new ArrayList<Button>();
    protected int guiLeft;
    protected int guiTop;
    private Button reset;

    protected MinionStatsScreen(Q entity, int statCount, @Nullable Screen backScreen) {
        super((Component)Component.m_237115_((String)"gui.vampirism.minion_stats"));
        assert (statCount > 0);
        this.entity = entity;
        this.statCount = statCount;
        this.backScreen = backScreen;
    }

    public void m_86412_(@NotNull PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(mStack);
        this.renderGuiBackground(mStack);
        this.drawTitle(mStack);
        super.m_86412_(mStack, mouseX, mouseY, partialTicks);
        ((MinionEntity)this.entity).getMinionData().ifPresent(d -> this.renderStats(mStack, d));
    }

    public void m_86600_() {
        for (int i = 0; i < this.statCount; ++i) {
            int finalI = i;
            this.statButtons.get((int)i).f_93623_ = ((MinionEntity)this.entity).getMinionData().map(d -> this.isActive(d, finalI)).orElse(false);
            this.statButtons.get((int)i).f_93624_ = ((MinionEntity)this.entity).getMinionData().map(this::areButtonsVisible).orElse(false);
        }
        this.reset.f_93623_ = ((MinionEntity)this.entity).getMinionData().map(MinionData::hasUsedSkillPoints).orElse(false) != false && this.getOblivionPotion().isPresent();
    }

    protected abstract boolean areButtonsVisible(T var1);

    protected abstract int getRemainingStatPoints(T var1);

    protected void m_7856_() {
        this.statButtons.clear();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + this.xSize - 80 - 20, this.guiTop + 152, 80, 20, (Component)Component.m_237115_((String)"gui.done"), context -> this.m_7379_()));
        if (this.backScreen != null) {
            this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 20, this.guiTop + 152, 80, 20, (Component)Component.m_237115_((String)"gui.back"), context -> Minecraft.m_91087_().m_91152_(this.backScreen)));
        }
        for (int i = 0; i < this.statCount; ++i) {
            int finalI = i;
            Button button = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 225, this.guiTop + 43 + 26 * i, 20, 20, (Component)Component.m_237113_((String)"+"), b -> VampirismMod.dispatcher.sendToServer(new ServerboundUpgradeMinionStatPacket(this.entity.m_19879_(), finalI))));
            this.statButtons.add(button);
            button.f_93624_ = false;
        }
        this.reset = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.guiLeft + 225, this.guiTop + 8, 20, 20, 0, 0, 20, RESET, 20, 40, context -> {
            VampirismMod.dispatcher.sendToServer(new ServerboundUpgradeMinionStatPacket(this.entity.m_19879_(), -1));
            this.getOblivionPotion().ifPresent(stack -> stack.m_41774_(1));
        }, (Component)Component.m_237110_((String)"text.vampirism.minion_screen.reset_stats", (Object[])new Object[]{((OblivionItem)((Object)ModItems.OBLIVION_POTION.get())).m_41466_()})){

            public void m_86412_(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                if (this.f_93624_) {
                    boolean bl = this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
                    if (!this.f_93623_) {
                        RenderSystem.m_157429_((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                    }
                    super.m_87963_(matrixStack, mouseX, mouseY, partialTicks);
                }
            }
        });
        this.reset.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"text.vampirism.minion_screen.reset_stats")));
        this.reset.f_93623_ = false;
    }

    protected abstract boolean isActive(T var1, int var2);

    protected void renderGuiBackground(@NotNull PoseStack mStack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        MinionStatsScreen.m_93143_((PoseStack)mStack, (int)this.guiLeft, (int)this.guiTop, (int)0, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)300, (int)256);
    }

    protected void renderLevelRow(@NotNull PoseStack mStack, int current, int max) {
        this.f_96547_.m_92889_(mStack, (Component)this.textLevel, (float)(this.guiLeft + 10), (float)(this.guiTop + 30), 0);
        this.f_96547_.m_92883_(mStack, current + "/" + max, (float)(this.guiLeft + 145), (float)(this.guiTop + 30), 0x404040);
        int remainingPoints = ((MinionEntity)this.entity).getMinionData().map(this::getRemainingStatPoints).orElse(0);
        if (remainingPoints > 0) {
            this.f_96547_.m_92883_(mStack, "(" + remainingPoints + ")", (float)(this.guiLeft + 228), (float)(this.guiTop + 30), 0x404040);
        }
        MinionStatsScreen.m_93154_((PoseStack)mStack, (int)(this.guiLeft + 10), (int)(this.guiLeft + 256 - 10), (int)(this.guiTop + 40), (int)-265277392);
    }

    protected void renderStatRow(@NotNull PoseStack mStack, int i, @NotNull MutableComponent name, @NotNull Component value, int currentLevel, int maxLevel) {
        this.f_96547_.m_92889_(mStack, (Component)name.m_130946_(":"), (float)(this.guiLeft + 10), (float)(this.guiTop + 50 + 26 * i), 0x404040);
        this.f_96547_.m_92889_(mStack, value, (float)(this.guiLeft + 145), (float)(this.guiTop + 50 + 26 * i), 0x404040);
        this.f_96547_.m_92883_(mStack, UtilLib.translate("text.vampirism.level_short", new Object[0]) + ": " + currentLevel + "/" + maxLevel, (float)(this.guiLeft + 175), (float)(this.guiTop + 50 + 26 * i), 0x404040);
    }

    protected void renderStats(PoseStack mStack, T data) {
    }

    private void drawTitle(@NotNull PoseStack mStack) {
        this.f_96547_.m_92763_(mStack, this.f_96539_, (float)(this.guiLeft + 10), (float)(this.guiTop + 10), 0xFFFFFF);
    }

    @NotNull
    private Optional<ItemStack> getOblivionPotion() {
        return Optional.ofNullable(((MinionEntity)this.entity).getMinionData().flatMap(data -> Optional.ofNullable(InventoryHelper.getFirst(data.getInventory(), (Item)ModItems.OBLIVION_POTION.get()))).orElse(InventoryHelper.getFirst((Container)this.f_96541_.f_91074_.m_150109_(), (Item)ModItems.OBLIVION_POTION.get())));
    }
}

