/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.screens.ActionSelectScreen;
import de.teamlapen.vampirism.client.gui.screens.ExtendedScreen;
import de.teamlapen.vampirism.client.gui.screens.VampirePlayerAppearanceScreen;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsScreen;
import de.teamlapen.vampirism.client.gui.screens.taskboard.TaskList;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.inventory.TaskMenu;
import de.teamlapen.vampirism.inventory.VampirismMenu;
import de.teamlapen.vampirism.network.ServerboundDeleteRefinementPacket;
import de.teamlapen.vampirism.util.Helper;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampirismContainerScreen
extends AbstractContainerScreen<VampirismMenu>
implements ExtendedScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/vampirism_menu.png");
    private static final ResourceLocation BACKGROUND_REFINEMENTS = new ResourceLocation("vampirism", "textures/gui/vampirism_menu_refinements.png");
    private static final int display_width = 234;
    private static final int display_height = 205;
    private final IFactionPlayer<?> factionPlayer;
    private int oldMouseX;
    private int oldMouseY;
    private TaskList list;
    private final Map<Integer, Button> refinementRemoveButtons = new Int2ObjectOpenHashMap(3);
    private Component level;

    public VampirismContainerScreen(@NotNull VampirismMenu container, @NotNull Inventory playerInventory, @NotNull Component titleIn) {
        super((AbstractContainerMenu)container, playerInventory, titleIn);
        this.f_97726_ = 234;
        this.f_97727_ = 205;
        this.f_97730_ = 36;
        this.f_97731_ = this.f_97727_ - 93;
        ((VampirismMenu)this.f_97732_).setReloadListener(() -> this.list.updateContent());
        this.factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer(playerInventory.f_35978_).orElseThrow(() -> new IllegalStateException("Cannot open Vampirism container without faction player"));
    }

    @Override
    @NotNull
    public ItemRenderer getItemRenderer() {
        return this.f_96542_;
    }

    @Override
    @NotNull
    public TaskMenu getTaskContainer() {
        return (TaskMenu)this.f_97732_;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (ModKeys.VAMPIRISM_MENU.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        if (!this.f_97738_) {
            this.list.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void m_86412_(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        if (((VampirismMenu)this.f_97732_).areRefinementsAvailable()) {
            for (int i = 0; i < ((VampirismMenu)this.f_97732_).getRefinementStacks().size(); ++i) {
                ItemStack stack = (ItemStack)((VampirismMenu)this.f_97732_).getRefinementStacks().get(i);
                Slot slot = ((VampirismMenu)this.f_97732_).m_38853_(i);
                int x = slot.f_40220_ + this.f_97735_;
                int y = slot.f_40221_ + this.f_97736_;
                this.f_96542_.m_274369_(matrixStack, stack, x, y);
                this.f_96542_.m_274364_(matrixStack, this.f_96547_, stack, x, y, null);
            }
        }
        this.renderAccessorySlots(matrixStack, mouseX, mouseY, partialTicks);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
        this.m_7025_(matrixStack, mouseX, mouseY);
        if (((VampirismMenu)this.f_97732_).areRefinementsAvailable()) {
            this.renderHoveredRefinementTooltip(matrixStack, mouseX, mouseY);
        }
    }

    protected void renderAccessorySlots(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (Slot slot : ((VampirismMenu)this.f_97732_).f_38839_) {
            if (!this.m_97774_(slot, mouseX, mouseY) || !(slot instanceof VampirismMenu.RemovingSelectorSlot) || ((ItemStack)((VampirismMenu)this.f_97732_).getRefinementStacks().get(slot.getSlotIndex())).m_41619_()) continue;
            this.refinementRemoveButtons.get(slot.getSlotIndex()).m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        super.m_6574_(pMinecraft, pWidth, pHeight);
        this.list.updateContent();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.level = this.factionPlayer.getLevel() > 0 ? FactionPlayerHandler.getOpt(this.factionPlayer.getRepresentingPlayer()).filter(f -> f.getLordLevel() > 0).map(f -> f.getLordTitle().m_6881_().m_130946_(" (" + f.getLordLevel() + ")")).orElseGet(() -> Component.m_237115_((String)"text.vampirism.level").m_130946_(" " + this.factionPlayer.getLevel())).m_130938_(style -> style.m_131148_(this.factionPlayer.getFaction().getChatColor())) : Component.m_237119_();
        this.list = (TaskList)this.m_142416_((GuiEventListener)new TaskList(Minecraft.m_91087_(), (TaskMenu)this.f_97732_, this.factionPlayer, this.f_97735_ + 83, this.f_97736_ + 7, 144, 104, 21, () -> new ArrayList<ITaskInstance>(((VampirismMenu)this.f_97732_).getTaskInfos())));
        ImageButton button1 = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 5, this.f_97736_ + 90, 20, 20, 40, 205, 20, BACKGROUND, 256, 256, context -> {
            if (this.f_96541_.f_91074_.m_6084_() && VampirismPlayerAttributes.get((Player)this.f_96541_.f_91074_).faction != null) {
                Minecraft.m_91087_().m_91152_((Screen)new SkillsScreen(FactionPlayerHandler.getCurrentFactionPlayer((Player)this.f_96541_.f_91074_).orElse(null), (Screen)this));
            }
        }, (Component)Component.m_237119_()));
        button1.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.vampirism.vampirism_menu.skill_screen")));
        ImageButton button2 = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 26, this.f_97736_ + 90, 20, 20, 0, 205, 20, BACKGROUND, 256, 256, context -> {
            IPlayableFaction<?> factionNew = VampirismPlayerAttributes.get((Player)this.f_96541_.f_91074_).faction;
            Minecraft.m_91087_().m_91152_(new ActionSelectScreen(new Color(factionNew.getColor()), true));
        }, (Component)Component.m_237119_()));
        button2.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.vampirism.vampirism_menu.edit_actions")));
        Button appearanceButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 47, this.f_97736_ + 90, 20, 20, 20, 205, 20, BACKGROUND, 256, 256, context -> Minecraft.m_91087_().m_91152_((Screen)new VampirePlayerAppearanceScreen((Screen)this)), (Component)Component.m_237119_()));
        appearanceButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.vampirism.vampirism_menu.appearance_menu")));
        if (!Helper.isVampire((Player)this.f_96541_.f_91074_)) {
            appearanceButton.f_93623_ = false;
            appearanceButton.f_93624_ = false;
        }
        final NonNullList<ItemStack> refinementList = ((VampirismMenu)this.f_97732_).getRefinementStacks();
        for (final Slot slot : ((VampirismMenu)this.f_97732_).f_38839_) {
            if (!(slot instanceof VampirismMenu.RemovingSelectorSlot)) continue;
            Button xButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.getGuiLeft() + slot.f_40220_ + 16 - 5, this.getGuiTop() + slot.f_40221_ + 16 - 5, 5, 5, 60, 205, 0, BACKGROUND_REFINEMENTS, 256, 256, button -> {
                VampirismMod.dispatcher.sendToServer(new ServerboundDeleteRefinementPacket(IRefinementItem.AccessorySlotType.values()[slot.f_40219_]));
                refinementList.set(slot.f_40219_, (Object)ItemStack.f_41583_);
            }, (Component)Component.m_237119_()){

                public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.f_93624_ = !((ItemStack)refinementList.get(slot.f_40219_)).m_41619_() && VampirismContainerScreen.this.f_97711_.m_41619_() && this.overSlot(slot, mouseX, mouseY);
                    super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
                }

                private boolean overSlot(@NotNull Slot slot2, int mouseX, int mouseY) {
                    return slot2.f_40220_ <= (mouseX -= VampirismContainerScreen.this.f_97735_) && slot2.f_40220_ + 16 > mouseX && slot2.f_40221_ <= (mouseY -= VampirismContainerScreen.this.f_97736_) && slot2.f_40221_ + 16 > mouseY;
                }
            });
            xButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.vampirism.vampirism_menu.destroy_item").m_130940_(ChatFormatting.RED)));
            this.refinementRemoveButtons.put(slot.getSlotIndex(), xButton);
        }
    }

    protected void m_7027_(@NotNull PoseStack stack, int mouseX, int mouseY) {
        super.m_7027_(stack, mouseX, mouseY);
        int width = this.f_96547_.m_92852_((FormattedText)this.level);
        this.f_96547_.m_92889_(stack, this.level, Math.max(5.0f, 31.0f - (float)width / 2.0f), 81.0f, -1);
    }

    protected void m_7286_(@NotNull PoseStack matrixStack, float v, int i, int i1) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)(((VampirismMenu)this.f_97732_).areRefinementsAvailable() ? BACKGROUND_REFINEMENTS : BACKGROUND));
        VampirismContainerScreen.m_93228_((PoseStack)matrixStack, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
        InventoryScreen.m_274545_((PoseStack)matrixStack, (int)(this.f_97735_ + 31), (int)(this.f_97736_ + 72), (int)30, (float)((float)(this.f_97735_ + 10) - (float)this.oldMouseX), (float)((float)(this.f_97736_ + 75 - 50) - (float)this.oldMouseY), (LivingEntity)this.f_96541_.f_91074_);
    }

    protected void renderHoveredRefinementTooltip(@NotNull PoseStack matrixStack, int mouseX, int mouseY) {
        NonNullList<ItemStack> list;
        int index;
        if (this.f_97734_ != null && (index = this.f_97734_.f_40219_) < (list = ((VampirismMenu)this.f_97732_).getRefinementStacks()).size() && index >= 0) {
            if (((VampirismMenu)this.m_6262_()).m_142621_().m_41619_() && !((ItemStack)list.get(index)).m_41619_()) {
                if (!this.refinementRemoveButtons.get(this.f_97734_.getSlotIndex()).m_198029_()) {
                    this.m_6057_(matrixStack, (ItemStack)list.get(index), mouseX, mouseY);
                }
            } else if (!((ItemStack)list.get(index)).m_41619_() && ((VampirismMenu)this.f_97732_).m_38853_(index).m_5857_(((VampirismMenu)this.m_6262_()).m_142621_())) {
                this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"gui.vampirism.vampirism_menu.destroy_item").m_130940_(ChatFormatting.RED), mouseX, mouseY);
            }
        }
    }

    private static class TaskList
    extends de.teamlapen.vampirism.client.gui.screens.taskboard.TaskList {
        public TaskList(Minecraft minecraft, TaskMenu menu, IFactionPlayer<?> factionPlayer, int x, int y, int width, int height, int itemHeight, Supplier<List<ITaskInstance>> itemSupplier) {
            super(minecraft, menu, factionPlayer, x, y, width, height, itemHeight, itemSupplier);
        }

        @Override
        protected TaskEntry createItem(ITaskInstance item) {
            return new TaskEntry(item);
        }

        public void m_86412_(@NotNull PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_86412_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            if (this.m_6702_().isEmpty()) {
                TaskList.m_93215_((PoseStack)pPoseStack, (Font)this.f_93386_.f_91062_, (Component)Component.m_237115_((String)"gui.vampirism.vampirism_menu.no_tasks"), (int)(this.f_93393_ + this.f_93388_ / 2), (int)(this.f_93390_ + this.f_93389_ / 2), (int)0x404040);
            }
        }

        private class TaskEntry
        extends TaskList.TaskEntry {
            @Nullable
            private ImageButton button;

            public TaskEntry(ITaskInstance taskInstance) {
                super(taskInstance);
                if (!taskInstance.isUnique()) {
                    this.button = new ImageButton(0, 0, 8, 11, 0, 229, 11, TASKMASTER_GUI_TEXTURE, 256, 256, this::clickLocator, (Component)Component.m_237119_());
                    this.button.m_257544_(Tooltip.m_257550_((Component)this.createTooltip()));
                }
            }

            @Override
            public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
                if (this.button != null && this.button.m_6375_(mouseX, mouseY, mouseButton)) {
                    return true;
                }
                return super.m_6375_(mouseX, mouseY, mouseButton);
            }

            @Override
            protected void renderToolTips(Minecraft minecraft, int mouseX, int mouseY) {
                if (this.button != null && !this.button.m_5953_((double)mouseX, (double)mouseY)) {
                    super.renderToolTips(minecraft, mouseX, mouseY);
                }
            }

            private void clickLocator(Button button) {
                Player player = TaskList.this.factionPlayer.getRepresentingPlayer();
                Component position = (Component)((VampirismMenu)((TaskList)TaskList.this).menu).taskWrapper.get(((ITaskInstance)this.getItem()).getTaskBoard()).getLastSeenPos().map(pos -> {
                    int i = Mth.m_14143_((float)UtilLib.horizontalDistance(player.m_20183_(), pos));
                    MutableComponent itextcomponent = ComponentUtils.m_130748_((Component)Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{pos.m_123341_(), "~", pos.m_123343_()})).m_130938_(p_241055_1_ -> p_241055_1_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.m_123341_() + " ~ " + pos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
                    return itextcomponent.m_7220_((Component)Component.m_237110_((String)"gui.vampirism.vampirism_menu.distance", (Object[])new Object[]{i}));
                }).orElseGet(() -> Component.m_237115_((String)"gui.vampirism.vampirism_menu.last_known_pos.unknown").m_130940_(ChatFormatting.GOLD));
                player.m_5661_((Component)Component.m_237115_((String)"gui.vampirism.vampirism_menu.last_known_pos").m_7220_(position), false);
            }

            private Component createTooltip() {
                Component position = (Component)((VampirismMenu)((TaskList)TaskList.this).menu).taskWrapper.get(((ITaskInstance)this.getItem()).getTaskBoard()).getLastSeenPos().map(pos -> Component.m_237113_((String)("[" + pos.m_123344_() + "]")).m_130940_(ChatFormatting.GREEN)).orElseGet(() -> Component.m_237115_((String)"gui.vampirism.vampirism_menu.last_known_pos.unknown").m_130940_(ChatFormatting.GOLD));
                return Component.m_237115_((String)"gui.vampirism.vampirism_menu.last_known_pos").m_7220_(position);
            }

            @Override
            public void m_6311_(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                super.m_6311_(pPoseStack, pIndex, pTop, pLeft, pWidth, pHeight, pMouseX, pMouseY, pIsMouseOver, pPartialTick);
                if (this.button != null) {
                    this.button.m_264152_(pLeft + pWidth - this.button.m_5711_() - 1, pTop + 1);
                    this.button.m_86412_(pPoseStack, pMouseX, pMouseY, pPartialTick);
                }
            }
        }
    }
}

