/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.skills;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsScreen;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsTabScreen;
import de.teamlapen.vampirism.entity.player.skills.ActionSkill;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.entity.player.skills.SkillTree;
import de.teamlapen.vampirism.entity.player.skills.SkillTreeManager;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.gui.ScreenUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class SkillNodeScreen
extends GuiComponent {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("vampirism", "textures/gui/skills/widgets.png");
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    private final Minecraft minecraft;
    private final SkillsTabScreen tab;
    private final SkillsScreen screen;
    private final SkillNode skillNode;
    private final SkillHandler<?> skillHandler;
    private final List<SkillNodeScreen> children = new ArrayList<SkillNodeScreen>();
    @Nullable
    private final SkillNodeScreen parent;
    private final int x;
    private final int y;
    private final FormattedCharSequence[] titles;
    private final List<FormattedCharSequence>[] descriptions;
    private final int[] width;

    public SkillNodeScreen(@NotNull Minecraft minecraft, @NotNull SkillsScreen screen, @NotNull SkillsTabScreen tab, @NotNull SkillNode skillNode, @NotNull SkillHandler<?> skillHandler) {
        this(minecraft, screen, tab, skillNode, skillHandler, null, 0, 0);
    }

    public SkillNodeScreen(@NotNull Minecraft minecraft, @NotNull SkillsScreen screen, @NotNull SkillsTabScreen tab, @NotNull SkillNode skillNode, @NotNull SkillHandler<?> skillHandler, @Nullable SkillNodeScreen parent, int x, int y) {
        int i;
        this.minecraft = minecraft;
        this.tab = tab;
        this.screen = screen;
        this.skillNode = skillNode;
        this.skillHandler = skillHandler;
        this.parent = parent;
        this.x = x;
        this.y = y;
        int w = SkillTree.getTreeWidth(skillNode);
        int childrenCount = this.skillNode.getChildren().size();
        if (childrenCount > 0) {
            int pos = x;
            if (--childrenCount > 0) {
                pos -= w / 2 - 13;
            }
            for (i = 0; i < skillNode.getChildren().size(); ++i) {
                SkillNode current = skillNode.getChildren().get(i);
                this.children.add(new SkillNodeScreen(minecraft, screen, tab, current, skillHandler, this, pos, y + 60));
                pos += SkillTree.getTreeWidth(current) / 2 + 30;
                if (skillNode.getChildren().size() < i + 2) continue;
                SkillNode next = skillNode.getChildren().get(i + 1);
                pos += SkillTree.getTreeWidth(next) / 2;
            }
        }
        this.titles = new FormattedCharSequence[skillNode.getElements().length];
        this.descriptions = new List[skillNode.getElements().length];
        this.width = new int[skillNode.getElements().length];
        int l = 56;
        for (i = 0; i < skillNode.getElements().length; ++i) {
            this.titles[i] = Language.m_128107_().m_5536_(minecraft.f_91062_.m_92854_((FormattedText)skillNode.getElements()[i].getName(), 163));
            int size = Math.max(l + minecraft.f_91062_.m_92724_(this.titles[i]), 120);
            this.descriptions[i] = Language.m_128107_().m_128112_(this.findOptimalLines((Component)ComponentUtils.m_130750_((MutableComponent)Optional.ofNullable(skillNode.getElements()[i].getDescription()).orElse((Component)Component.m_237119_()).m_6881_(), (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY)), size - 30));
            this.width[i] = size;
        }
    }

    private static float getMaxWidth(@NotNull StringSplitter p_238693_0_, @NotNull List<FormattedText> p_238693_1_) {
        return (float)p_238693_1_.stream().mapToDouble(arg_0 -> ((StringSplitter)p_238693_0_).m_92384_(arg_0)).max().orElse(0.0);
    }

    private SkillNodeState getState() {
        block6: {
            block5: {
                if (Arrays.stream(this.skillNode.getElements()).anyMatch(this.skillHandler::isSkillEnabled)) {
                    return SkillNodeState.UNLOCKED;
                }
                if (this.skillHandler.isSkillNodeLocked(this.skillNode)) {
                    return SkillNodeState.LOCKED;
                }
                if (this.skillNode.getParent() == null) break block5;
                if (!Arrays.stream(this.skillNode.getParent().getElements()).anyMatch(this.skillHandler::isSkillEnabled)) break block6;
            }
            return SkillNodeState.AVAILABLE;
        }
        return this.skillNode.isHidden() ? SkillNodeState.HIDDEN : SkillNodeState.VISIBLE;
    }

    private Collection<ISkill> getLockingSkills(@NotNull SkillNode node) {
        return Arrays.stream(node.getLockingNodes()).map(id -> SkillTreeManager.getInstance().getSkillTree().getNodeFromId((ResourceLocation)id)).filter(Objects::nonNull).flatMap(node2 -> Arrays.stream(node2.getElements())).filter(this.skillHandler::isSkillEnabled).collect(Collectors.toList());
    }

    public List<SkillNodeScreen> getChildren() {
        return this.children;
    }

    public SkillNode getSkillNode() {
        return this.skillNode;
    }

    public void draw(@NotNull PoseStack stack, int i, int j) {
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.0f, 50.0f);
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        int width = this.getNodeWidth();
        stack.m_85836_();
        stack.m_252880_((float)(-width) / 2.0f, 0.0f, 0.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
        int x = this.getNodeStart();
        if (this.skillNode.getElements().length > 1) {
            ScreenUtils.blitWithBorder((PoseStack)stack, (int)x, (int)this.y, (int)200, (int)0, (int)width, (int)26, (int)26, (int)26, (int)3, (float)0.0f);
        }
        for (int i1 = 0; i1 < this.skillNode.getElements().length; ++i1) {
            if (state == SkillNodeState.LOCKED || !this.skillHandler.isSkillEnabled(this.skillNode.getElements()[i1])) {
                RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
            SkillNodeScreen.m_93228_((PoseStack)stack, (int)x, (int)this.y, (int)(this.skillNode.isRoot() ? 226 : 200), (int)0, (int)26, (int)26);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillIconLocation(this.skillNode.getElements()[i1]));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            UtilLib.drawTexturedModalRect(stack.m_85850_().m_252922_(), 0.0f, x + 5, this.y + 5, 0, 0, 16, 16, 16, 16);
            x += 36;
        }
        stack.m_85849_();
        for (SkillNodeScreen child : this.children) {
            child.draw(stack, i, j);
        }
        stack.m_85849_();
    }

    public void drawConnectivity(@NotNull PoseStack stack, int startX, int startY, boolean outerLine) {
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        if (this.parent != null) {
            int color = state.pathColor(outerLine);
            stack.m_85836_();
            if (state == SkillNodeState.UNLOCKED) {
                stack.m_252880_(0.0f, 0.0f, 10.0f);
            }
            int i = startX + this.x;
            int i1 = startX + this.parent.x;
            int j = startY + this.y - 30;
            int j2 = startY + this.parent.y + 13;
            int j3 = startY + this.y - 29;
            int j4 = startY + this.parent.y + 13 + 16;
            int i2 = startX + this.x;
            int j5 = startY + this.y;
            int i3 = startX + this.parent.x;
            if (outerLine) {
                SkillNodeScreen.m_93154_((PoseStack)stack, (int)i, (int)i1, (int)(j - 1), (int)color);
                SkillNodeScreen.m_93154_((PoseStack)stack, (int)i, (int)i1, (int)(j + 1), (int)color);
                SkillNodeScreen.m_93222_((PoseStack)stack, (int)(i1 - 1), (int)j2, (int)j3, (int)color);
                SkillNodeScreen.m_93222_((PoseStack)stack, (int)(i3 + 1), (int)j2, (int)j3, (int)color);
                SkillNodeScreen.m_93222_((PoseStack)stack, (int)(i - 1), (int)j4, (int)(j5 + 1), (int)color);
                SkillNodeScreen.m_93222_((PoseStack)stack, (int)(i2 + 1), (int)j4, (int)(j5 + 1), (int)color);
            } else {
                SkillNodeScreen.m_93154_((PoseStack)stack, (int)i, (int)i1, (int)j, (int)color);
                SkillNodeScreen.m_93222_((PoseStack)stack, (int)i1, (int)j2, (int)j3, (int)color);
                SkillNodeScreen.m_93222_((PoseStack)stack, (int)i, (int)j4, (int)(j5 + 1), (int)color);
            }
            stack.m_85849_();
        }
        for (SkillNodeScreen child : this.children) {
            child.drawConnectivity(stack, startX, startY, outerLine);
        }
    }

    private int getNodeWidth() {
        return 26 * this.skillNode.getElements().length + (this.skillNode.getElements().length - 1) * 10;
    }

    public void drawHover(@NotNull PoseStack stack, double mouseX, double mouseY, float fade, int scrollX, int scrollY) {
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
        ISkill<?>[] elements = this.skillNode.getElements();
        scrollX = (int)((float)scrollX - (float)this.getNodeWidth() / 2.0f);
        int hoveredSkill = -1;
        for (int i = 0; i < elements.length; ++i) {
            if (!this.isMouseOverSkill(i, mouseX, mouseY, scrollX, scrollY)) continue;
            hoveredSkill = i;
            break;
        }
        if (hoveredSkill != -1) {
            int x = this.getNodeStart() + 36 * hoveredSkill;
            Collection<ISkill> lockingSkills = this.getLockingSkills(this.skillNode);
            if (state == SkillNodeState.LOCKED || state == SkillNodeState.VISIBLE) {
                ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
                if (state == SkillNodeState.VISIBLE) {
                    MutableComponent t1 = Component.m_237115_((String)"text.vampirism.skill.unlock_parent_first").m_130940_(ChatFormatting.DARK_RED);
                    text.add(t1);
                } else {
                    text.add(Component.m_237115_((String)"text.vampirism.skill.locked"));
                    lockingSkills.stream().map(a -> a.getName().m_6881_().m_130940_(ChatFormatting.DARK_RED)).forEach(text::add);
                }
                int width = text.stream().mapToInt(arg_0 -> ((Font)this.minecraft.f_91062_).m_92852_(arg_0)).max().getAsInt();
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
                ScreenUtils.blitWithBorder((PoseStack)stack, (int)(scrollX + x - 3), (int)(scrollY + this.y - 3 - text.size() * 9), (int)0, (int)81, (int)(width + 8), (int)(10 + text.size() * 10), (int)200, (int)20, (int)3, (float)0.0f);
                int fontY = scrollY + this.y + 1 - text.size() * 9;
                for (int i = 0; i < text.size(); ++i) {
                    this.minecraft.f_91062_.m_92763_(stack, (Component)text.get(i), (float)(scrollX + x + 2), (float)(fontY + i * 9), -1);
                }
            }
            List<FormattedCharSequence> description = this.descriptions[hoveredSkill];
            if (!lockingSkills.isEmpty()) {
                ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
                text.add(Component.m_237115_((String)"text.vampirism.skill.excluding"));
                lockingSkills.stream().map(a -> a.getName().m_6881_().m_130940_(ChatFormatting.YELLOW)).forEach(text::add);
                int width = Math.min(this.width[hoveredSkill], text.stream().mapToInt(arg_0 -> ((Font)this.minecraft.f_91062_).m_92852_(arg_0)).max().getAsInt());
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
                int yOffset = description.isEmpty() ? 15 : 24;
                ScreenUtils.blitWithBorder((PoseStack)stack, (int)(scrollX + x - 3), (int)(scrollY + this.y + 3 + 7 + description.size() * 9), (int)0, (int)81, (int)(width + 8), (int)(text.size() * 10 + yOffset), (int)200, (int)20, (int)3, (float)0.0f);
                int fontY = scrollY + this.y + 3 + yOffset + 8 + description.size() * 9;
                for (int i = 0; i < text.size(); ++i) {
                    this.minecraft.f_91062_.m_92763_(stack, (Component)text.get(i), (float)(scrollX + x + 2), (float)(fontY + i * 9), -1);
                }
            }
            if (!description.isEmpty()) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
                ScreenUtils.blitWithBorder((PoseStack)stack, (int)(scrollX + x - 5), (int)(scrollY + this.y + 3), (int)0, (int)81, (int)this.width[hoveredSkill], (int)(30 + description.size() * 9), (int)200, (int)20, (int)3, (float)0.0f);
                for (int i = 0; i < description.size(); ++i) {
                    this.minecraft.f_91062_.m_92744_(stack, description.get(i), (float)(scrollX + x + 2), (float)(scrollY + this.y + 3 + 24 + i * 9), -1);
                }
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
            int wid = this.width[hoveredSkill] / 2;
            int titleTextureY = state.titleTextureY;
            if (state == SkillNodeState.UNLOCKED && !this.skillHandler.isSkillEnabled(elements[hoveredSkill])) {
                titleTextureY = SkillNodeState.LOCKED.titleTextureY;
            }
            SkillNodeScreen.m_93228_((PoseStack)stack, (int)(scrollX + x - 5), (int)(scrollY + this.y + 3), (int)0, (int)titleTextureY, (int)wid, (int)22);
            SkillNodeScreen.m_93228_((PoseStack)stack, (int)(scrollX + x - 5 + wid), (int)(scrollY + this.y + 3), (int)(200 - wid), (int)titleTextureY, (int)wid, (int)22);
            this.minecraft.f_91062_.m_92744_(stack, this.titles[hoveredSkill], (float)(scrollX + x + 40), (float)(scrollY + this.y + 9), -1);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
            SkillNodeScreen.m_93228_((PoseStack)stack, (int)(scrollX + x), (int)(scrollY + this.y), (int)(this.skillNode.isRoot() ? 226 : 200), (int)0, (int)26, (int)26);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillIconLocation(elements[hoveredSkill]));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            UtilLib.drawTexturedModalRect(stack.m_85850_().m_252922_(), 0.0f, x + scrollX + 5, this.y + scrollY + 5, 0, 0, 16, 16, 16, 16);
        }
    }

    private List<FormattedCharSequence> getSkillDescription(int skill) {
        List<FormattedCharSequence> description = this.descriptions[skill];
        ISkillHandler.Result result = this.skillHandler.canSkillBeEnabled(this.skillNode.getElements()[skill]);
        List<ISkill<?>> lockingSkills = null;
        ChatFormatting lockingColor = ChatFormatting.BLACK;
        if (this.skillNode.getLockingNodes().length != 0) {
            lockingSkills = this.skillHandler.getLockingSkills(this.skillNode);
            ChatFormatting chatFormatting = result == ISkillHandler.Result.ALREADY_ENABLED ? ChatFormatting.DARK_GRAY : (lockingColor = lockingSkills.stream().anyMatch(this.skillHandler::isSkillEnabled) ? ChatFormatting.DARK_RED : ChatFormatting.YELLOW);
        }
        if (lockingSkills != null) {
            int l = 56;
            int size = Math.max(l + this.minecraft.f_91062_.m_92724_(this.titles[skill]), 120) - 20;
            description = new ArrayList<FormattedCharSequence>(description);
            description.addAll(Language.m_128107_().m_128112_(this.findOptimalLines((Component)Component.m_237115_((String)"text.vampirism.skill.excluding").m_130940_(lockingColor), size)));
            for (ISkill<?> lockingSkill : lockingSkills) {
                description.addAll(Language.m_128107_().m_128112_(this.findOptimalLines((Component)Component.m_237113_((String)"  ").m_7220_((Component)lockingSkill.getName().m_6881_().m_130940_(lockingColor)), size)));
            }
        }
        return description;
    }

    private ResourceLocation getSkillIconLocation(@NotNull ISkill skill) {
        if (skill instanceof ActionSkill) {
            return new ResourceLocation(((ActionSkill)skill).getActionID().m_135827_(), "textures/actions/" + ((ActionSkill)skill).getActionID().m_135815_() + ".png");
        }
        ResourceLocation id = RegUtil.id(skill);
        return new ResourceLocation(id.m_135827_(), "textures/skills/" + id.m_135815_() + ".png");
    }

    public boolean isMouseOver(double mouseX, double mouseY, int scrollX, int scrollY) {
        double width = this.getNodeWidth();
        return mouseX >= (double)(this.x + scrollX) - width / 2.0 && mouseX < (double)(this.x + scrollX) + width / 2.0 - 1.0 && mouseY > (double)(scrollY + this.y) && mouseY < (double)(scrollY + this.y + 26);
    }

    public boolean isMouseOverSkill(int index, double mouseX, double mouseY, int guiLeft, int guiTop) {
        int x = this.x + 36 * index;
        return mouseX > (double)(x + guiLeft) && mouseX < (double)(x + guiLeft + 26) && mouseY > (double)(guiTop + this.y) && mouseY < (double)(guiTop + this.y + 26);
    }

    @Nullable
    public ISkill getSelectedSkill(double mouseX, double mouseY, int scrollX, int scrollY) {
        if (!this.isMouseOver(mouseX, mouseY, scrollX, scrollY)) {
            return null;
        }
        int nodeWidth = this.getNodeWidth();
        for (int i = 0; i < this.skillNode.getElements().length; ++i) {
            if (!this.isMouseOverSkill(i, mouseX, mouseY, (int)((float)scrollX - (float)nodeWidth / 2.0f), scrollY)) continue;
            return this.skillNode.getElements()[i];
        }
        return null;
    }

    private int getNodeStart() {
        int x = this.x;
        return x;
    }

    private List<FormattedText> findOptimalLines(@NotNull Component p_238694_1_, int p_238694_2_) {
        StringSplitter charactermanager = this.minecraft.f_91062_.m_92865_();
        List list = Collections.emptyList();
        float f = Float.MAX_VALUE;
        for (int i : TEST_SPLIT_OFFSETS) {
            List list1 = charactermanager.m_92414_((FormattedText)p_238694_1_, p_238694_2_ - i, Style.f_131099_);
            float f1 = Math.abs(SkillNodeScreen.getMaxWidth(charactermanager, list1) - (float)p_238694_2_);
            if (f1 <= 10.0f) {
                return list1;
            }
            if (!(f1 < f)) continue;
            f = f1;
            list = list1;
        }
        return list;
    }

    static enum SkillNodeState {
        AVAILABLE(3, -5789785, -1),
        HIDDEN(0, 0, 0),
        LOCKED(55, -3211264, -9830400),
        UNLOCKED(29, -16742639, -16755964),
        VISIBLE(3, -14540254, -12632257);

        public final int titleTextureY;
        public final int innerColor;
        public final int outerColor;

        private SkillNodeState(int titleTextureY, int innerColor, int outerColor) {
            this.titleTextureY = titleTextureY;
            this.outerColor = outerColor;
            this.innerColor = innerColor;
        }

        int pathColor(boolean outer) {
            return outer ? this.outerColor : this.innerColor;
        }
    }
}

