/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.skills;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillNodeScreen;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsScreen;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.entity.player.skills.SkillTree;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.advancements.AdvancementTabType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.ScreenUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class SkillsTabScreen
extends GuiComponent {
    public static final int SCREEN_WIDTH = 234;
    public static final int SCREEN_HEIGHT = 172;
    private final Minecraft minecraft;
    private final SkillsScreen screen;
    private final ISkillHandler<?> skillHandler;
    private final ItemStack icon;
    private final Component title;
    private final Map<SkillNode, SkillNodeScreen> nodes = new HashMap<SkillNode, SkillNodeScreen>();
    private final AdvancementTabType position;
    private final SkillNodeScreen root;
    private final int treeWidth;
    private final int treeHeight;
    private final ResourceLocation background;
    private double scrollX;
    private double scrollY;
    private int minX = Integer.MIN_VALUE;
    private int minY = Integer.MIN_VALUE;
    private int maxX = Integer.MAX_VALUE;
    private int maxY = Integer.MAX_VALUE;
    private float zoom = 1.0f;
    private final int index;
    private float fade;

    public SkillsTabScreen(@NotNull Minecraft minecraft, @NotNull SkillsScreen screen, int index, @NotNull ItemStack icon, @NotNull SkillNode rootNode, @NotNull ISkillHandler<?> skillHandler, @NotNull Component title) {
        this.minecraft = minecraft;
        this.screen = screen;
        this.skillHandler = skillHandler;
        this.index = index;
        this.icon = icon;
        this.title = title;
        this.position = AdvancementTabType.LEFT;
        this.root = new SkillNodeScreen(minecraft, screen, this, rootNode, (SkillHandler)skillHandler);
        this.treeWidth = SkillTree.getTreeWidth(rootNode);
        this.treeHeight = SkillTree.getTreeHeight(rootNode);
        this.background = new ResourceLocation("vampirism", "textures/gui/skills/backgrounds/level.png");
        this.addNode(this.root);
        this.recalculateBorders();
        this.scrollX = 0.0;
        this.scrollY = 20.0;
    }

    private void recalculateBorders() {
        this.minY = (int)(-((float)this.treeHeight * this.zoom));
        this.maxY = (int)(20.0f * this.zoom);
        this.minX = (int)((float)(-this.treeWidth / 2) * this.zoom);
        this.maxX = (int)((float)(this.treeWidth / 2) * this.zoom);
        this.center();
    }

    private void addNode(@NotNull SkillNodeScreen screen) {
        this.nodes.put(screen.getSkillNode(), screen);
        for (SkillNodeScreen child : screen.getChildren()) {
            this.addNode(child);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void drawTab(@NotNull PoseStack stack, int x, int y, boolean selected) {
        this.position.m_274557_(stack, x, y, selected, this.index);
    }

    public void drawIcon(PoseStack stack, int x, int y, ItemRenderer itemRenderer) {
        this.position.m_274598_(stack, x, y, this.index, itemRenderer, this.icon);
    }

    public boolean isMouseOver(int guiLeft, int guiTop, double mouseX, double mouseY) {
        return this.position.m_97213_(guiLeft, guiTop, this.index, mouseX, mouseY);
    }

    public void drawContents(@NotNull PoseStack stack) {
        stack.m_85836_();
        RenderSystem.m_69482_();
        stack.m_252880_(0.0f, 0.0f, 950.0f);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        SkillsTabScreen.m_93172_((PoseStack)stack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        stack.m_252880_(0.0f, 0.0f, -950.0f);
        RenderSystem.m_69456_((int)518);
        SkillsTabScreen.m_93172_((PoseStack)stack, (int)234, (int)172, (int)0, (int)0, (int)-16777216);
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.background);
        int i = this.getX();
        int j = this.getY();
        int k = i % 16;
        int l = j % 16;
        stack.m_85841_(this.zoom, this.zoom, 1.0f);
        int i1 = -1;
        while ((float)i1 <= 15.0f / this.zoom) {
            int j1 = -1;
            while ((float)j1 <= 12.0f / this.zoom) {
                SkillsTabScreen.m_93133_((PoseStack)stack, (int)(k + 16 * i1), (int)(l + 16 * j1), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                ++j1;
            }
            ++i1;
        }
        stack.m_85836_();
        stack.m_252880_((float)i, (float)j, 0.0f);
        this.root.drawConnectivity(stack, 0, 0, true);
        this.root.drawConnectivity(stack, 0, 0, false);
        this.root.draw(stack, 0, 0);
        stack.m_85849_();
        RenderSystem.m_69456_((int)518);
        stack.m_252880_(0.0f, 0.0f, -950.0f);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        SkillsTabScreen.m_93172_((PoseStack)stack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        stack.m_252880_(0.0f, 0.0f, 950.0f);
        RenderSystem.m_69456_((int)515);
        stack.m_85849_();
        if (this.minecraft.f_91074_.m_21124_((MobEffect)ModEffects.OBLIVION.get()) != null) {
            stack.m_85836_();
            RenderSystem.m_69482_();
            stack.m_252880_(0.0f, 0.0f, 200.0f);
            SkillsTabScreen.m_93172_((PoseStack)stack, (int)0, (int)0, (int)234, (int)172, (int)(Mth.m_14107_((double)127.5) << 24));
            RenderSystem.m_69465_();
            stack.m_85849_();
            stack.m_85836_();
            stack.m_252880_(0.0f, 0.0f, 200.0f);
            this.drawDisableText(stack);
            stack.m_85849_();
        }
    }

    public void drawTooltips(@NotNull PoseStack stack, int mouseX, int mouseY) {
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.0f, 200.0f);
        SkillsTabScreen.m_93172_((PoseStack)stack, (int)0, (int)0, (int)234, (int)172, (int)(Mth.m_14143_((float)(this.fade * 255.0f)) << 24));
        boolean flag = false;
        int scrollX = this.getX();
        int scrollY = this.getY();
        if (mouseX >= 0 && mouseX < 235 && mouseY >= 0 && mouseY < 173) {
            for (SkillNodeScreen nodeScreen : this.nodes.values()) {
                if (!nodeScreen.isMouseOver((float)mouseX / this.zoom, (float)mouseY / this.zoom, scrollX, scrollY)) continue;
                flag = true;
                stack.m_85836_();
                stack.m_85841_(this.zoom, this.zoom, 1.0f);
                nodeScreen.drawHover(stack, (float)mouseX / this.zoom, (float)mouseY / this.zoom, this.fade, scrollX, scrollY);
                stack.m_85849_();
                break;
            }
        }
        stack.m_85849_();
        this.fade = flag ? Mth.m_14036_((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : Mth.m_14036_((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
    }

    public void mouseDragged(double mouseX, double mouseY, int mouseButton, double xDragged, double yDragged) {
        this.scrollX += xDragged;
        this.scrollY += yDragged;
        this.center();
    }

    private void center() {
        this.scrollX = Mth.m_14008_((double)this.scrollX, (double)this.minX, (double)this.maxX);
        this.scrollY = Mth.m_14008_((double)this.scrollY, (double)this.minY, (double)this.maxY);
    }

    public Component getTitle() {
        return this.title;
    }

    private int getX() {
        int centerX = 117;
        centerX = (int)((double)centerX + this.scrollX);
        centerX = (int)((float)centerX / this.zoom);
        return centerX;
    }

    private int getY() {
        int centerY = 20;
        centerY = (int)((double)centerY + this.scrollY);
        centerY = (int)((float)centerY / this.zoom);
        return centerY;
    }

    @Nullable
    public ISkill<?> getSelected(int mouseX, int mouseY) {
        int i = this.getX();
        int j = this.getY();
        for (SkillNodeScreen screen : this.nodes.values()) {
            ISkill selected = screen.getSelectedSkill((float)mouseX / this.zoom, (float)mouseY / this.zoom, i, j);
            if (selected == null) continue;
            return selected;
        }
        return null;
    }

    public int getRemainingPoints() {
        return this.skillHandler.getLeftSkillPoints();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        double scrollXP = this.scrollX * (double)this.zoom;
        double scrollYP = this.scrollY * (double)this.zoom;
        float heightZoom = this.zoom = (float)((double)this.zoom + amount / 25.0);
        float widthZoom = this.zoom;
        if (this.zoom * (float)this.treeHeight < 172.0f) {
            heightZoom = Math.max(this.zoom, 172.0f / (float)this.treeHeight);
        }
        if (this.zoom * (float)this.treeWidth < 214.0f) {
            widthZoom = Math.max(this.zoom, 214.0f / (float)Math.max(60, this.treeWidth));
        }
        this.zoom = Math.min(heightZoom, widthZoom);
        this.zoom = Math.min(1.0f, this.zoom);
        this.scrollX = scrollXP / (double)this.zoom;
        this.scrollY = scrollYP / (double)this.zoom;
        this.recalculateBorders();
        return true;
    }

    public void drawDisableText(@NotNull PoseStack mStack) {
        if (this.minecraft.f_91074_.m_21124_((MobEffect)ModEffects.OBLIVION.get()) == null) {
            return;
        }
        MutableComponent f = Component.m_237115_((String)"text.vampirism.skill.unlock_unavailable").m_130940_(ChatFormatting.WHITE);
        FormattedCharSequence s = Language.m_128107_().m_5536_((FormattedText)f);
        int tooltipTextWidth = 219;
        int tooltipX = 7;
        int tooltipY = 17;
        Objects.requireNonNull(this.minecraft.f_91062_);
        int tooltipHeight = 9 * 2;
        int backgroundColor = -258276348;
        int borderColorStart = 1348406284;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        int zLevel = 0;
        mStack.m_85836_();
        Matrix4f mat = mStack.m_85850_().m_252922_();
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        MultiBufferSource.BufferSource renderType = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        mStack.m_85837_(0.0, 0.0, (double)zLevel);
        this.minecraft.f_91062_.m_272191_(s, (float)tooltipX + (float)tooltipTextWidth / 2.0f - (float)this.minecraft.f_91062_.m_92852_((FormattedText)f) / 2.0f, (float)tooltipY + (float)tooltipHeight / 2.0f - 3.0f, -1, true, mat, (MultiBufferSource)renderType, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        renderType.m_109911_();
        mStack.m_85849_();
    }
}

