/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class LevelUpCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"levelup").requires(context -> context.m_6761_(2))).executes(context -> LevelUpCommand.levelUp((CommandContext<CommandSourceStack>)context, Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).m_81375_()})))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91460_()).executes(context -> LevelUpCommand.levelUp((CommandContext<CommandSourceStack>)context, EntityArgument.m_91477_((CommandContext)context, (String)"player"))));
    }

    private static int levelUp(@NotNull CommandContext<CommandSourceStack> context, @NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)player);
            if (handler.getCurrentLevel() == 0) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"command.vampirism.base.levelup.nofaction", (Object[])new Object[]{players.size() > 1 ? player.m_5446_() : "Player"}));
                continue;
            }
            if (handler.getCurrentLevel() == handler.getCurrentFaction().getHighestReachableLevel()) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"command.vampirism.base.levelup.max", (Object[])new Object[]{players.size() > 1 ? player.m_5446_() : "Player"}), true);
                continue;
            }
            if (handler.setFactionAndLevel(handler.getCurrentFaction(), handler.getCurrentLevel() + 1)) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"command.vampirism.base.levelup.newlevel", (Object[])new Object[]{player.m_7755_(), handler.getCurrentFaction().getName(), handler.getCurrentLevel()}), true);
                continue;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)(players.size() > 1 ? Component.m_237110_((String)"command.vampirism.failed_to_execute.players", (Object[])new Object[]{player.m_5446_()}) : Component.m_237115_((String)"command.vampirism.failed_to_execute")));
        }
        return 0;
    }
}

