/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.command.arguments.MinionArgument;
import de.teamlapen.vampirism.entity.minion.management.MinionInventory;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.misc.VampirismLogger;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MinionInventoryCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_PLAYER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.vampirism.base.minion_inventory.no_player"));
    private static final SimpleCommandExceptionType NO_MINION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.vampirism.base.minion_inventory.no_minion"));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext builderContext) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"modifyMinionInventory").requires(context -> context.m_6761_(3))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"minion", (ArgumentType)MinionArgument.minions()).then(Commands.m_82127_((String)"list").executes(context -> MinionInventoryCommand.listInventory((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), MinionArgument.getId((CommandContext<CommandSourceStack>)context, "minion"))))).then(Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)builderContext)).executes(context -> MinionInventoryCommand.removeItem((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), MinionArgument.getId((CommandContext<CommandSourceStack>)context, "minion"), ItemArgument.m_120963_((CommandContext)context, (String)"item"), 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> MinionInventoryCommand.removeItem((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), MinionArgument.getId((CommandContext<CommandSourceStack>)context, "minion"), ItemArgument.m_120963_((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"))))))).then(Commands.m_82127_((String)"add").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)builderContext)).executes(context -> MinionInventoryCommand.addItem((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), MinionArgument.getId((CommandContext<CommandSourceStack>)context, "minion"), ItemArgument.m_120963_((CommandContext)context, (String)"item"), 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> MinionInventoryCommand.addItem((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), MinionArgument.getId((CommandContext<CommandSourceStack>)context, "minion"), ItemArgument.m_120963_((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count")))))));
    }

    private static int addItem(CommandSourceStack source, ServerPlayer player, MinionArgument.MinionId playerMinionIdentifier, ItemInput item, int count) throws CommandSyntaxException {
        ItemStack itemStack = item.m_120980_(count, true);
        MinionInventoryCommand.getInventory(playerMinionIdentifier).ifPresent(minionInventory -> {
            minionInventory.addItemStack(itemStack.m_41777_());
            VampirismLogger.info(VampirismLogger.MINION_INVENTORY, "{} added {} {} to inventory of {}", player.m_7755_().getString(), itemStack.m_41613_(), itemStack.m_41611_().getString(), playerMinionIdentifier);
            source.m_243053_((Component)Component.m_237110_((String)"command.vampirism.base.minion_inventory.add_success", (Object[])new Object[]{itemStack.m_41613_(), itemStack.m_41611_().getString(), playerMinionIdentifier}).m_130940_(ChatFormatting.AQUA));
        });
        return 0;
    }

    private static int removeItem(CommandSourceStack source, ServerPlayer player, MinionArgument.MinionId playerMinionIdentifier, ItemInput item, int count) throws CommandSyntaxException {
        MinionInventoryCommand.getInventory(playerMinionIdentifier).ifPresent(minionInventory -> {
            List itemStacks = minionInventory.getAllInventorys().stream().flatMap(Collection::stream).filter(item).toList();
            if (!itemStacks.isEmpty()) {
                ItemStack stack = ((ItemStack)itemStacks.get(0)).m_41620_(count);
                player.m_36356_(stack.m_41777_());
                VampirismLogger.info(VampirismLogger.MINION_INVENTORY, "{} removed {} {} from inventory of {}", player.m_7755_().getString(), stack.m_41613_(), stack.m_41611_().getString(), playerMinionIdentifier);
                source.m_81354_((Component)Component.m_237110_((String)"command.vampirism.base.minion_inventory.item_removed", (Object[])new Object[]{stack.m_41613_(), stack.m_41611_().getString(), playerMinionIdentifier}).m_130940_(ChatFormatting.AQUA), false);
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"command.vampirism.base.minion_inventory.item_not_found"));
            }
        });
        return 0;
    }

    private static int listInventory(CommandSourceStack source, ServerPlayer player, MinionArgument.MinionId playerMinionIdentifier) throws CommandSyntaxException {
        MinionInventoryCommand.getInventory(playerMinionIdentifier).ifPresent(inv -> {
            HashMap count = new HashMap();
            inv.getAllInventorys().stream().flatMap(Collection::stream).filter(stack -> !stack.m_41619_()).forEach(item -> count.merge(item.m_41720_(), item.m_41613_(), Integer::sum));
            if (count.isEmpty()) {
                source.m_81354_((Component)Component.m_237110_((String)"command.vampirism.base.minion_inventory.empty", (Object[])new Object[]{playerMinionIdentifier}).m_130940_(ChatFormatting.AQUA), false);
            } else {
                VampirismLogger.info(VampirismLogger.MINION_INVENTORY, "{} views inventory of {}", player.m_7755_().getString(), playerMinionIdentifier);
                source.m_81354_((Component)Component.m_237110_((String)"command.vampirism.base.minion_inventory.content", (Object[])new Object[]{playerMinionIdentifier}).m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.UNDERLINE), false);
                source.m_81354_((Component)Component.m_237113_((String)count.entrySet().stream().map(a -> a.getValue() + " " + RegUtil.id((Item)a.getKey())).collect(Collectors.joining("\n"))).m_130940_(ChatFormatting.AQUA), false);
            }
        });
        return 0;
    }

    private static Optional<MinionInventory> getInventory(MinionArgument.MinionId playerMinionIdentifier) throws CommandSyntaxException {
        String playerName = playerMinionIdentifier.player;
        int minionId = playerMinionIdentifier.id;
        MinionWorldData data = MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer());
        GameProfile profile = (GameProfile)ServerLifecycleHooks.getCurrentServer().m_129927_().m_10996_(playerName).orElseThrow(() -> ((SimpleCommandExceptionType)NO_PLAYER).create());
        PlayerMinionController controller = data.getController(profile.getId());
        if (controller == null) {
            throw NO_MINION.create();
        }
        Optional<MinionInventory> minionInventory = controller.contactMinionData(minionId, minionData -> {
            playerMinionIdentifier.updateName(minionData.getFormattedName().getString());
            return minionData.getInventory();
        });
        if (minionInventory.isEmpty()) {
            throw NO_MINION.create();
        }
        return minionInventory;
    }
}

