/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.VampirismMod;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class VersionCheckCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return VersionCheckCommand.setup(Commands.m_82127_((String)"checkForUpdate"));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> setup(@NotNull ArgumentBuilder<CommandSourceStack, ?> builder) {
        return builder.requires(context -> context.m_6761_(0)).executes(VersionCheckCommand::changelog);
    }

    private static int changelog(@NotNull CommandContext<CommandSourceStack> context) {
        if (!VampirismMod.instance.getVersionInfo().isNewVersionAvailable()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"command.vampirism.base.changelog.newversion"), false);
            return 0;
        }
        VersionChecker.Version newVersion = VampirismMod.instance.getVersionInfo().getNewVersion();
        List<String> changes = newVersion.getChanges();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GREEN + "Vampirism " + newVersion.name + "(" + SharedConstants.m_183709_().m_132493_() + ")")), true);
        for (String c : changes) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("-" + c)), false);
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)""), false);
        String homepage = VampirismMod.instance.getVersionInfo().getHomePage();
        MutableComponent download = Component.m_237115_((String)"text.vampirism.update_message.download").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, newVersion.getUrl() == null ? homepage : newVersion.getUrl())).m_131162_(Boolean.valueOf(true)).m_131157_(ChatFormatting.BLUE));
        MutableComponent changelog = Component.m_237115_((String)"text.vampirism.update_message.changelog").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vampirism checkForUpdate")).m_131162_(Boolean.valueOf(true)));
        MutableComponent modpage = Component.m_237115_((String)"text.vampirism.update_message.modpage").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, homepage)).m_131162_(Boolean.valueOf(true)).m_131157_(ChatFormatting.BLUE));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"").m_7220_((Component)download).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)changelog).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)modpage), false);
        return 1;
    }
}

