/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.players.GameProfileCache;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public class MinionArgument
implements ArgumentType<MinionId> {
    private final Supplier<Collection<MinionId>> playerMinionIds;

    public MinionArgument() {
        this.playerMinionIds = this::getPlayerMinionIds;
    }

    public MinionArgument(Collection<MinionId> playerMinionIds) {
        this.playerMinionIds = () -> playerMinionIds;
    }

    public static MinionArgument minions() {
        return new MinionArgument();
    }

    public static MinionId getId(CommandContext<CommandSourceStack> source, String argumentId) {
        return (MinionId)source.getArgument(argumentId, MinionId.class);
    }

    private Collection<MinionId> getPlayerMinionIds() {
        MinionWorldData data = MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer());
        GameProfileCache profileCache = ServerLifecycleHooks.getCurrentServer().m_129927_();
        return data.getControllers().entrySet().stream().flatMap(entry -> profileCache.m_11002_((UUID)entry.getKey()).stream().flatMap(k -> ((PlayerMinionController)entry.getValue()).getMinionIdForName(k.getName()).stream())).collect(Collectors.toList());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining();
        this.filterResources((Iterable)this.playerMinionIds.get(), s, MinionId::toEscaped, arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    <T> void filterResources(Iterable<T> p_210512_0_, String p_210512_1_, Function<T, String> p_210512_2_, Consumer<String> consumer) {
        for (T t : p_210512_0_) {
            String id = p_210512_2_.apply(t);
            if (!SharedSuggestionProvider.m_82949_((String)p_210512_1_, (String)id)) continue;
            consumer.accept(id);
        }
    }

    public MinionId parse(StringReader reader) throws CommandSyntaxException {
        StringBuilder builder = new StringBuilder();
        boolean isQuotes = false;
        while (reader.canRead()) {
            char c = reader.peek();
            if (c == '\"') {
                isQuotes = !isQuotes;
                reader.skip();
                continue;
            }
            if (c == ' ' && !isQuotes) break;
            builder.append(c);
            reader.skip();
        }
        return new MinionId(builder.toString());
    }

    public static class MinionId {
        public final String player;
        public final int id;
        public String name;

        public MinionId(String player, int id, String name) {
            this.player = player;
            this.id = id;
            this.name = name;
        }

        public MinionId(String id) throws NumberFormatException {
            int first = id.indexOf(58);
            this.player = id.substring(0, first);
            int second = id.indexOf(47);
            if (second == -1) {
                this.id = Integer.parseInt(id.substring(first + 1));
                this.name = "";
            } else {
                this.id = Integer.parseInt(id.substring(first + 1, second));
                this.name = id.length() > second + 1 ? id.substring(second + 1) : "";
            }
        }

        public void updateName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.player + ":" + this.id + "/" + this.name;
        }

        public String toEscaped() {
            Object res = StringEscapeUtils.escapeJava((String)this.toString());
            if (((String)res).contains(" ")) {
                res = "\"" + (String)res + "\"";
            }
            return res;
        }
    }

    public static class Info
    implements ArgumentTypeInfo<MinionArgument, Template> {
        public void serializeToNetwork(Template tempalte, FriendlyByteBuf buffer) {
            Collection<MinionId> ids = tempalte.ids;
            buffer.m_130130_(ids.size());
            ids.forEach(id -> buffer.m_130070_(id.toString()));
        }

        @NotNull
        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            ArrayList<MinionId> ids = new ArrayList<MinionId>(size);
            for (int i = 0; i < size; ++i) {
                ids.add(new MinionId(buffer.m_130277_()));
            }
            return new Template(ids);
        }

        public void serializeToJson(Template template, JsonObject json) {
            JsonArray array = new JsonArray();
            template.ids.forEach(id -> array.add(id.toString()));
            json.add("playerMinionIds", (JsonElement)array);
        }

        @NotNull
        public Template unpack(@NotNull MinionArgument argument) {
            return new Template(argument.playerMinionIds.get());
        }

        public class Template
        implements ArgumentTypeInfo.Template<MinionArgument> {
            final Collection<MinionId> ids;

            public Template(Collection<MinionId> ids) {
                this.ids = ids;
            }

            @NotNull
            public MinionArgument instantiate(@NotNull CommandBuildContext context) {
                return new MinionArgument(this.ids);
            }

            @NotNull
            public ArgumentTypeInfo<MinionArgument, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

