/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TaskArgument
implements ArgumentType<Task> {
    public static final DynamicCommandExceptionType TASK_NOT_FOUND = new DynamicCommandExceptionType(particle -> Component.m_237110_((String)"command.vampirism.argument.task.notfound", (Object[])new Object[]{particle}));
    private static final Collection<String> EXAMPLES = Collections.singletonList("modid:task");

    @NotNull
    public static TaskArgument tasks() {
        return new TaskArgument();
    }

    public static Task getTask(@NotNull CommandContext<CommandSourceStack> context, String name) {
        return (Task)context.getArgument(name, Task.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_(RegUtil.keys(ModRegistries.TASKS), (SuggestionsBuilder)builder);
    }

    @NotNull
    public Task parse(@NotNull StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.m_135818_((StringReader)reader);
        Task task = RegUtil.getTask(id);
        if (task == null) {
            throw TASK_NOT_FOUND.create((Object)id);
        }
        return task;
    }
}

