/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class ModTags {
    @NotNull
    private static ResourceLocation forge(@NotNull String resourceName) {
        return new ResourceLocation("forge", resourceName);
    }

    @NotNull
    private static ResourceLocation vanilla(@NotNull String resourceName) {
        return new ResourceLocation(resourceName);
    }

    public static class DamageTypes {
        public static final TagKey<DamageType> ENTITY_PHYSICAL = DamageTypes.tag("entity_physical");

        @NotNull
        private static TagKey<DamageType> tag(@NotNull String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("vampirism", name));
        }
    }

    public static class Professions {
        public static final TagKey<VillagerProfession> HAS_FACTION = Professions.tag("has_faction");
        public static final TagKey<VillagerProfession> IS_VAMPIRE = Professions.tag("is_vampire");
        public static final TagKey<VillagerProfession> IS_HUNTER = Professions.tag("is_hunter");

        @NotNull
        private static TagKey<VillagerProfession> tag(@NotNull String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256749_, (ResourceLocation)new ResourceLocation("vampirism", name));
        }
    }

    public static class PoiTypes {
        public static final TagKey<PoiType> HAS_FACTION = PoiTypes.tag("has_faction");
        public static final TagKey<PoiType> IS_VAMPIRE = PoiTypes.tag("is_vampire");
        public static final TagKey<PoiType> IS_HUNTER = PoiTypes.tag("is_hunter");

        @NotNull
        private static TagKey<PoiType> tag(@NotNull String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("vampirism", name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> IS_FACTION_BIOME = Biomes.tag("has_faction");
        public static final TagKey<Biome> IS_VAMPIRE_BIOME = Biomes.tag("has_faction/vampire");
        public static final TagKey<Biome> IS_HUNTER_BIOME = Biomes.tag("has_faction/hunter");

        @NotNull
        private static TagKey<Biome> tag(@NotNull String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("vampirism", name));
        }

        public static class NoSpawn {
            public static final TagKey<Biome> VAMPIRE = Biomes.tag("no_spawn/vampire");
            public static final TagKey<Biome> ADVANCED_VAMPIRE = Biomes.tag("no_spawn/advanced_vampire");
            public static final TagKey<Biome> HUNTER = Biomes.tag("no_spawn/hunter");
            public static final TagKey<Biome> ADVANCED_HUNTER = Biomes.tag("no_spawn/advanced_hunter");
        }

        public static class HasSpawn {
            public static final TagKey<Biome> VAMPIRE = Biomes.tag("has_spawn/vampire");
            public static final TagKey<Biome> ADVANCED_VAMPIRE = Biomes.tag("has_spawn/advanced_vampire");
            public static final TagKey<Biome> HUNTER = Biomes.tag("has_spawn/hunter");
            public static final TagKey<Biome> ADVANCED_HUNTER = Biomes.tag("has_spawn/advanced_hunter");
        }

        public static class HasStructure {
            public static final TagKey<Biome> HUNTER_TENT = Biomes.tag("has_structure/hunter_tent");
            public static final TagKey<Biome> VAMPIRE_DUNGEON = Biomes.tag("has_structure/vampire_dungeon");
        }
    }

    public static class Fluids {
        public static final TagKey<Fluid> BLOOD = Fluids.tag("vampirism_blood");
        public static final TagKey<Fluid> IMPURE_BLOOD = Fluids.tag("vampirism_impure_blood");

        @NotNull
        private static TagKey<Fluid> tag(@NotNull ResourceLocation resourceLocation) {
            return FluidTags.create((ResourceLocation)resourceLocation);
        }

        @NotNull
        private static TagKey<Fluid> tag(@NotNull String name) {
            return Fluids.tag(new ResourceLocation("vampirism", name));
        }
    }

    public static class Entities {
        public static final TagKey<EntityType<?>> HUNTER = Entities.tag("hunter");
        public static final TagKey<EntityType<?>> VAMPIRE = Entities.tag("vampire");
        public static final TagKey<EntityType<?>> ADVANCED_HUNTER = Entities.tag("advanced_hunter");
        public static final TagKey<EntityType<?>> ADVANCED_VAMPIRE = Entities.tag("advanced_vampire");
        public static final TagKey<EntityType<?>> ZOMBIES = Entities.tag("zombies");

        @NotNull
        private static TagKey<EntityType<?>> tag(@NotNull ResourceLocation resourceLocation) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)resourceLocation);
        }

        @NotNull
        private static TagKey<EntityType<?>> tag(@NotNull String name) {
            return Entities.tag(new ResourceLocation("vampirism", name));
        }
    }

    public static class Items {
        public static final TagKey<Item> CROSSBOW_ARROW = Items.tag("crossbow_arrow");
        public static final TagKey<Item> HUNTER_INTEL = Items.tag("hunter_intel");
        public static final TagKey<Item> PURE_BLOOD = Items.tag("pure_blood");
        public static final TagKey<Item> VAMPIRE_CLOAK = Items.tag("vampire_cloak");
        public static final TagKey<Item> CASTLE_BLOCK = Items.tag("castle_block");
        public static final TagKey<Item> GARLIC = Items.tag(ModTags.forge("crops/garlic"));
        public static final TagKey<Item> HOLY_WATER = Items.tag("holy_water");
        public static final TagKey<Item> HOLY_WATER_SPLASH = Items.tag("holy_water_splash");
        public static final TagKey<Item> CASTLE_STAIRS = Items.tag("castle_stairs");
        public static final TagKey<Item> CASTLE_SLAPS = Items.tag("castle_slaps");
        public static final TagKey<Item> CURSEDEARTH = Items.tag("cursed_earth");
        public static final TagKey<Item> DARK_SPRUCE_LOG = Items.tag("dark_spruce_log");
        public static final TagKey<Item> CURSED_SPRUCE_LOG = Items.tag("cursed_spruce_log");
        public static final TagKey<Item> HEART = Items.tag("heart");
        public static final TagKey<Item> APPLICABLE_OIL_SWORD = Items.tag("applicable_oil/sword");
        public static final TagKey<Item> APPLICABLE_OIL_PICKAXE = Items.tag("applicable_oil/pickaxe");
        public static final TagKey<Item> APPLICABLE_OIL_ARMOR = Items.tag("applicable_oil/armor");

        @NotNull
        private static TagKey<Item> tag(@NotNull ResourceLocation resourceLocation) {
            return ItemTags.create((ResourceLocation)resourceLocation);
        }

        @NotNull
        private static TagKey<Item> tag(@NotNull String name) {
            return Items.tag(new ResourceLocation("vampirism", name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> CASTLE_BLOCK = Blocks.tag("castle_block");
        public static final TagKey<Block> CURSED_EARTH = Blocks.tag("cursed_earth");
        public static final TagKey<Block> CASTLE_STAIRS = Blocks.tag("castle_stairs");
        public static final TagKey<Block> CASTLE_SLAPS = Blocks.tag("castle_slaps");
        public static final TagKey<Block> DARK_SPRUCE_LOG = Blocks.tag("dark_spruce_log");
        public static final TagKey<Block> CURSED_SPRUCE_LOG = Blocks.tag("cursed_spruce_log");
        public static final TagKey<Block> TOTEM_TOP_CRAFTED = Blocks.tag("totem_top_crafted");
        public static final TagKey<Block> TOTEM_TOP_FRAGILE = Blocks.tag("totem_top_fragile");
        public static final TagKey<Block> TOTEM_TOP = Blocks.tag("totem_top");
        public static final TagKey<Block> COFFIN = Blocks.tag("coffin");

        @NotNull
        private static TagKey<Block> tag(@NotNull ResourceLocation resourceLocation) {
            return BlockTags.create((ResourceLocation)resourceLocation);
        }

        @NotNull
        private static TagKey<Block> tag(@NotNull String name) {
            return Blocks.tag(new ResourceLocation("vampirism", name));
        }
    }
}

