/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModCommands;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRefinementSets;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTasks;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.IVampirismBoat;
import de.teamlapen.vampirism.entity.action.EntityActions;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.entity.player.lord.actions.LordActions;
import de.teamlapen.vampirism.entity.player.lord.skills.LordSkills;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.misc.VampirismDispenseBoatBehavior;
import de.teamlapen.vampirism.world.gen.VampirismFeatures;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class RegistryManager
implements IInitListener {
    public RegistryManager() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onMissingMappings);
    }

    public static void setupRegistries(@NotNull IEventBus modbus) {
        ModRegistries.init(modbus);
        ModAttributes.register(modbus);
        ModBiomes.register(modbus);
        ModBlocks.register(modbus);
        ModContainer.register(modbus);
        ModEffects.register(modbus);
        ModEnchantments.register(modbus);
        ModEntities.register(modbus);
        ModFeatures.register(modbus);
        ModFluids.register(modbus);
        ModItems.register(modbus);
        ModLoot.register(modbus);
        ModParticles.register(modbus);
        ModPotions.register(modbus);
        ModRecipes.register(modbus);
        ModRefinements.register(modbus);
        ModRefinementSets.register(modbus);
        ModSounds.register(modbus);
        ModTasks.register(modbus);
        ModTiles.register(modbus);
        ModVillage.register(modbus);
        VampireActions.register(modbus);
        HunterActions.register(modbus);
        EntityActions.register(modbus);
        MinionTasks.register(modbus);
        LordActions.register(modbus);
        LordSkills.register(modbus);
        VampireSkills.register(modbus);
        HunterSkills.register(modbus);
        ModCommands.register(modbus);
        ModOils.register(modbus);
        VampirismFeatures.register(modbus);
    }

    @SubscribeEvent
    public void onBuildRegistries(NewRegistryEvent event) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntities::onModifyEntityTypeAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntities::onRegisterEntityTypeAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntities::onRegisterSpawns);
    }

    @Override
    public void onInitStep(@NotNull IInitListener.Step step, @NotNull ParallelDispatchEvent event) {
        switch (step) {
            case COMMON_SETUP: {
                ModEntities.registerConvertibles();
                ModEntities.registerCustomExtendedCreatures();
                ModItems.registerCraftingRecipes();
                ModPotions.registerPotionMixes();
                ModAdvancements.registerAdvancementTrigger();
                event.enqueueWork(() -> {
                    ModEntities.initializeEntities();
                    ModStats.registerCustomStats();
                    ModVillage.villagerTradeSetup();
                });
                ModTiles.registerTileExtensionsUnsafe();
                DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.DARK_SPRUCE_BOAT.get()), (DispenseItemBehavior)new VampirismDispenseBoatBehavior(IVampirismBoat.BoatType.DARK_SPRUCE));
                DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.CURSED_SPRUCE_BOAT.get()), (DispenseItemBehavior)new VampirismDispenseBoatBehavior(IVampirismBoat.BoatType.CURSED_SPRUCE));
            }
            case LOAD_COMPLETE: {
                if (ModEffects.checkNightVision()) {
                    event.enqueueWork(ModEffects::fixNightVisionEffectTypesUnsafe);
                }
                ModRecipes.registerDefaultLiquidColors();
                break;
            }
        }
    }

    public void onMissingMappings(@NotNull MissingMappingsEvent event) {
        VampireSkills.fixMappings(event);
        HunterSkills.fixMappings(event);
        ModPotions.fixMappings(event);
        ModTiles.fixMappings(event);
        ModItems.fixMappings(event);
        ModBlocks.fixMappings(event);
        ModEnchantments.fixMapping(event);
        ModEntities.fixMapping(event);
        ModEffects.fixMappings(event);
    }

    @SubscribeEvent
    public void onRegisterEffects(@NotNull RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.MOB_EFFECTS)) {
            ModEffects.replaceEffects((IForgeRegistry<MobEffect>)event.getForgeRegistry());
        }
    }
}

