/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data;

import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.GarlicBlock;
import de.teamlapen.vampirism.blocks.MedChairBlock;
import de.teamlapen.vampirism.blocks.VampirismSplitBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.mixin.VanillaBlockLootAccessor;
import de.teamlapen.vampirism.world.loot.conditions.AdjustableLevelCondition;
import de.teamlapen.vampirism.world.loot.conditions.StakeCondition;
import de.teamlapen.vampirism.world.loot.conditions.TentSpawnerCondition;
import de.teamlapen.vampirism.world.loot.functions.AddBookNbtFunction;
import de.teamlapen.vampirism.world.loot.functions.RefinementSetFunction;
import de.teamlapen.vampirism.world.loot.functions.SetItemBloodChargeFunction;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class LootTablesGenerator
extends LootTableProvider {
    public static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public LootTablesGenerator(PackOutput output) {
        super(output, ModLootTables.getLootTables(), List.of(new LootTableProvider.SubProviderEntry(ModEntityLootTables::new, LootContextParamSets.f_81415_), new LootTableProvider.SubProviderEntry(ModChestLootTables::new, LootContextParamSets.f_81411_), new LootTableProvider.SubProviderEntry(ModBlockLootTables::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(InjectLootTables::new, LootContextParamSets.f_81411_)));
    }

    protected void validate(@NotNull Map<ResourceLocation, LootTable> map, @NotNull ValidationContext validationtracker) {
        for (ResourceLocation resourcelocation : Sets.difference(ModLootTables.getLootTables(), map.keySet())) {
            validationtracker.m_79357_("Missing built-in table: " + resourcelocation);
        }
        map.forEach((resourceLocation, lootTable) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)resourceLocation, (LootTable)lootTable));
    }

    private static class InjectLootTables
    implements LootTableSubProvider {
        private InjectLootTables() {
        }

        public void m_245126_(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.abandoned_mineshaft, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)4.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_FANG.get())).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ITEM_GARLIC.get())).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.BLOOD_BOTTLE.get())).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BOOK.get())).m_79707_(5).m_79078_(AddBookNbtFunction.builder())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(40))).m_79161_(LootPool.m_79043_().name("swiftness_armor").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(88))).m_79161_(LootPool.m_79043_().name("hunter_weapons").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUNTER_AXE_ULTIMATE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(95))).m_79161_(LootPool.m_79043_().name("vampire_weapons").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HEART_SEEKER_ENHANCED.get())).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HEART_STRIKER_ENHANCED.get())).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60))).m_79161_(LootPool.m_79043_().name("holy_water").m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HOLY_WATER_BOTTLE_NORMAL.get())).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get())).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get())).m_79707_(10))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AMULET.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RING.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OBI_BELT.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.desert_pyramid, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ITEM_GARLIC.get())).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.BLOOD_BOTTLE.get())).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.6f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BOOK.get())).m_79707_(8).m_79078_(AddBookNbtFunction.builder())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AMULET.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RING.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OBI_BELT.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.jungle_temple, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ITEM_GARLIC.get())).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.BLOOD_BOTTLE.get())).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BOOK.get())).m_79707_(20).m_79078_(AddBookNbtFunction.builder())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_FANG.get())).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(30))).m_79161_(LootPool.m_79043_().name("swiftness_armor").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get())).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get())).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get())).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get())).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(72))).m_79161_(LootPool.m_79043_().name("hunter_coat").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get())).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUNTER_COAT_CHEST_ULTIMATE.get())).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get())).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUNTER_COAT_FEET_ULTIMATE.get())).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(72))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AMULET.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RING.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OBI_BELT.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.stronghold_corridor, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ITEM_GARLIC.get())).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BOOK.get())).m_79707_(20).m_79078_(AddBookNbtFunction.builder())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(27))).m_79161_(LootPool.m_79043_().name("swiftness_armor").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(80))).m_79161_(LootPool.m_79043_().name("vampire_weapons").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HEART_SEEKER_ENHANCED.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HEART_STRIKER_ENHANCED.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(80))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AMULET.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RING.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OBI_BELT.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.stronghold_library, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BOOK.get())).m_79707_(1).m_79078_(AddBookNbtFunction.builder()))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AMULET.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RING.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OBI_BELT.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
        }
    }

    private static class ModBlockLootTables
    extends BlockLootSubProvider {
        protected ModBlockLootTables() {
            super(VanillaBlockLootAccessor.getEXPLOSION_RESISTANT(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.m_245724_((Block)ModBlocks.ALCHEMICAL_CAULDRON.get());
            this.m_245724_((Block)ModBlocks.ALTAR_INFUSION.get());
            this.m_245724_((Block)ModBlocks.ALTAR_INSPIRATION.get());
            this.m_247577_((Block)ModBlocks.ALTAR_PILLAR.get(), this.m_247033_((ItemLike)ModBlocks.ALTAR_PILLAR.get()).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42018_).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModBlocks.ALTAR_PILLAR.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(AltarPillarBlock.TYPE_PROPERTY, "stone")))).m_79076_(LootItem.m_79579_((ItemLike)Items.f_41913_).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModBlocks.ALTAR_PILLAR.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(AltarPillarBlock.TYPE_PROPERTY, "iron")))).m_79076_(LootItem.m_79579_((ItemLike)Items.f_41912_).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModBlocks.ALTAR_PILLAR.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(AltarPillarBlock.TYPE_PROPERTY, "gold")))).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42262_).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModBlocks.ALTAR_PILLAR.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(AltarPillarBlock.TYPE_PROPERTY, "bone"))))));
            this.m_245724_((Block)ModBlocks.ALTAR_TIP.get());
            CoffinBlock.COFFIN_BLOCKS.values().forEach(coffin -> this.m_246481_((Block)coffin, block -> this.m_245178_((Block)block, (Property)CoffinBlock.PART, (Comparable)((Object)CoffinBlock.CoffinPart.HEAD))));
            this.m_245724_((Block)ModBlocks.BLOOD_CONTAINER.get());
            this.m_245724_((Block)ModBlocks.BLOOD_GRINDER.get());
            this.m_245724_((Block)ModBlocks.BLOOD_PEDESTAL.get());
            this.m_245724_((Block)ModBlocks.POTION_TABLE.get());
            this.m_245724_((Block)ModBlocks.BLOOD_SIEVE.get());
            this.m_245724_((Block)ModBlocks.CASTLE_BLOCK_DARK_BRICK.get());
            this.m_245724_((Block)ModBlocks.CASTLE_BLOCK_DARK_BRICK_BLOODY.get());
            this.m_245724_((Block)ModBlocks.CASTLE_BLOCK_DARK_STONE.get());
            this.m_245724_((Block)ModBlocks.CASTLE_BLOCK_NORMAL_BRICK.get());
            this.m_245724_((Block)ModBlocks.CASTLE_BLOCK_PURPLE_BRICK.get());
            this.m_245724_((Block)ModBlocks.CASTLE_SLAB_DARK_BRICK.get());
            this.m_245724_((Block)ModBlocks.CASTLE_SLAB_DARK_STONE.get());
            this.m_245724_((Block)ModBlocks.CASTLE_SLAB_PURPLE_BRICK.get());
            this.m_245724_((Block)ModBlocks.CASTLE_STAIRS_DARK_BRICK.get());
            this.m_245724_((Block)ModBlocks.CASTLE_STAIRS_DARK_STONE.get());
            this.m_245724_((Block)ModBlocks.CASTLE_STAIRS_PURPLE_BRICK.get());
            this.m_245724_((Block)ModBlocks.STRIPPED_DARK_SPRUCE_LOG.get());
            this.m_245724_((Block)ModBlocks.STRIPPED_CURSED_SPRUCE_LOG.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_PLANKS.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_PLANKS.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_TRAPDOOR.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_TRAPDOOR.get());
            this.m_246481_((Block)ModBlocks.DARK_SPRUCE_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_246481_((Block)ModBlocks.CURSED_SPRUCE_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_245724_((Block)ModBlocks.ALTAR_CLEANSING.get());
            this.m_245724_((Block)ModBlocks.CURSED_EARTH.get());
            this.m_245724_((Block)ModBlocks.FIRE_PLACE.get());
            this.m_247577_((Block)ModBlocks.GARLIC.get(), (LootTable.Builder)this.m_246108_((ItemLike)ModBlocks.GARLIC.get(), (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ITEM_GARLIC.get())))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModBlocks.GARLIC.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)GarlicBlock.f_52244_, 7))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ITEM_GARLIC.get())).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3))))));
            this.m_245724_((Block)ModBlocks.GARLIC_DIFFUSER_WEAK.get());
            this.m_245724_((Block)ModBlocks.GARLIC_DIFFUSER_NORMAL.get());
            this.m_245724_((Block)ModBlocks.GARLIC_DIFFUSER_IMPROVED.get());
            this.m_245724_((Block)ModBlocks.HUNTER_TABLE.get());
            this.m_246481_((Block)ModBlocks.MED_CHAIR.get(), block -> this.m_245178_((Block)block, (Property)MedChairBlock.PART, (Comparable)((Object)MedChairBlock.EnumPart.BOTTOM)));
            this.m_245724_((Block)ModBlocks.SUNSCREEN_BEACON.get());
            this.m_247577_((Block)ModBlocks.TENT_MAIN.get(), this.m_247033_((ItemLike)ModItems.ITEM_TENT.get()).m_79161_(LootPool.m_79043_().name("bonus").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(TentSpawnerCondition.builder()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42410_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42406_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50705_))));
            this.m_245724_((Block)ModBlocks.TOTEM_BASE.get());
            this.m_245724_((Block)ModBlocks.TOTEM_TOP_CRAFTED.get());
            this.m_247577_((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE_CRAFTED.get(), this.m_247033_((ItemLike)ModBlocks.TOTEM_TOP_CRAFTED.get()));
            this.m_247577_((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER_CRAFTED.get(), this.m_247033_((ItemLike)ModBlocks.TOTEM_TOP_CRAFTED.get()));
            this.m_247577_((Block)ModBlocks.TOTEM_TOP.get(), ModBlockLootTables.m_246386_());
            this.m_247577_((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER.get(), ModBlockLootTables.m_246386_());
            this.m_247577_((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE.get(), ModBlockLootTables.m_246386_());
            this.m_245724_((Block)ModBlocks.VAMPIRE_ORCHID.get());
            this.m_245724_((Block)ModBlocks.WEAPON_TABLE.get());
            this.m_247577_((Block)ModBlocks.TENT.get(), ModBlockLootTables.m_246386_());
            this.m_246535_((Block)ModBlocks.POTTED_VAMPIRE_ORCHID.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_SAPLING.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_SAPLING.get());
            this.m_246481_((Block)ModBlocks.DARK_SPRUCE_LEAVES.get(), block -> this.m_246047_((Block)block, (Block)ModBlocks.DARK_SPRUCE_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
            this.m_245724_((Block)ModBlocks.CHANDELIER.get());
            this.m_247577_((Block)ModBlocks.CANDELABRA_WALL.get(), this.m_247033_((ItemLike)ModItems.ITEM_CANDELABRA.get()));
            this.m_247577_((Block)ModBlocks.CANDELABRA.get(), this.m_247033_((ItemLike)ModItems.ITEM_CANDELABRA.get()));
            this.m_246481_((Block)ModBlocks.CROSS.get(), p_218567_0_ -> this.m_245178_((Block)p_218567_0_, (Property)VampirismSplitBlock.PART, (Comparable)((Object)VampirismSplitBlock.Part.MAIN)));
            this.m_245724_((Block)ModBlocks.TOMBSTONE1.get());
            this.m_245724_((Block)ModBlocks.TOMBSTONE2.get());
            this.m_246481_((Block)ModBlocks.TOMBSTONE3.get(), context -> this.m_245178_((Block)context, (Property)VampirismSplitBlock.PART, (Comparable)((Object)VampirismSplitBlock.Part.MAIN)));
            this.m_245724_((Block)ModBlocks.GRAVE_CAGE.get());
            this.m_247577_((Block)ModBlocks.CURSED_GRASS.get(), this.m_247033_((ItemLike)ModBlocks.CURSED_EARTH.get()));
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_LOG.get());
            this.m_246535_((Block)ModBlocks.POTTED_CURSED_ROOTS.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_LOG.get());
            this.m_247577_((Block)ModBlocks.DIRECT_CURSED_BARK.get(), ModBlockLootTables.m_246386_());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_STAIRS.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_STAIRS.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_WOOD.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_WOOD.get());
            this.m_245724_((Block)ModBlocks.STRIPPED_DARK_SPRUCE_WOOD.get());
            this.m_245724_((Block)ModBlocks.STRIPPED_CURSED_SPRUCE_WOOD.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_SIGN.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_SIGN.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_WALL_SIGN.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_WALL_SIGN.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_PRESSURE_PLACE.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_PRESSURE_PLACE.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_BUTTON.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_BUTTON.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_SLAB.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_SLAB.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_FENCE_GATE.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_FENCE_GATE.get());
            this.m_245724_((Block)ModBlocks.DARK_SPRUCE_FENCE.get());
            this.m_245724_((Block)ModBlocks.CURSED_SPRUCE_FENCE.get());
            this.m_246481_((Block)ModBlocks.CURSED_ROOTS.get(), block -> ModBlockLootTables.m_247184_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))))));
            this.m_245724_((Block)ModBlocks.VAMPIRE_RACK.get());
            this.m_246481_((Block)ModBlocks.THRONE.get(), p_218567_0_ -> this.m_245178_((Block)p_218567_0_, (Property)VampirismSplitBlock.PART, (Comparable)((Object)VampirismSplitBlock.Part.MAIN)));
            this.m_245724_((Block)ModBlocks.ALCHEMY_TABLE.get());
            this.m_247577_((Block)ModBlocks.DIAGONAL_CURSED_BARK.get(), ModBlockLootTables.m_246386_());
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.getAllBlocks();
        }
    }

    private static class ModChestLootTables
    implements LootTableSubProvider {
        private ModChestLootTables() {
        }

        public void m_245126_(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.chest_hunter_trainer, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)9.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BLOOD_BOTTLE.get())).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ITEM_GARLIC.get())).m_79707_(40))).m_79161_(LootPool.m_79043_().name("book").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BOOK.get())).m_79707_(50).m_79078_(AddBookNbtFunction.builder())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(95))).m_79161_(LootPool.m_79043_().name("hunter_weapons").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUNTER_AXE_ULTIMATE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(95))).m_79161_(LootPool.m_79043_().name("swiftness_armor").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60))).m_79161_(LootPool.m_79043_().name("hunter_coat").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUNTER_COAT_CHEST_ULTIMATE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUNTER_COAT_FEET_ULTIMATE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60))).m_79161_(LootPool.m_79043_().name("holy_water").m_165133_((NumberProvider)ConstantValue.m_165692_((float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PURE_SALT.get())).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HOLY_WATER_BOTTLE_NORMAL.get())).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get())).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get())).m_79707_(10))));
            consumer.accept(ModLootTables.chest_vampire_dungeon, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)7.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_FANG.get())).m_79707_(35)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.BLOOD_BOTTLE.get())).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).m_79161_(LootPool.m_79043_().name("book").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BOOK.get())).m_79707_(70).m_79078_(AddBookNbtFunction.builder())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(30))).m_79161_(LootPool.m_79043_().name("equipment").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HEART_SEEKER_ENHANCED.get())).m_79707_(21).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.99f))).m_79078_(SetItemBloodChargeFunction.builder((NumberProvider)UniformGenerator.m_165780_((float)500.0f, (float)2000.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HEART_SEEKER_ULTIMATE.get())).m_79707_(9).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.99f))).m_79078_(SetItemBloodChargeFunction.builder((NumberProvider)UniformGenerator.m_165780_((float)500.0f, (float)2000.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HEART_STRIKER_ENHANCED.get())).m_79707_(21).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.99f))).m_79078_(SetItemBloodChargeFunction.builder((NumberProvider)UniformGenerator.m_165780_((float)500.0f, (float)2000.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HEART_STRIKER_ULTIMATE.get())).m_79707_(9).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.99f))).m_79078_(SetItemBloodChargeFunction.builder((NumberProvider)UniformGenerator.m_165780_((float)500.0f, (float)2000.0f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(40))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AMULET.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RING.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OBI_BELT.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
        }
    }

    private static class ModEntityLootTables
    extends EntityLootSubProvider {
        protected ModEntityLootTables() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        @NotNull
        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return ModEntities.getAllEntities().stream();
        }

        public void m_246942_() {
            CompoundTag splash = new CompoundTag();
            splash.m_128379_("splash", true);
            LootTable.Builder advanced_hunter = LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("general").m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BLOOD_BOTTLE.get())).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ITEM_GARLIC.get())).m_79707_(4).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)splash))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)splash))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PURE_SALT_WATER.get())).m_79707_(4).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79161_(LootPool.m_79043_().name("special").m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.05f, (float)0.01f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BOOK.get())).m_79707_(1).m_79078_(AddBookNbtFunction.builder())));
            this.m_245309_((EntityType)ModEntities.ADVANCED_HUNTER.get(), advanced_hunter);
            this.m_245309_((EntityType)ModEntities.ADVANCED_HUNTER_IMOB.get(), advanced_hunter);
            LootTable.Builder advanced_vampire = LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("general").m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BLOOD_BOTTLE.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.BLOOD_BOTTLE.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.5f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).m_79161_(LootPool.m_79043_().name("special").m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.1f, (float)0.01f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BOOK.get())).m_79707_(1).m_79078_(AddBookNbtFunction.builder()))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.05f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AMULET.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RING.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OBI_BELT.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))));
            this.m_245309_((EntityType)ModEntities.ADVANCED_VAMPIRE.get(), advanced_vampire);
            this.m_245309_((EntityType)ModEntities.ADVANCED_VAMPIRE_IMOB.get(), advanced_vampire);
            this.m_245309_((EntityType)ModEntities.BLINDING_BAT.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.CONVERTED_CREATURE.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.CONVERTED_CREATURE_IMOB.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.CONVERTED_SHEEP.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.CONVERTED_COW.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.CONVERTED_HORSE.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.CONVERTED_DONKEY.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.CONVERTED_MULE.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.DUMMY_CREATURE.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.HUNTER_TRAINER.get(), LootTable.m_79147_());
            LootTable.Builder vampire = LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("general").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.33f, (float)0.05f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_FANG.get())).m_79707_(1))).m_79161_(LootPool.m_79043_().name("special").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(StakeCondition.builder(LootContext.EntityTarget.KILLER_PLAYER)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.5f, (float)0.05f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VAMPIRE_BLOOD_BOTTLE.get())).m_79707_(1))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.02f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AMULET.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RING.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OBI_BELT.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))));
            this.m_245309_((EntityType)ModEntities.VAMPIRE.get(), vampire);
            this.m_245309_((EntityType)ModEntities.VAMPIRE_IMOB.get(), vampire);
            this.m_245309_((EntityType)ModEntities.VAMPIRE_BARON.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("pure_blood_0").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(AdjustableLevelCondition.builder(0, LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PURE_BLOOD_0.get())).m_79707_(1))).m_79161_(LootPool.m_79043_().name("pure_blood_1").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(AdjustableLevelCondition.builder(1, LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PURE_BLOOD_1.get())).m_79707_(1))).m_79161_(LootPool.m_79043_().name("pure_blood_2").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(AdjustableLevelCondition.builder(2, LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PURE_BLOOD_2.get())).m_79707_(1))).m_79161_(LootPool.m_79043_().name("pure_blood_3").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(AdjustableLevelCondition.builder(3, LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PURE_BLOOD_3.get())).m_79707_(1))).m_79161_(LootPool.m_79043_().name("pure_blood_4").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(AdjustableLevelCondition.builder(4, LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PURE_BLOOD_4.get())).m_79707_(1))));
            LootTable.Builder hunter = LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("general").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.33f, (float)0.005f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HUMAN_HEART.get())).m_79707_(1))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.05f, (float)0.02f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AMULET.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RING.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OBI_BELT.get())).m_79707_(1).m_79078_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))));
            this.m_245309_((EntityType)ModEntities.HUNTER.get(), hunter);
            this.m_245309_((EntityType)ModEntities.HUNTER_IMOB.get(), hunter);
            this.m_245309_((EntityType)ModEntities.VILLAGER_ANGRY.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.VILLAGER_CONVERTED.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.TASK_MASTER_VAMPIRE.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.TASK_MASTER_HUNTER.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.VAMPIRE_MINION.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)ModEntities.HUNTER_MINION.get(), LootTable.m_79147_());
        }
    }
}

